<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;
use CodeIgniter\I18n\Time;

class InitialSeeder extends Seeder
{
    public function run()
    {
        // Seed Aktivitas
        $dataAktivitas = [
            [
                'tanggal' => '2023-10-01',
                'nama_aktivitas' => 'Belajar CodeIgniter 4',
                'keterangan' => 'Mempelajari routing dan controller.',
                'created_at' => Time::now(),
                'updated_at' => Time::now(),
            ],
            [
                'tanggal' => '2023-10-02',
                'nama_aktivitas' => 'Setup Database',
                'keterangan' => 'Membuat migrasi dan seeder.',
                'created_at' => Time::now(),
                'updated_at' => Time::now(),
            ]
        ];
        $this->db->table('aktivitas')->insertBatch($dataAktivitas);

        // Seed Biodata
        $dataBiodata = [
            'nama' => 'Kartika Rahma Dewi',
            'tanggal_lahir' => '2005-06-11',
            'alamat' => 'Kp. Jayanti Dukuh, Des. Cikande, Kec. Jayanti, RT 17 RW 03',
            'email' => 'rahmauym@gmail.com',
            'no_hp' => '081617941143',
            'riwayat_singkat' => 'Saya adalah seorang individu yang berdedikasi dan memiliki semangat belajar yang tinggi. Saya memiliki ketertarikan besar dalam dunia teknologi dan pengembangan diri. Saat ini sedang menempuh pendidikan semester 5 di Universitas Yatsi Madani.',
            'foto' => 'kartika.jpg',
            'created_at' => Time::now(),
            'updated_at' => Time::now(),
        ];
        // Ensure only one biodata for this simple app or insert one
        $this->db->table('biodata')->insert($dataBiodata);

        // Seed Pendidikan
        $dataPendidikan = [
            [
                'jenjang' => 'SD',
                'nama_sekolah' => 'MI Alhasanah',
                'tahun_masuk' => 2011,
                'tahun_lulus' => 2017,
                'created_at' => Time::now(),
                'updated_at' => Time::now(),
            ],
            [
                'jenjang' => 'SMP',
                'nama_sekolah' => 'Daarul Falahiyyah',
                'tahun_masuk' => 2017,
                'tahun_lulus' => 2020,
                'created_at' => Time::now(),
                'updated_at' => Time::now(),
            ],
            [
                'jenjang' => 'SMA',
                'nama_sekolah' => 'Daarul Falahiyyah',
                'tahun_masuk' => 2020,
                'tahun_lulus' => 2023,
                'created_at' => Time::now(),
                'updated_at' => Time::now(),
            ],
            [
                'jenjang' => 'Kuliah',
                'nama_sekolah' => 'Universitas Yatsi Madani',
                'tahun_masuk' => 2023,
                'tahun_lulus' => 2027, // Est. lulus
                'created_at' => Time::now(),
                'updated_at' => Time::now(),
            ]
        ];
        $this->db->table('pendidikan')->insertBatch($dataPendidikan);
    }
}
