<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'Login - Portal Berita Produksi' ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            min-height: 100vh;
            font-family: 'Poppins', 'Segoe UI', sans-serif;
            position: relative;
            overflow-x: hidden;
            background: #0f1e3c;
        }

        /* Background dengan gambar halamanhalamanlogin.jpg */
        body::before {
            content: "";
            position: fixed;
            inset: 0;
            background: url('<?= base_url('images/halamanhalamanlogin.jpg') ?>') center/cover no-repeat;
            z-index: -2;
        }

        body::after {
            content: "";
            position: fixed;
            inset: 0;
            background: rgba(15, 30, 60, 0.3);
            z-index: -1;
        }

        /* Header Navigation - Transparan */
        .header-nav {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            background: transparent;
            padding: 20px 60px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            z-index: 1000;
        }

        .logo-text {
            color: #fff;
            font-size: 1.8rem;
            font-weight: 700;
            text-decoration: none;
            letter-spacing: 1px;
        }

        .nav-right {
            display: flex;
            align-items: center;
            gap: 30px;
        }

        .nav-menu {
            display: flex;
            list-style: none;
            gap: 35px;
            align-items: center;
            margin: 0;
            padding: 0;
        }

        .nav-menu li {
            position: relative;
        }

        .nav-menu a {
            color: #fff;
            text-decoration: none;
            font-size: 1.05rem;
            font-weight: 500;
            padding: 10px 0;
            position: relative;
            transition: color 0.3s ease;
        }

        .nav-menu a:hover {
            color: #87ceeb;
        }

        /* Efek garis putih berjalan di bawah menu */
        .nav-menu a::after {
            content: "";
            position: absolute;
            bottom: 0;
            left: 0;
            width: 0;
            height: 2px;
            background: #fff;
            transition: width 0.4s ease;
        }

        .nav-menu a:hover::after,
        .nav-menu a.active::after {
            width: 100%;
            animation: slideLine 0.4s ease;
        }

        @keyframes slideLine {
            from {
                left: 50%;
                width: 0;
            }
            to {
                left: 0;
                width: 100%;
            }
        }

        .login-btn {
            background: transparent;
            border: 2px solid #fff;
            color: #fff;
            padding: 12px 32px;
            border-radius: 6px;
            text-decoration: none;
            font-weight: 600;
            font-size: 1rem;
            transition: all 0.3s ease;
        }

        .login-btn:hover {
            background: #fff;
            color: #0f1e3c;
            transform: translateY(-2px);
        }

        /* Main Content */
        .main-content {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 140px 20px 40px;
        }

        /* Glassmorphism Login Modal - Lebih lebar */
        .login-modal {
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(30px);
            -webkit-backdrop-filter: blur(30px);
            border-radius: 20px;
            padding: 60px 55px;
            width: 100%;
            max-width: 520px;
            box-shadow: 0 15px 50px rgba(0, 0, 0, 0.5), 
                        0 0 0 1px rgba(255, 255, 255, 0.1) inset;
            border: 1px solid rgba(255, 255, 255, 0.2);
            position: relative;
        }

        .close-btn {
            position: absolute;
            top: 25px;
            right: 25px;
            width: 40px;
            height: 40px;
            border-radius: 8px;
            background: #2c3e50;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.3s ease;
            border: none;
            font-size: 1.4rem;
            color: #fff;
            font-weight: 300;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
        }

        .close-btn:hover {
            background: #34495e;
            transform: rotate(90deg);
        }

        .login-title {
            color: #2c3e50;
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 40px;
            text-align: center;
        }

        .form-group {
            margin-bottom: 32px;
        }

        .form-label {
            display: block;
            color: #2c3e50;
            font-size: 1rem;
            font-weight: 600;
            margin-bottom: 12px;
        }

        .input-wrapper {
            position: relative;
            border-bottom: 2px solid rgba(44, 62, 80, 0.25);
            padding-bottom: 10px;
            transition: border-color 0.3s ease;
        }

        .input-wrapper:focus-within {
            border-bottom-color: rgba(44, 62, 80, 0.6);
        }

        /* Icon di kiri (user dan lock) */
        .input-wrapper .icon-left {
            position: absolute;
            left: 0;
            top: 50%;
            transform: translateY(-50%);
            color: rgba(44, 62, 80, 0.5);
            font-size: 1.1rem;
            pointer-events: none;
        }

        /* Icon di kanan (mata) */
        .input-wrapper .icon-right {
            position: absolute;
            right: 0;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: rgba(44, 62, 80, 0.5);
            font-size: 1.1rem;
            transition: color 0.3s ease;
            z-index: 2;
        }

        .input-wrapper .icon-right:hover {
            color: rgba(44, 62, 80, 0.8);
        }

        .form-control {
            width: 100%;
            padding: 12px 40px 12px 35px;
            background: transparent;
            border: none;
            color: #2c3e50;
            font-size: 1.05rem;
            transition: all 0.3s ease;
            outline: none;
        }

        .form-control::placeholder {
            color: rgba(44, 62, 80, 0.4);
        }

        .form-control:focus {
            color: #2c3e50;
        }

        .form-options {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 35px;
            font-size: 0.95rem;
        }

        .remember-me {
            display: flex;
            align-items: center;
            gap: 10px;
            color: #2c3e50;
            cursor: pointer;
        }

        .remember-me input {
            width: 20px;
            height: 20px;
            cursor: pointer;
            accent-color: #2c3e50;
        }

        .forgot-password {
            color: #2c3e50;
            text-decoration: none;
            transition: opacity 0.3s ease;
            font-weight: 500;
        }

        .forgot-password:hover {
            opacity: 0.7;
            text-decoration: underline;
        }

        .btn-login {
            width: 100%;
            padding: 16px;
            background: #2c3e50;
            border: none;
            border-radius: 10px;
            color: #fff;
            font-size: 1.05rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-bottom: 30px;
            box-shadow: 0 5px 20px rgba(44, 62, 80, 0.3);
        }

        .btn-login:hover {
            background: #34495e;
            transform: translateY(-2px);
            box-shadow: 0 7px 25px rgba(44, 62, 80, 0.4);
        }

        .register-link {
            text-align: center;
            color: #2c3e50;
            font-size: 0.95rem;
            margin-top: 25px;
        }

        .register-link a {
            color: #2c3e50;
            text-decoration: none;
            font-weight: 600;
        }

        .register-link a:hover {
            text-decoration: underline;
        }

        .alert {
            padding: 14px 18px;
            border-radius: 10px;
            margin-bottom: 25px;
            font-size: 0.95rem;
            background: rgba(255, 255, 255, 0.3);
            color: #2c3e50;
            border: 1px solid rgba(255, 255, 255, 0.3);
        }

        .alert-error {
            background: rgba(220, 53, 69, 0.25);
            border-color: rgba(220, 53, 69, 0.4);
            color: #721c24;
        }

        .alert-success {
            background: rgba(40, 167, 69, 0.25);
            border-color: rgba(40, 167, 69, 0.4);
            color: #155724;
        }

        @media (max-width: 768px) {
            .header-nav {
                padding: 15px 30px;
            }

            .nav-menu {
                gap: 30px;
            }

            .nav-menu a {
                font-size: 0.95rem;
            }

            .login-modal {
                padding: 50px 40px;
                max-width: 100%;
            }

            .login-title {
                font-size: 2rem;
            }
        }
    </style>
</head>
<body>
    <!-- Main Content -->
    <main class="main-content">
        <div class="login-modal">
            <button class="close-btn" onclick="window.location.href='<?= base_url() ?>'">×</button>
            
            <h1 class="login-title">Login</h1>

            <?php if (session()->getFlashdata('error')): ?>
                <div class="alert alert-error">
                    <?= session()->getFlashdata('error') ?>
                </div>
            <?php endif; ?>

            <?php if (session()->getFlashdata('success')): ?>
                <div class="alert alert-success">
                    <?= session()->getFlashdata('success') ?>
                </div>
            <?php endif; ?>

            <?php if (session()->getFlashdata('errors')): ?>
                <?php foreach (session()->getFlashdata('errors') as $error): ?>
                    <div class="alert alert-error">
                        <?= $error ?>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>

            <form action="<?= base_url('auth/processLogin') ?>" method="POST">
                <?= csrf_field() ?>

                <div class="form-group">
                    <label class="form-label">Username</label>
                    <div class="input-wrapper">
                        <i class="fas fa-user icon-left"></i>
                        <input type="text" 
                               name="username" 
                               id="username" 
                               class="form-control" 
                               placeholder="Enter your username" 
                               value="<?= old('username') ?>"
                               required>
                        <i class="fas fa-eye icon-right" id="toggleUsername"></i>
                    </div>
                </div>

                <div class="form-group">
                    <label class="form-label">Password</label>
                    <div class="input-wrapper">
                        <i class="fas fa-lock icon-left"></i>
                        <input type="password" 
                               name="password" 
                               id="password" 
                               class="form-control" 
                               placeholder="Enter your password" 
                               required>
                        <i class="fas fa-eye icon-right" id="togglePassword"></i>
                    </div>
                </div>

                <div class="form-options">
                    <label class="remember-me">
                        <input type="checkbox" name="remember" value="1" checked>
                        <span>Remember me</span>
                    </label>
                    <a href="#" class="forgot-password">Forgot Password?</a>
                </div>

                <button type="submit" class="btn-login">Login</button>
            </form>

            <div class="register-link">
                Don't have an account? <a href="#">Register</a>
            </div>
        </div>
    </main>

    <script>
        // Toggle username visibility (text tetap text, hanya untuk konsistensi UI)
        const usernameInput = document.getElementById('username');
        const toggleUsername = document.getElementById('toggleUsername');
        
        // Username selalu text, icon mata hanya untuk visual
        toggleUsername.style.display = 'none'; // Sembunyikan untuk username karena tidak perlu

        // Toggle password visibility
        const passwordInput = document.getElementById('password');
        const togglePassword = document.getElementById('togglePassword');

        togglePassword.addEventListener('click', function() {
            const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordInput.setAttribute('type', type);
            
            this.classList.toggle('fa-eye');
            this.classList.toggle('fa-eye-slash');
        });

        // Set active menu based on current page
        const currentPath = window.location.pathname;
        document.querySelectorAll('.nav-menu a').forEach(link => {
            if (link.getAttribute('href') === currentPath) {
                link.classList.add('active');
            }
        });
    </script>
</body>
</html>
