<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>

<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background-color: #f4f0eb;
        min-height: 100vh;
        position: relative;
        overflow-x: hidden;
    }

    /* Content wrapper */
    .admin-content-wrapper {
        position: relative;
        z-index: 1;
    }

    /* Header section */
    .page-header {
        background: #f4f0eb;
        border-radius: 0;
        padding: 1.5rem 0;
        margin-bottom: 1.5rem;
        border-bottom: 1px solid #e3ded6;
        display: flex;
        justify-content: space-between;
        align-items: center;
        animation: fadeInDown 0.6s ease;
    }

    @keyframes fadeInDown {
        from {
            opacity: 0;
            transform: translateY(-20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .page-header h2 {
        color: #333;
        font-weight: 600;
        font-size: 1.6rem;
        margin: 0;
    }

    .btn-add {
        background-color: #005f62; /* hijau gelap */
        border: none;
        border-radius: 999px;
        padding: 10px 22px;
        color: white;
        font-weight: 600;
        box-shadow: 0 4px 12px rgba(0, 95, 98, 0.35);
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-add:hover {
        transform: translateY(-1px);
        box-shadow: 0 6px 20px rgba(0, 95, 98, 0.4);
        color: white;
        text-decoration: none;
    }

    /* Table container */
    .table-container {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(20px);
        -webkit-backdrop-filter: blur(20px);
        border-radius: 25px;
        padding: 2rem;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.2);
        border: 1px solid rgba(255, 255, 255, 0.3);
        animation: fadeInUp 0.8s ease;
        overflow-x: auto;
    }

    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Modern table styling */
    .modern-table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0;
        margin: 0;
    }

    .modern-table thead {
        background: #6b3c3c;
        color: #fdf8f2;
    }

    .modern-table thead th {
        padding: 1.2rem 1rem;
        font-weight: 600;
        text-transform: uppercase;
        font-size: 0.85rem;
        letter-spacing: 0.5px;
        border: none;
        text-align: left;
        vertical-align: middle;
        white-space: nowrap;
    }

    .modern-table thead th:first-child {
        border-top-left-radius: 15px;
    }

    .modern-table thead th:last-child {
        border-top-right-radius: 15px;
    }

    .modern-table tbody tr {
        background: white;
        transition: all 0.3s ease;
        border-bottom: 1px solid rgba(0, 0, 0, 0.05);
    }

    .modern-table tbody tr:hover {
        background: linear-gradient(135deg, rgba(102, 126, 234, 0.05) 0%, rgba(118, 75, 162, 0.05) 100%);
        transform: scale(1.01);
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
    }

    .modern-table tbody tr:last-child {
        border-bottom: none;
    }

    .modern-table tbody td {
        padding: 1.2rem 1rem;
        vertical-align: middle;
        color: #333;
        border: none;
    }

    .modern-table tbody td:first-child {
        font-weight: 600;
        color: #667eea;
    }

    .news-title {
        font-weight: 600;
        color: #1a1a2e;
        font-size: 1.05rem;
        margin-bottom: 0.3rem;
        line-height: 1.4;
    }

    .news-date {
        color: #666;
        font-size: 0.85rem;
        display: flex;
        align-items: center;
        gap: 6px;
    }

    .news-date i {
        color: #999;
    }

    /* Status badge */
    .status-badge {
        padding: 6px 14px;
        border-radius: 20px;
        font-weight: 500;
        font-size: 0.85rem;
        display: inline-flex;
        align-items: center;
        gap: 6px;
    }

    .status-published {
        background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
        color: white;
    }

    .status-draft {
        background: linear-gradient(135deg, #6c757d 0%, #5a6268 100%);
        color: white;
    }

    /* Action buttons */
    .btn-action {
        padding: 8px 16px;
        border-radius: 8px;
        font-weight: 500;
        font-size: 0.85rem;
        border: none;
        transition: all 0.3s ease;
        display: inline-flex;
        align-items: center;
        gap: 6px;
        text-decoration: none;
        margin: 2px;
        white-space: nowrap;
    }

    .btn-action:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
        text-decoration: none;
    }

    .action-buttons {
        display: flex;
        flex-wrap: nowrap;
        gap: 6px;
        align-items: center;
    }

    .btn-preview {
        background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
        color: white;
    }

    .btn-preview:hover {
        color: white;
        background: linear-gradient(135deg, #138496 0%, #117a8b 100%);
    }

    .btn-edit {
        background: linear-gradient(135deg, #ffc107 0%, #e0a800 100%);
        color: #212529;
    }

    .btn-edit:hover {
        color: #212529;
        background: linear-gradient(135deg, #e0a800 0%, #d39e00 100%);
    }

    .btn-delete {
        background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
        color: white;
    }

    .btn-delete:hover {
        color: white;
        background: linear-gradient(135deg, #c82333 0%, #bd2130 100%);
    }

    /* Empty state */
    .empty-state {
        text-align: center;
        padding: 4rem 2rem;
        color: #666;
    }

    .empty-state i {
        font-size: 4rem;
        color: #ccc;
        margin-bottom: 1rem;
    }

    /* Modal styling */
    .modal-content {
        border-radius: 20px;
        border: none;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
    }

    .modal-header {
        border-bottom: 1px solid rgba(0, 0, 0, 0.1);
        padding: 1.5rem;
    }

    .modal-body {
        padding: 2rem;
    }

    .modal-body h2 {
        color: #333;
        margin-bottom: 1rem;
    }

    .modal-footer {
        border-top: 1px solid rgba(0, 0, 0, 0.1);
        padding: 1.5rem;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .page-header {
            flex-direction: column;
            gap: 1rem;
            align-items: flex-start;
        }

        .page-header h2 {
            font-size: 1.5rem;
        }

        .table-container {
            padding: 1rem;
        }

        .modern-table {
            font-size: 0.85rem;
        }

        .modern-table thead th,
        .modern-table tbody td {
            padding: 0.8rem 0.5rem;
        }

        .btn-action {
            padding: 6px 12px;
            font-size: 0.75rem;
        }

        .action-buttons {
            flex-wrap: wrap;
        }
    }
</style>

<div class="admin-content-wrapper">
    <div class="page-header">
        <h2><i class="fas fa-newspaper"></i> Data Berita</h2>
        <a href="<?= base_url('admin/news/new') ?>" class="btn-add">
            <i class="fas fa-plus"></i> New Post
        </a>
    </div>

    <div class="table-container">
        <?php if (empty($newses)): ?>
            <div class="empty-state">
                <i class="fas fa-newspaper"></i>
                <h4>Belum ada data berita</h4>
                <p>Mulai dengan membuat berita baru</p>
            </div>
        <?php else: ?>
            <table class="modern-table">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Title</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($newses as $index => $news): ?>
                        <tr>
                            <td><?= $index + 1 ?></td>
                            <td>
                                <div class="news-title"><?= esc($news['title']) ?></div>
                                <div class="news-date">
                                    <i class="fas fa-calendar-alt"></i>
                                    <?= date('d M Y, H:i', strtotime($news['created_at'])) ?>
                                </div>
                            </td>
                            <td>
                                <?php if($news['status'] === 'published'): ?>
                                    <span class="status-badge status-published">
                                        <i class="fas fa-check-circle"></i> <?= $news['status'] ?>
                                    </span>
                                <?php else: ?>
                                    <span class="status-badge status-draft">
                                        <i class="fas fa-file-alt"></i> <?= $news['status'] ?>
                                    </span>
                                <?php endif ?>
                            </td>
                            <td>
                                <div class="action-buttons">
                                    <a href="<?= base_url('admin/news/'.$news['id'].'/preview') ?>" 
                                       class="btn-action btn-preview" 
                                       target="_blank">
                                        <i class="fas fa-eye"></i> Preview
                                    </a>
                                    <a href="<?= base_url('admin/news/'.$news['id'].'/edit') ?>" 
                                       class="btn-action btn-edit">
                                        <i class="fas fa-edit"></i> Edit
                                    </a>
                                    <a href="#" 
                                       data-href="<?= base_url('admin/news/'.$news['id'].'/delete') ?>" 
                                       onclick="confirmToDelete(this)" 
                                       class="btn-action btn-delete">
                                        <i class="fas fa-trash"></i> Delete
                                    </a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div>

<div id="confirm-dialog" class="modal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <h2 class="h2">Apakah Anda yakin?</h2>
                <p>Data akan dihapus dan tidak dapat dikembalikan</p>
            </div>
            <div class="modal-footer">
                <a href="#" role="button" id="delete-button" class="btn btn-danger">Hapus</a>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
            </div>
        </div>
    </div>
</div>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">

<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

<script>
function confirmToDelete(el){
    $("#delete-button").attr("href", el.dataset.href);
    $("#confirm-dialog").modal('show');
}
</script>

<?= $this->endSection() ?>