<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>

<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background-color: #f4f0eb;
        min-height: 100vh;
        position: relative;
        overflow-x: hidden;
    }

    /* Content wrapper */
    .admin-content-wrapper {
        position: relative;
        z-index: 1;
    }

    /* Alert styling */
    .alert {
        border-radius: 15px;
        border: none;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        backdrop-filter: blur(10px);
        -webkit-backdrop-filter: blur(10px);
        animation: slideInDown 0.5s ease;
    }

    @keyframes slideInDown {
        from {
            opacity: 0;
            transform: translateY(-20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .alert-success {
        background: rgba(40, 167, 69, 0.9);
        color: white;
    }

    .alert-danger {
        background: rgba(220, 53, 69, 0.9);
        color: white;
    }

    /* Header section */
    .page-header {
        background: #f4f0eb;
        border-radius: 0;
        padding: 1.5rem 0;
        margin-bottom: 1.5rem;
        border-bottom: 1px solid #e3ded6;
        display: flex;
        justify-content: space-between;
        align-items: center;
        animation: fadeInDown 0.6s ease;
    }

    @keyframes fadeInDown {
        from {
            opacity: 0;
            transform: translateY(-20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .page-header h2 {
        color: #333;
        font-weight: 600;
        font-size: 1.6rem;
        margin: 0;
    }

    .btn-add {
        background-color: #005f62;
        border: none;
        border-radius: 999px;
        padding: 10px 22px;
        color: white;
        font-weight: 600;
        box-shadow: 0 4px 12px rgba(0, 95, 98, 0.35);
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-add:hover {
        transform: translateY(-1px);
        box-shadow: 0 6px 20px rgba(0, 95, 98, 0.45);
        color: white;
        text-decoration: none;
    }

    /* Table container */
    .filter-bar {
        display: flex;
        flex-wrap: wrap;
        gap: 0.75rem;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 1rem;
    }

    .filter-bar-left {
        display: flex;
        flex-wrap: wrap;
        gap: 0.75rem;
        align-items: center;
    }

    .filter-bar .form-control,
    .filter-bar .custom-select {
        border-radius: 999px;
    }

    .table-container {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(20px);
        -webkit-backdrop-filter: blur(20px);
        border-radius: 25px;
        padding: 2rem;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.2);
        border: 1px solid rgba(255, 255, 255, 0.3);
        animation: fadeInUp 0.8s ease;
        overflow-x: auto;
    }

    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Modern table styling */
    .modern-table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0;
        margin: 0;
    }

    .modern-table thead {
        background: #6b3c3c;
        color: #fdf8f2;
    }

    .modern-table thead th {
        padding: 1.2rem 1rem;
        font-weight: 600;
        text-transform: uppercase;
        font-size: 0.85rem;
        letter-spacing: 0.5px;
        border: none;
        text-align: left;
        vertical-align: middle;
        white-space: nowrap;
    }

    .modern-table thead th:first-child {
        border-top-left-radius: 15px;
    }

    .modern-table thead th:last-child {
        border-top-right-radius: 15px;
    }

    .modern-table tbody tr {
        background: white;
        transition: all 0.3s ease;
        border-bottom: 1px solid rgba(0, 0, 0, 0.05);
    }

    .modern-table tbody tr:hover {
        background: #f9f4ee;
        transform: scale(1.005);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.04);
    }

    .modern-table tbody tr:last-child {
        border-bottom: none;
    }

    .modern-table tbody td {
        padding: 1.2rem 1rem;
        vertical-align: middle;
        color: #333;
        border: none;
    }

    .modern-table tbody td:first-child {
        font-weight: 600;
        color: #6b3c3c;
    }

    /* Badge styling */
    .badge {
        padding: 6px 12px;
        border-radius: 8px;
        font-weight: 500;
        font-size: 0.85rem;
    }

    .badge-info {
        background: linear-gradient(135deg, #005f62 0%, #004349 100%);
        color: white;
    }

    .badge-primary {
        background: linear-gradient(135deg, #6b3c3c 0%, #4d2a2a 100%);
        color: white;
    }

    /* Photo styling */
    .employee-photo {
        width: 70px;
        height: 70px;
        object-fit: cover;
        border-radius: 12px;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        border: 3px solid rgba(102, 126, 234, 0.2);
        transition: all 0.3s ease;
    }

    .employee-photo:hover {
        transform: scale(1.1);
        box-shadow: 0 6px 20px rgba(102, 126, 234, 0.3);
    }

    .photo-placeholder {
        width: 70px;
        height: 70px;
        border-radius: 12px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 1.5rem;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
    }

    /* Action buttons */
    .btn-action {
        padding: 8px 16px;
        border-radius: 8px;
        font-weight: 500;
        font-size: 0.85rem;
        border: none;
        transition: all 0.3s ease;
        display: inline-flex;
        align-items: center;
        gap: 6px;
        text-decoration: none;
        margin: 2px;
        white-space: nowrap;
    }

    .action-buttons {
        display: flex;
        flex-wrap: nowrap;
        gap: 6px;
        align-items: center;
    }

    .btn-action:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
        text-decoration: none;
    }

    .btn-preview {
        background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
        color: white;
    }

    .btn-preview:hover {
        color: white;
        background: linear-gradient(135deg, #138496 0%, #117a8b 100%);
    }

    .btn-edit {
        background: linear-gradient(135deg, #ffc107 0%, #e0a800 100%);
        color: #212529;
    }

    .btn-edit:hover {
        color: #212529;
        background: linear-gradient(135deg, #e0a800 0%, #d39e00 100%);
    }

    .btn-delete {
        background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
        color: white;
    }

    .btn-delete:hover {
        color: white;
        background: linear-gradient(135deg, #c82333 0%, #bd2130 100%);
    }

    /* Empty state */
    .empty-state {
        text-align: center;
        padding: 4rem 2rem;
        color: #666;
    }

    .empty-state i {
        font-size: 4rem;
        color: #ccc;
        margin-bottom: 1rem;
    }

    /* Modal styling */
    .modal-content {
        border-radius: 20px;
        border: none;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
    }

    .modal-header {
        border-bottom: 1px solid rgba(0, 0, 0, 0.1);
        padding: 1.5rem;
    }

    .modal-body {
        padding: 2rem;
    }

    .modal-body h2 {
        color: #333;
        margin-bottom: 1rem;
    }

    .modal-footer {
        border-top: 1px solid rgba(0, 0, 0, 0.1);
        padding: 1.5rem;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .page-header {
            flex-direction: column;
            gap: 1rem;
            align-items: flex-start;
        }

        .page-header h2 {
            font-size: 1.5rem;
        }

        .table-container {
            padding: 1rem;
        }

        .modern-table {
            font-size: 0.85rem;
        }

        .modern-table thead th,
        .modern-table tbody td {
            padding: 0.8rem 0.5rem;
        }

        .btn-action {
            padding: 6px 12px;
            font-size: 0.75rem;
        }
    }
</style>

<div class="admin-content-wrapper">
    <?php if (session()->getFlashdata('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?= session()->getFlashdata('success') ?>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    <?php endif; ?>

    <?php if (session()->getFlashdata('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?= session()->getFlashdata('error') ?>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    <?php endif; ?>

    <div class="page-header">
        <h2><i class="fas fa-users"></i> Data Pegawai</h2>
        <a href="<?= base_url('admin/pegawai/create') ?>" class="btn-add">
            <i class="fas fa-plus"></i> Tambah Pegawai
        </a>
    </div>

    <div class="table-container">
        <form class="filter-bar" method="get" action="<?= base_url('admin/pegawai') ?>">
            <div class="filter-bar-left">
                <input
                    type="text"
                    name="q"
                    class="form-control"
                    style="min-width: 220px; max-width: 260px;"
                    placeholder="Cari pegawai (nama, tanggal lahir, gender, divisi)..."
                    value="<?= esc($keyword ?? '') ?>"
                >
                <select name="gender" class="custom-select" style="max-width: 190px;">
                    <option value="semua" <?= ($gender ?? 'semua') === 'semua' ? 'selected' : '' ?>>Semua Jenis Kelamin</option>
                    <option value="Laki-laki" <?= ($gender ?? '') === 'Laki-laki' ? 'selected' : '' ?>>Laki-laki</option>
                    <option value="Perempuan" <?= ($gender ?? '') === 'Perempuan' ? 'selected' : '' ?>>Perempuan</option>
                </select>
            </div>
            <button type="submit" class="btn btn-primary btn-sm" style="border-radius:999px; padding:0.4rem 1.2rem; background-color:#005f62; border-color:#005f62;">
                <i class="fas fa-search"></i> Terapkan
            </button>
        </form>

        <?php if (empty($pegawai)): ?>
            <div class="empty-state">
                <i class="fas fa-user-slash"></i>
                <h4>Belum ada data pegawai</h4>
                <p>Mulai dengan menambahkan pegawai baru</p>
            </div>
        <?php else: ?>
            <table class="modern-table">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Foto</th>
                        <th>Nama Pegawai</th>
                        <th>Tanggal Lahir</th>
                        <th>Jenis Kelamin</th>
                        <th>Divisi</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($pegawai as $index => $p): ?>
                        <tr>
                            <td><?= $index + 1 ?></td>
                            <td>
                                <?php if ($p['foto_pegawai']): ?>
                                    <img src="<?= base_url('uploads/pegawai/' . $p['foto_pegawai']) ?>" 
                                         alt="<?= esc($p['nama_pegawai']) ?>"
                                         class="employee-photo">
                                <?php else: ?>
                                    <div class="photo-placeholder">
                                        <i class="fas fa-user"></i>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td><strong><?= esc($p['nama_pegawai']) ?></strong></td>
                            <td><?= (!empty($p['tanggal_lahir'] ?? '')) ? date('d-m-Y', strtotime($p['tanggal_lahir'])) : '-' ?></td>
                            <td>
                                <span style="color: #000;"><?= esc($p['jenis_kelamin']) ?></span>
                            </td>
                            <td>
                                <span style="color: #000;"><?= esc($p['divisi'] ?? '-') ?></span>
                            </td>
                            <td>
                                <div class="action-buttons">
                                    <a href="<?= base_url('pegawai') ?>" 
                                       target="_blank"
                                       class="btn-action btn-preview">
                                        <i class="fas fa-eye"></i> Preview
                                    </a>
                                    <a href="<?= base_url('admin/pegawai/' . $p['id_pegawai'] . '/edit') ?>" 
                                       class="btn-action btn-edit">
                                        <i class="fas fa-edit"></i> Edit
                                    </a>
                                    <a href="#" 
                                       data-href="<?= base_url('admin/pegawai/' . $p['id_pegawai'] . '/delete') ?>" 
                                       onclick="confirmToDelete(this)" 
                                       class="btn-action btn-delete">
                                        <i class="fas fa-trash"></i> Hapus
                                    </a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div>

<div id="confirm-dialog" class="modal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <h2 class="h2">Apakah Anda yakin?</h2>
                <p>Data akan dihapus dan tidak dapat dikembalikan</p>
            </div>
            <div class="modal-footer">
                <a href="#" role="button" id="delete-button" class="btn btn-danger">Hapus</a>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
            </div>
        </div>
    </div>
</div>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">

<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

<script>
function confirmToDelete(el){
    $("#delete-button").attr("href", el.dataset.href);
    $("#confirm-dialog").modal('show');
}
</script>

<?= $this->endSection() ?>



