<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>

<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background-color: #f4f0eb;
        min-height: 100vh;
        position: relative;
        overflow-x: hidden;
    }

    /* Content wrapper */
    .form-wrapper {
        position: relative;
        z-index: 1;
        padding: 40px 20px;
    }

    .form-container {
        max-width: 800px;
        margin: 0 auto;
    }

    /* Form card */
    .form-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(20px);
        -webkit-backdrop-filter: blur(20px);
        border-radius: 25px;
        padding: 2.5rem;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.2);
        border: 1px solid rgba(255, 255, 255, 0.3);
        animation: fadeInUp 0.6s ease;
    }

    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Page header */
    .page-header {
        text-align: center;
        margin-bottom: 2.5rem;
        padding-bottom: 1.5rem;
        border-bottom: 2px solid rgba(102, 126, 234, 0.2);
    }

    .page-header h2 {
        color: #1a1a2e;
        font-weight: 700;
        font-size: 2rem;
        margin-bottom: 0.5rem;
    }

    .page-header i {
        color: #667eea;
        font-size: 2.5rem;
        margin-bottom: 0.5rem;
    }

    /* Alert styling */
    .alert {
        border-radius: 15px;
        border: none;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        backdrop-filter: blur(10px);
        -webkit-backdrop-filter: blur(10px);
        animation: slideInDown 0.5s ease;
        margin-bottom: 1.5rem;
    }

    @keyframes slideInDown {
        from {
            opacity: 0;
            transform: translateY(-20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .alert-danger {
        background: rgba(220, 53, 69, 0.9);
        color: white;
    }

    /* Form group styling */
    .form-group {
        margin-bottom: 1.5rem;
    }

    .form-group label {
        font-weight: 600;
        color: #1a1a2e;
        margin-bottom: 0.5rem;
        display: block;
        font-size: 0.95rem;
    }

    .form-group label .text-danger {
        color: #dc3545;
    }

    .form-control {
        border: 2px solid rgba(102, 126, 234, 0.2);
        border-radius: 12px;
        padding: 12px 16px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background: white;
    }

    .form-control:focus {
        border-color: #667eea;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        outline: none;
    }

    .form-control::placeholder {
        color: #999;
    }

    select.form-control {
        cursor: pointer;
        background-color: white;
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='20' height='20' viewBox='0 0 16 16'%3E%3Cpath fill='%23667eea' d='M8 11L3 6h10z'/%3E%3C/svg%3E");
        background-repeat: no-repeat;
        background-position: right 16px center;
        padding-right: 50px;
        appearance: none;
        -webkit-appearance: none;
        -moz-appearance: none;
        color: inherit;
        font-weight: normal;
        font-size: 1rem;
        min-height: 48px;
    }

    select.form-control:focus {
        background-color: white;
        color: inherit;
        border-color: #667eea;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.2);
    }

    select.form-control option {
        background-color: white;
        color: #333;
        padding: 12px 16px;
        font-size: 1rem;
        font-weight: normal;
    }

    select.form-control option:first-child {
        color: #999;
        font-style: italic;
    }

    select.form-control option:checked {
        background-color: #667eea;
        color: white;
    }

    /* File input styling */
    .file-input-wrapper {
        position: relative;
        display: inline-block;
        width: 100%;
    }

    .file-input-wrapper input[type="file"] {
        position: absolute;
        opacity: 0;
        width: 100%;
        height: 100%;
        cursor: pointer;
    }

    .file-input-label {
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 12px 20px;
        background-color: #6b3c3c; /* merah gelap */
        color: #ffffff !important; /* teks putih supaya kontras */
        border-radius: 12px;
        cursor: pointer;
        transition: all 0.3s ease;
        font-weight: 500;
        gap: 8px;
        box-shadow: 0 4px 15px rgba(75, 34, 34, 0.4);
    }

    .file-input-label i {
        color: #ffffff !important;
    }

    .file-input-label:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(75, 34, 34, 0.6);
    }

    .file-name {
        margin-top: 0.5rem;
        color: #667eea;
        font-size: 0.9rem;
        font-weight: 500;
    }

    /* Button styling */
    .btn-group-custom {
        display: flex;
        gap: 1rem;
        margin-top: 2rem;
    }

    .btn-custom {
        padding: 12px 30px;
        border-radius: 12px;
        font-weight: 600;
        font-size: 1rem;
        border: none;
        transition: all 0.3s ease;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        text-decoration: none;
        cursor: pointer;
    }

    .btn-primary-custom {
        background-color: #005f62; /* hijau gelap */
        color: white;
        box-shadow: 0 4px 15px rgba(0, 95, 98, 0.4);
    }

    .btn-primary-custom:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(0, 95, 98, 0.6);
        color: white;
        text-decoration: none;
    }

    .btn-secondary-custom {
        background: rgba(108, 117, 125, 0.9);
        color: white;
        box-shadow: 0 4px 15px rgba(108, 117, 125, 0.3);
    }

    .btn-secondary-custom:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(108, 117, 125, 0.4);
        color: white;
        text-decoration: none;
    }

    /* Small text styling */
    .form-text {
        color: #666;
        font-size: 0.85rem;
        margin-top: 0.5rem;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .form-wrapper {
            padding: 20px 15px;
        }

        .form-card {
            padding: 1.5rem;
        }

        .page-header h2 {
            font-size: 1.5rem;
        }

        .btn-group-custom {
            flex-direction: column;
        }

        .btn-custom {
            width: 100%;
            justify-content: center;
        }
    }
</style>

<div class="form-wrapper">
    <div class="form-container">
        <div class="form-card">
            <div class="page-header">
                <i class="fas fa-user-plus"></i>
                <h2>Tambah Data Pegawai</h2>
            </div>

            <?php if (session()->getFlashdata('errors')): ?>
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        <?php foreach (session()->getFlashdata('errors') as $error): ?>
                            <li><?= $error ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endif; ?>

            <form action="<?= base_url('admin/pegawai/create') ?>" method="POST" enctype="multipart/form-data">
                <?= csrf_field() ?>
                
                <div class="form-group">
                    <label for="nama_pegawai">
                        <i class="fas fa-user"></i> Nama Pegawai <span class="text-danger">*</span>
                    </label>
                    <input type="text" 
                           name="nama_pegawai" 
                           id="nama_pegawai" 
                           class="form-control" 
                           placeholder="Masukkan nama pegawai" 
                           value="<?= old('nama_pegawai') ?>"
                           required>
                </div>

                <div class="form-group">
                    <label for="tanggal_lahir">
                        <i class="fas fa-calendar-alt"></i> Tanggal Lahir
                    </label>
                    <input type="date" 
                           name="tanggal_lahir" 
                           id="tanggal_lahir" 
                           class="form-control" 
                           value="<?= old('tanggal_lahir') ?>">
                    <small class="form-text">Format: YYYY-MM-DD</small>
                </div>

                <div class="form-group">
                    <label for="jenis_kelamin">
                        <i class="fas fa-venus-mars"></i> Jenis Kelamin <span class="text-danger">*</span>
                    </label>
                    <select name="jenis_kelamin" id="jenis_kelamin" class="form-control" required>
                        <option value="">-- Pilih Jenis Kelamin --</option>
                        <option value="laki-laki" <?= old('jenis_kelamin') == 'laki-laki' ? 'selected' : '' ?>>Laki-laki</option>
                        <option value="perempuan" <?= old('jenis_kelamin') == 'perempuan' ? 'selected' : '' ?>>Perempuan</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="divisi">
                        <i class="fas fa-building"></i> Divisi <span class="text-danger">*</span>
                    </label>
                    <select name="divisi"
                            id="divisi"
                            class="form-control"
                            required>
                        <option value="">-- Pilih Divisi --</option>
                        <option value="IT" <?= old('divisi') === 'IT' ? 'selected' : '' ?>>IT</option>
                        <option value="HR" <?= old('divisi') === 'HR' ? 'selected' : '' ?>>HR</option>
                        <option value="Produksi" <?= old('divisi') === 'Produksi' ? 'selected' : '' ?>>Produksi</option>
                        <option value="Marketing" <?= old('divisi') === 'Marketing' ? 'selected' : '' ?>>Marketing</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="foto_pegawai">
                        <i class="fas fa-image"></i> Foto Pegawai
                    </label>
                    <div class="file-input-wrapper">
                        <input type="file" 
                               name="foto_pegawai" 
                               id="foto_pegawai" 
                               class="form-control" 
                               accept="image/*"
                               onchange="updateFileName(this)">
                        <label for="foto_pegawai" class="file-input-label">
                            <i class="fas fa-upload"></i> Pilih Foto
                        </label>
                    </div>
                    <div id="file-name" class="file-name" style="display: none;"></div>
                    <small class="form-text">Format: JPG, PNG, GIF. Maksimal 2MB</small>
                </div>

                <div class="btn-group-custom">
                    <button type="submit" class="btn-custom btn-primary-custom">
                        <i class="fas fa-save"></i> Simpan
                    </button>
                    <a href="<?= base_url('admin/pegawai') ?>" class="btn-custom btn-secondary-custom">
                        <i class="fas fa-times"></i> Batal
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<script>
function updateFileName(input) {
    const fileName = input.files[0]?.name;
    const fileNameDiv = document.getElementById('file-name');
    if (fileName) {
        fileNameDiv.textContent = 'File dipilih: ' + fileName;
        fileNameDiv.style.display = 'block';
    } else {
        fileNameDiv.style.display = 'none';
    }
}
</script>

<?= $this->endSection() ?>



