<?= $this->extend('layout/page_clean_layout') ?>

<?= $this->section('content') ?>

<section class="py-5 about-hero">
    <div class="container">
        <div class="text-center">
            <h1 class="display-5 font-weight-bold mb-3 about-main-title">Madani Yatsi Creative Industry</h1>
            <p class="lead about-subtitle">
                Kolaborasi kreatif di bidang Event Organizer, Production House, dan Talent Management yang membantu brand
                dan komunitas mewujudkan pengalaman acara yang berkesan.
            </p>
        </div>
    </div>
</section>

<section class="py-5 about-content">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="section-title">Bidang Utama</h2>
            <div class="title-underline"></div>
        </div>
        <div class="row">
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="about-card-simple">
                    <div class="card-icon" style="background: linear-gradient(135deg, #6b3c3c 0%, #8b4513 100%);">
                        <i class="fas fa-video"></i>
                    </div>
                    <div class="card-badge">Production House</div>
                    <h5 class="card-title">Produksi Konten &amp; Event</h5>
                    <p class="card-text">
                        Produksi video, dokumenter, dan konten kampanye, serta dokumentasi konser dan acara komunitas.
                    </p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="about-card-simple">
                    <div class="card-icon" style="background: linear-gradient(135deg, #005f62 0%, #004a4d 100%);">
                        <i class="fas fa-bullhorn"></i>
                    </div>
                    <div class="card-badge">Marketing &amp; Branding</div>
                    <h5 class="card-title">Marketing Event &amp; Talent</h5>
                    <p class="card-text">
                        Strategi promosi melalui event, media sosial, dan aktivasi kampanye dengan dukungan talent kreatif.
                    </p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="about-card-simple">
                    <div class="card-icon" style="background: linear-gradient(135deg, #6b3c3c 0%, #8b4513 100%);">
                        <i class="fas fa-laptop-code"></i>
                    </div>
                    <div class="card-badge">Technology</div>
                    <h5 class="card-title">IT Platform &amp; Tools</h5>
                    <p class="card-text">
                        Platform ticketing, registrasi online, dan sistem laporan untuk mempermudah pengelolaan acara.
                    </p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="about-card-simple">
                    <div class="card-icon" style="background: linear-gradient(135deg, #005f62 0%, #004a4d 100%);">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="card-badge">People</div>
                    <h5 class="card-title">HR, Talent &amp; Crew</h5>
                    <p class="card-text">
                        Manajemen talent, crew lapangan, dan tim produksi dengan standar profesional di setiap project.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
.about-hero {
    background: linear-gradient(135deg, #f4f0eb 0%, #e8e0d5 100%);
    padding: 4rem 0;
}

.about-main-title {
    color: #6b3c3c;
    letter-spacing: 0.1em;
    text-transform: uppercase;
}

.about-subtitle {
    max-width: 45rem;
    margin: 0 auto;
    color: #555;
    line-height: 1.8;
}

.about-content {
    background-color: #faf8f5;
    padding: 4rem 0;
}

.section-title {
    font-size: 2rem;
    font-weight: 700;
    color: #6b3c3c;
    margin-bottom: 1rem;
    letter-spacing: 0.05em;
}

.title-underline {
    width: 80px;
    height: 4px;
    background: linear-gradient(90deg, #6b3c3c 0%, #005f62 100%);
    margin: 0 auto 2rem;
    border-radius: 2px;
}

.about-card-simple {
    background: white;
    border-radius: 15px;
    padding: 2rem 1.5rem;
    text-align: center;
    transition: all 0.3s ease;
    border: 2px solid #f4f0eb;
    height: 100%;
    display: flex;
    flex-direction: column;
    align-items: center;
}

.about-card-simple:hover {
    transform: translateY(-8px);
    box-shadow: 0 15px 40px rgba(107, 60, 60, 0.15);
    border-color: #6b3c3c;
}

.card-icon {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1.5rem;
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
    transition: all 0.3s ease;
}

.about-card-simple:hover .card-icon {
    transform: scale(1.1) rotate(5deg);
}

.card-icon i {
    font-size: 2rem;
    color: white;
}

.card-badge {
    display: inline-block;
    padding: 0.4rem 1rem;
    border-radius: 999px;
    font-size: 0.75rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.1em;
    background: #f4f0eb;
    color: #6b3c3c;
    margin-bottom: 1rem;
}

.card-title {
    font-size: 1.25rem;
    font-weight: 700;
    color: #333;
    margin-bottom: 1rem;
    line-height: 1.4;
}

.card-text {
    color: #666;
    font-size: 0.95rem;
    line-height: 1.7;
    margin: 0;
    flex: 1;
}

/* Responsive */
@media (max-width: 991px) {
    .about-card-simple {
        margin-bottom: 2rem;
    }
}

@media (max-width: 768px) {
    .about-main-title {
        font-size: 2rem;
    }

    .section-title {
        font-size: 1.5rem;
    }

    .about-card-simple {
        padding: 1.5rem;
    }

    .card-icon {
        width: 70px;
        height: 70px;
    }

    .card-icon i {
        font-size: 1.75rem;
    }
}
</style>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<?= $this->endSection() ?>
