<?php

namespace App\Models;

use CodeIgniter\Model;

class PegawaiModel extends Model
{
    protected $table      = 'pegawai';
    protected $primaryKey = 'id_pegawai';

    protected $useAutoIncrement = true;
    protected $allowedFields = ['nama_pegawai', 'tanggal_lahir', 'jenis_kelamin', 'foto_pegawai', 'divisi'];

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    /**
     * Ambil data pegawai dengan opsi pencarian dan filter jenis kelamin.
     *
     * @param string|null $keyword  Kata kunci pencarian (mencari di semua kolom penting)
     * @param string|null $gender   Jenis kelamin: 'Laki-laki', 'Perempuan', atau null/kosong untuk semua
     * @return array
     */
    public function getFiltered(?string $keyword = null, ?string $gender = null): array
    {
        $builder = $this->builder();

        if ($keyword !== null && $keyword !== '') {
            $like = '%' . trim($keyword) . '%';
            $builder
                ->groupStart()
                ->like('nama_pegawai', $like)
                ->orLike('tanggal_lahir', $like)
                ->orLike('jenis_kelamin', $like)
                ->orLike('divisi', $like)
                ->groupEnd();
        }

        if ($gender !== null && $gender !== '' && $gender !== 'semua') {
            $builder->where('jenis_kelamin', $gender);
        }

        return $builder->orderBy('nama_pegawai', 'ASC')->get()->getResultArray();
    }
}



