<?php namespace App\Controllers;

use App\Models\PegawaiModel;

class Pegawai extends BaseController
{
	protected $pegawaiModel;

	public function __construct()
	{
		$this->pegawaiModel = new PegawaiModel();
	}

	public function index()
	{
		$request = service('request');
		$keyword = $request->getGet('q');
		$gender  = $request->getGet('gender') ?? 'semua';

		$data = [
			'title' => 'Data Pegawai',
			'pegawai' => $this->pegawaiModel->getFiltered($keyword, $gender),
			'keyword' => $keyword,
			'gender'  => $gender,
		];

		return view('pegawai/index', $data);
	}
}



