<?php

namespace Config;

use CodeIgniter\Config\BaseConfig;

class SocialAuth extends BaseConfig
{
    public string $googleClientId;
    public string $googleClientSecret;
    public string $googleRedirectUri;

    public string $facebookClientId;
    public string $facebookClientSecret;
    public string $facebookRedirectUri;

    /**
     * Only allow these emails to complete social login.
     * You can replace these with your official admin accounts.
     *
     * @var list<string>
     */
    public array $allowedEmails = [
        'admin@madaniyatsi.com',
    ];

    public function __construct()
    {
        $this->googleClientId = env('GOOGLE_CLIENT_ID', 'YOUR_GOOGLE_CLIENT_ID');
        $this->googleClientSecret = env('GOOGLE_CLIENT_SECRET', 'YOUR_GOOGLE_CLIENT_SECRET');
        $this->googleRedirectUri = env(
            'GOOGLE_REDIRECT_URI',
            base_url('auth/google/callback')
        );

        $this->facebookClientId = env('FACEBOOK_CLIENT_ID', 'YOUR_FACEBOOK_APP_ID');
        $this->facebookClientSecret = env('FACEBOOK_CLIENT_SECRET', 'YOUR_FACEBOOK_APP_SECRET');
        $this->facebookRedirectUri = env(
            'FACEBOOK_REDIRECT_URI',
            base_url('auth/facebook/callback')
        );

        parent::__construct();
    }
}








