<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Panel Admin - Naisyela</title>
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Outfit', 'sans-serif'],
                    },
                    colors: {
                        brown: {
                            50: '#efebe9',
                            100: '#d7ccc8',
                            200: '#bcaaa4',
                            300: '#a1887f',
                            400: '#8d6e63',
                            500: '#795548',
                            600: '#6d4c41',
                            700: '#5d4037',
                            800: '#4e342e',
                            900: '#3e2723',
                        },
                        cream: {
                            50: '#fff8e1',
                            100: '#ffecb3',
                            200: '#ffe082',
                            300: '#ffd54f',
                            400: '#ffca28',
                            500: '#ffc107',
                        }
                    }
                }
            }
        }
    </script>
    <script src="https://unpkg.com/lucide@latest"></script>
</head>
<body class="bg-gray-50 text-gray-800 font-sans flex h-screen overflow-hidden">

    <!-- Sidebar -->
    <aside class="w-64 bg-white border-r border-gray-200 hidden md:flex flex-col">
        <div class="h-16 flex items-center px-6 border-b border-gray-100">
            <h1 class="text-xl font-bold text-brown-600 tracking-tight">Admin Naisyela</h1>
        </div>
        <nav class="flex-1 overflow-y-auto py-4">
            <ul class="space-y-1 px-3">
                <li>
                    <a href="<?= base_url('admin') ?>" class="flex items-center px-3 py-2.5 text-gray-600 hover:bg-brown-50 hover:text-brown-600 rounded-lg transition group">
                        <i data-lucide="layout-dashboard" class="w-5 h-5 mr-3 text-gray-400 group-hover:text-brown-500"></i> Dashboard
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('admin/activities') ?>" class="flex items-center px-3 py-2.5 text-gray-600 hover:bg-brown-50 hover:text-brown-600 rounded-lg transition group">
                        <i data-lucide="calendar" class="w-5 h-5 mr-3 text-gray-400 group-hover:text-brown-500"></i> Aktivitas
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('admin/biodata') ?>" class="flex items-center px-3 py-2.5 text-gray-600 hover:bg-brown-50 hover:text-brown-600 rounded-lg transition group">
                        <i data-lucide="user" class="w-5 h-5 mr-3 text-gray-400 group-hover:text-brown-500"></i> Biodata
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('admin/education') ?>" class="flex items-center px-3 py-2.5 text-gray-600 hover:bg-brown-50 hover:text-brown-600 rounded-lg transition group">
                        <i data-lucide="graduation-cap" class="w-5 h-5 mr-3 text-gray-400 group-hover:text-brown-500"></i> Pendidikan
                    </a>
                </li>
            </ul>
        </nav>
        <div class="p-4 border-t border-gray-100">

            <a href="<?= base_url('logout') ?>" class="flex items-center px-3 py-2.5 text-gray-600 hover:bg-brown-50 hover:text-brown-600 rounded-lg transition group">
                <i data-lucide="log-out" class="w-5 h-5 mr-3 text-gray-400 group-hover:text-brown-500"></i> Keluar
            </a>
        </div>
    </aside>

    <!-- Main Content -->
    <div class="flex-1 flex flex-col overflow-hidden">
        <!-- Topbar -->
        <header class="h-16 bg-white border-b border-gray-200 flex items-center justify-between px-6 md:px-10">
            <div class="flex items-center md:hidden">
                <button class="text-gray-500 hover:text-gray-700">
                    <i data-lucide="menu" class="w-6 h-6"></i>
                </button>
                <span class="ml-4 font-bold text-gray-800">Panel Admin</span>
            </div>
            <div class="hidden md:block text-2xl font-bold text-gray-800">
                <?= $title ?? 'Dashboard' ?>
            </div>
            <div class="flex items-center gap-4">
                <a href="<?= base_url('/') ?>" target="_blank" class="hidden md:flex items-center px-4 py-2 bg-brown-50 text-brown-700 rounded-lg hover:bg-brown-100 transition font-medium text-sm">
                    <i data-lucide="external-link" class="w-4 h-4 mr-2"></i> Lihat Situs
                </a>
            </div>
        </header>

        <!-- Page Content -->
        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6 md:p-10">
            <?= $this->renderSection('content') ?>
        </main>
    </div>

    <script>
        lucide.createIcons();
    </script>
</body>
</html>
