<?= $this->extend('layout/frontend') ?>

<?= $this->section('content') ?>

<div class="text-center mb-12">
    <h1 class="text-4xl font-bold text-gray-800 mb-4">Aktivitas Harian</h1>
    <p class="text-gray-600">Kumpulan momen dan catatan harian.</p>
</div>

<!-- Search & Filter -->
<div class="max-w-4xl mx-auto mb-12">
    <form action="" method="get" class="bg-white p-4 rounded-xl shadow-sm border border-brown-50 flex flex-col md:flex-row gap-4">
        <div class="flex-1 relative">
            <i data-lucide="search" class="absolute left-3 top-3 text-gray-400 w-5 h-5"></i>
            <input type="text" name="keyword" value="<?= esc($keyword) ?>" placeholder="Cari aktivitas..." class="w-full pl-10 border-gray-200 border rounded-lg px-4 py-2 focus:ring-2 focus:ring-brown-400 focus:border-transparent outline-none">
        </div>
        <select name="sort" class="border-gray-200 border rounded-lg px-4 py-2 focus:ring-2 focus:ring-brown-400 outline-none bg-white">
            <option value="date" <?= $sort == 'date' ? 'selected' : '' ?>>Tanggal</option>
            <option value="activity_name" <?= $sort == 'activity_name' ? 'selected' : '' ?>>Nama</option>
        </select>
        <select name="order" class="border-gray-200 border rounded-lg px-4 py-2 focus:ring-2 focus:ring-brown-400 outline-none bg-white">
            <option value="desc" <?= $order == 'desc' ? 'selected' : '' ?>>Terbaru</option>
            <option value="asc" <?= $order == 'asc' ? 'selected' : '' ?>>Terlama</option>
        </select>
        <button type="submit" class="bg-brown-500 text-white px-8 py-2 rounded-lg font-medium hover:bg-brown-600 transition">
            Filter
        </button>
    </form>
</div>

<!-- Grid -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-10">
    <?php foreach ($activities as $index => $item): ?>
    <div class="bg-white rounded-[2rem] shadow-lg overflow-hidden hover:shadow-2xl transition duration-500 transform hover:-translate-y-2 border border-brown-50 flex flex-col h-full animate-fade-in-up" style="animation-delay: <?= $index * 0.05 ?>s;">
        <div class="h-48 bg-brown-50 relative group overflow-hidden">
            <?php if ($item['media']): ?>
                <div class="cursor-pointer overflow-hidden h-full w-full" onclick="openLightbox('<?= base_url('uploads/activities/' . $item['media']) ?>')">
                    <img src="<?= base_url('uploads/activities/' . $item['media']) ?>" alt="Media" class="object-cover w-full h-full transform group-hover:scale-110 transition duration-700">
                    <div class="absolute inset-0 bg-black/0 group-hover:bg-black/20 transition duration-300 flex items-center justify-center">
                        <i data-lucide="maximize-2" class="text-white opacity-0 group-hover:opacity-100 transition duration-300 transform scale-75 group-hover:scale-100 w-8 h-8"></i>
                    </div>
                </div>
            <?php else: ?>
                <div class="w-full h-full flex items-center justify-center bg-gradient-to-tr from-brown-50 to-cream-50">
                    <i data-lucide="image" class="w-20 h-20 text-brown-200 group-hover:scale-110 transition duration-500"></i>
                </div>
            <?php endif; ?>
        </div>
        <div class="p-8 flex-1 flex flex-col justify-between">
            <div>
                <div class="flex items-center gap-2 mb-4">
                    <span class="inline-block w-2.5 h-2.5 rounded-full bg-brown-400"></span>
                    <span class="text-sm font-bold text-brown-500 uppercase tracking-wider">
                        <?= date('F d, Y', strtotime($item['date'])) ?>
                    </span>
                </div>
                <h3 class="text-2xl font-bold text-gray-800 mb-4 leading-snug hover:text-brown-600 transition duration-300">
                    <?= esc($item['activity_name']) ?>
                </h3>
            </div>

        </div>
    </div>
    <?php endforeach; ?>
</div>

<?= $this->endSection() ?>

<!-- Lightbox Modal -->
<div id="lightbox" class="fixed inset-0 z-50 hidden bg-black/90 backdrop-blur-sm transition-opacity duration-300 opacity-0" onclick="closeLightbox()">
    <div class="absolute inset-0 flex items-center justify-center p-4">
        <img id="lightbox-img" src="" alt="Full View" class="max-w-full max-h-[90vh] rounded-lg shadow-2xl transform scale-95 transition-transform duration-300" onclick="event.stopPropagation()">
        <button onclick="closeLightbox()" class="absolute top-6 right-6 text-white hover:text-gray-300 transition focus:outline-none">
            <i data-lucide="x" class="w-10 h-10"></i>
        </button>
    </div>
</div>

<script>
    function openLightbox(src) {
        const lightbox = document.getElementById('lightbox');
        const img = document.getElementById('lightbox-img');
        
        img.src = src;
        lightbox.classList.remove('hidden');
        // Small delay to allow display:block to apply before changing opacity for transition
        setTimeout(() => {
            lightbox.classList.remove('opacity-0');
            img.classList.remove('scale-95');
            img.classList.add('scale-100');
        }, 10);
        document.body.style.overflow = 'hidden'; // Prevent scrolling
    }

    function closeLightbox() {
        const lightbox = document.getElementById('lightbox');
        const img = document.getElementById('lightbox-img');
        
        lightbox.classList.add('opacity-0');
        img.classList.remove('scale-100');
        img.classList.add('scale-95');
        
        setTimeout(() => {
            lightbox.classList.add('hidden');
            img.src = '';
        }, 300); // Wait for transition to finish
        document.body.style.overflow = ''; // Restore scrolling
    }

    // Close on Escape key
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
            closeLightbox();
        }
    });
</script>
