<?= $this->extend('layout/backend') ?>

<?= $this->section('content') ?>

<div class="max-w-2xl mx-auto">
    <div class="mb-6 flex items-center justify-between">
        <h1 class="text-3xl font-bold text-gray-800">Edit Pendidikan</h1>
        <a href="<?= base_url('admin/education') ?>" class="text-gray-500 hover:text-gray-700">Kembali ke Daftar</a>
    </div>

    <div class="bg-white p-8 rounded-xl shadow-md border border-brown-50">
        <?php if (session()->has('errors')): ?>
            <div class="bg-red-50 text-red-600 p-4 rounded-lg mb-6 text-sm">
                <ul>
                <?php foreach (session('errors') as $error): ?>
                    <li><?= esc($error) ?></li>
                <?php endforeach ?>
                </ul>
            </div>
        <?php endif ?>

        <form action="<?= base_url('admin/education/update/' . $education['id']) ?>" method="post">
            <div class="mb-6">
                <label class="block text-sm font-semibold text-gray-700 mb-2">Jenjang</label>
                <select name="level" class="w-full border-gray-300 border rounded-lg px-4 py-3 focus:ring-2 focus:ring-brown-500 focus:border-transparent outline-none transition">
                    <option value="SD" <?= $education['level'] == 'SD' ? 'selected' : '' ?>>SD</option>
                    <option value="SMP" <?= $education['level'] == 'SMP' ? 'selected' : '' ?>>SMP</option>
                    <option value="SMA" <?= $education['level'] == 'SMA' ? 'selected' : '' ?>>SMA</option>
                    <option value="Kuliah" <?= $education['level'] == 'Kuliah' ? 'selected' : '' ?>>Kuliah</option>
                </select>
            </div>

            <div class="mb-6">
                <label class="block text-sm font-semibold text-gray-700 mb-2">Nama Sekolah</label>
                <input type="text" name="school_name" class="w-full border-gray-300 border rounded-lg px-4 py-3 focus:ring-2 focus:ring-brown-500 focus:border-transparent outline-none transition" value="<?= old('school_name', $education['school_name']) ?>">
            </div>

            <div class="grid grid-cols-2 gap-6 mb-6">
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Tahun Mulai</label>
                    <input type="number" name="start_year" class="w-full border-gray-300 border rounded-lg px-4 py-3 focus:ring-2 focus:ring-brown-500 focus:border-transparent outline-none transition" value="<?= old('start_year', $education['start_year']) ?>">
                </div>
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Tahun Selesai</label>
                    <input type="number" name="end_year" class="w-full border-gray-300 border rounded-lg px-4 py-3 focus:ring-2 focus:ring-brown-500 focus:border-transparent outline-none transition" value="<?= old('end_year', $education['end_year']) ?>">
                </div>
            </div>

            <button type="submit" class="w-full bg-brown-600 hover:bg-brown-700 text-white font-bold py-3 rounded-lg shadow-lg hover:shadow-xl transition transform hover:-translate-y-0.5">
                Perbarui Pendidikan
            </button>
        </form>
    </div>
</div>

<?= $this->endSection() ?>
