<?= $this->extend('layout/backend') ?>

<?= $this->section('content') ?>

<div class="mb-6 flex justify-between items-center">
    <h1 class="text-3xl font-bold text-gray-800">Biodata / CV</h1>
    <a href="<?= base_url('admin/biodata/create') ?>" class="bg-brown-600 hover:bg-brown-700 text-white px-4 py-2 rounded-lg flex items-center shadow-md transition">
        <i data-lucide="plus" class="w-4 h-4 mr-2"></i> Tambah Baru
    </a>
</div>

<div class="mb-6 bg-white p-4 rounded-lg shadow-sm border border-brown-50">
    <form action="" method="get" class="flex gap-4">
        <input type="text" name="keyword" value="<?= esc($keyword) ?>" placeholder="Cari biodata..." class="flex-1 border-gray-300 border rounded-lg px-4 py-2 focus:ring-brown-500 focus:border-brown-500 outline-none">
        
        <select name="sort" class="border-gray-300 border rounded-lg px-4 py-2 focus:ring-brown-500 outline-none">
            <option value="id" <?= $sort == 'id' ? 'selected' : '' ?>>ID</option>
            <option value="name" <?= $sort == 'name' ? 'selected' : '' ?>>Nama</option>
            <option value="email" <?= $sort == 'email' ? 'selected' : '' ?>>Email</option>
        </select>
        
        <select name="order" class="border-gray-300 border rounded-lg px-4 py-2 focus:ring-brown-500 outline-none">
            <option value="asc" <?= $order == 'asc' ? 'selected' : '' ?>>A-Z</option>
            <option value="desc" <?= $order == 'desc' ? 'selected' : '' ?>>Z-A</option>
        </select>

        <button type="submit" class="bg-brown-100 text-brown-700 hover:bg-brown-200 px-6 py-2 rounded-lg font-medium transition">
            Filter
        </button>
    </form>
</div>

<div class="bg-white rounded-xl shadow-md overflow-hidden border border-gray-100">
    <table class="w-full text-left">
        <thead class="bg-brown-50 text-brown-800 font-semibold uppercase text-sm border-b border-brown-100">
            <tr>
                <th class="px-6 py-4">Foto</th>
                <th class="px-6 py-4">Nama</th>
                <th class="px-6 py-4">Kontak</th>
                <th class="px-6 py-4">Alamat</th>
                <th class="px-6 py-4 text-right">Aksi</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-100">
            <?php foreach ($biodata as $item): ?>
            <tr class="hover:bg-brown-50/50 transition duration-150">
                <td class="px-6 py-4">
                    <?php if (!empty($item['photo'])): ?>
                        <img src="<?= base_url('uploads/biodata/' . $item['photo']) ?>" alt="Foto" class="w-12 h-12 rounded-full object-cover border border-gray-200">
                    <?php else: ?>
                        <div class="w-12 h-12 rounded-full bg-brown-100 flex items-center justify-center text-brown-500">
                            <i data-lucide="user" class="w-6 h-6"></i>
                        </div>
                    <?php endif; ?>
                </td>
                <td class="px-6 py-4 font-medium text-gray-900"><?= esc($item['name']) ?></td>
                <td class="px-6 py-4">
                    <div class="text-sm text-gray-900"><?= esc($item['email']) ?></div>
                    <div class="text-sm text-gray-500"><?= esc($item['phone']) ?></div>
                </td>
                <td class="px-6 py-4 text-gray-600 truncate max-w-xs"><?= esc($item['address']) ?></td>
                <td class="px-6 py-4 text-right">
                    <a href="<?= base_url('admin/biodata/edit/' . $item['id']) ?>" class="text-brown-600 hover:text-brown-800 mr-3 font-medium text-sm">Edit</a>
                    <a href="<?= base_url('admin/biodata/delete/' . $item['id']) ?>" onclick="return confirm('Apakah Anda yakin?')" class="text-red-500 hover:text-red-700 font-medium text-sm">Hapus</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    
    <!-- Pagination removed as requested -->
</div>

<?= $this->endSection() ?>
