<?= $this->extend('layout/backend') ?>

<?= $this->section('content') ?>

<div class="max-w-2xl mx-auto">
    <div class="mb-6 flex items-center justify-between">
        <h1 class="text-3xl font-bold text-gray-800">Tambah Aktivitas</h1>
        <a href="<?= base_url('admin/activities') ?>" class="text-gray-500 hover:text-gray-700">Kembali ke Daftar</a>
    </div>

    <div class="bg-white p-8 rounded-xl shadow-md border border-brown-50">
        <?php if (session()->has('errors')): ?>
            <div class="bg-red-50 text-red-600 p-4 rounded-lg mb-6 text-sm">
                <ul>
                <?php foreach (session('errors') as $error): ?>
                    <li><?= esc($error) ?></li>
                <?php endforeach ?>
                </ul>
            </div>
        <?php endif ?>

        <form action="<?= base_url('admin/activities/store') ?>" method="post" enctype="multipart/form-data">
            <div class="mb-6">
                <label class="block text-sm font-semibold text-gray-700 mb-2">Nama Aktivitas</label>
                <input type="text" name="activity_name" class="w-full border-gray-300 border rounded-lg px-4 py-3 focus:ring-2 focus:ring-brown-500 focus:border-transparent outline-none transition" value="<?= old('activity_name') ?>" placeholder="Contoh: Jogging di taman">
            </div>

            <div class="mb-6">
                <label class="block text-sm font-semibold text-gray-700 mb-2">Tanggal</label>
                <input type="date" name="date" class="w-full border-gray-300 border rounded-lg px-4 py-3 focus:ring-2 focus:ring-brown-500 focus:border-transparent outline-none transition" value="<?= old('date') ?>">
            </div>

            <div class="mb-6">
                <label class="block text-sm font-semibold text-gray-700 mb-2">Foto Aktivitas</label>
                <input type="file" name="media" class="w-full border-gray-300 border rounded-lg px-4 py-3 focus:ring-2 focus:ring-brown-500 focus:border-transparent outline-none transition file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-brown-50 file:text-brown-700 hover:file:bg-brown-100">
            </div>

            <button type="submit" class="w-full bg-brown-600 hover:bg-brown-700 text-white font-bold py-3 rounded-lg shadow-lg hover:shadow-xl transition transform hover:-translate-y-0.5">
                Simpan Aktivitas
            </button>
        </form>
    </div>
</div>

<?= $this->endSection() ?>
