<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class AppSeeder extends Seeder
{
    public function run()
    {
        // Seed Activities
        for ($i = 1; $i <= 20; $i++) {
            $data = [
                'date'          => date('Y-m-d', strtotime("-$i days")),
                'time'          => date('H:i:s'),
                'activity_name' => "Activity Description Number $i",
                'media'         => null,
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ];
            $this->db->table('activities')->insert($data);
        }

        // Seed Biodata
        $data = [
            'name'       => 'Naisyela',
            'address'    => 'Jl. Contoh Alamat No. 123, Jakarta',
            'phone'      => '081234567890',
            'email'      => 'naisyela@example.com',
            'summary'    => 'This is a summary of Naisyela. Experienced developer and student at UYM.',
            'photo'      => null,
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        ];
        $this->db->table('biodata')->insert($data);

        // Seed Education
        $levels = [
            ['level' => 'SD', 'school' => 'SD Negeri Keramat Jati', 'start' => 2011, 'end' => 2017],
            ['level' => 'SMP', 'school' => 'SMP Negeri 2 Kresek', 'start' => 2017, 'end' => 2020],
            ['level' => 'SMK', 'school' => 'SMK Jaya Buana', 'start' => 2020, 'end' => 2023],
            ['level' => 'Kuliah', 'school' => 'Universitas Yatsi Madani', 'start' => 2023, 'end' => 2027],
        ];
        
        foreach ($levels as $l) {
            $data = [
                'level'       => $l['level'],
                'school_name' => $l['school'],
                'start_year'  => $l['start'],
                'end_year'    => $l['end'],
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ];
            $this->db->table('education')->insert($data);
        }
    }
}
