<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\EducationModel;

class Education extends BaseController
{
    protected $educationModel;

    public function __construct()
    {
        $this->educationModel = new EducationModel();
    }

    public function index()
    {
        $keyword = $this->request->getGet('keyword');
        $sort    = $this->request->getGet('sort') ?? 'id';
        $order   = $this->request->getGet('order') ?? 'desc';

        $builder = $this->educationModel->orderBy($sort, $order);

        if ($keyword) {
            $builder->like('school_name', $keyword)->orLike('level', $keyword);
        }

        $data = [
            'education' => $builder->paginate(10),
            'pager'     => $this->educationModel->pager,
            'keyword'   => $keyword,
            'sort'      => $sort,
            'order'     => $order,
        ];

        return view('backend/education/index', $data);
    }

    public function create()
    {
        return view('backend/education/create');
    }

    public function store()
    {
        if (!$this->validate([
            'level'       => 'required',
            'school_name' => 'required',
            'start_year'  => 'required|integer',
            'end_year'    => 'required|integer',
        ])) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $this->educationModel->save([
            'level'       => $this->request->getPost('level'),
            'school_name' => $this->request->getPost('school_name'),
            'start_year'  => $this->request->getPost('start_year'),
            'end_year'    => $this->request->getPost('end_year'),
        ]);

        return redirect()->to('admin/education')->with('success', 'Education added successfully.');
    }

    public function edit($id)
    {
        $data['education'] = $this->educationModel->find($id);
        if (!$data['education']) {
            return redirect()->to('admin/education')->with('error', 'Education not found.');
        }
        return view('backend/education/edit', $data);
    }

    public function update($id)
    {
        if (!$this->validate([
            'level'       => 'required',
            'school_name' => 'required',
            'start_year'  => 'required|integer',
            'end_year'    => 'required|integer',
        ])) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $this->educationModel->update($id, [
            'level'       => $this->request->getPost('level'),
            'school_name' => $this->request->getPost('school_name'),
            'start_year'  => $this->request->getPost('start_year'),
            'end_year'    => $this->request->getPost('end_year'),
        ]);

        return redirect()->to('admin/education')->with('success', 'Education updated successfully.');
    }

    public function delete($id)
    {
        $this->educationModel->delete($id);
        return redirect()->to('admin/education')->with('success', 'Education deleted successfully.');
    }
}
