<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\BiodataModel;

class Biodata extends BaseController
{
    protected $biodataModel;

    public function __construct()
    {
        $this->biodataModel = new BiodataModel();
    }

    public function index()
    {
        $keyword = $this->request->getGet('keyword');
        $sort    = $this->request->getGet('sort') ?? 'id';
        $order   = $this->request->getGet('order') ?? 'desc';

        $builder = $this->biodataModel->orderBy($sort, $order);

        if ($keyword) {
            $builder->like('name', $keyword)->orLike('summary', $keyword);
        }

        $data = [
            'biodata' => $builder->paginate(10),
            'pager'   => $this->biodataModel->pager,
            'keyword' => $keyword,
            'sort'    => $sort,
            'order'   => $order,
        ];

        return view('backend/biodata/index', $data);
    }

    public function create()
    {
        return view('backend/biodata/create');
    }

    public function store()
    {
        if (!$this->validate([
            'name'    => 'required',
            'email'   => 'required|valid_email',
            'phone'   => 'required',
            'address' => 'required',
        ])) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $file = $this->request->getFile('photo');
        $fileName = null;

        if ($file && $file->isValid() && !$file->hasMoved()) {
            $fileName = $file->getRandomName();
            $file->move('uploads/biodata', $fileName);
        }

        $this->biodataModel->save([
            'name'    => $this->request->getPost('name'),
            'email'   => $this->request->getPost('email'),
            'phone'   => $this->request->getPost('phone'),
            'address' => $this->request->getPost('address'),
            'summary' => $this->request->getPost('summary'),
            'photo'   => $fileName,
        ]);

        return redirect()->to('admin/biodata')->with('success', 'Biodata added successfully.');
    }

    public function edit($id)
    {
        $data['biodata'] = $this->biodataModel->find($id);
        if (!$data['biodata']) {
            return redirect()->to('admin/biodata')->with('error', 'Biodata not found.');
        }
        return view('backend/biodata/edit', $data);
    }

    public function update($id)
    {
        if (!$this->validate([
            'name'    => 'required',
            'email'   => 'required|valid_email',
            'phone'   => 'required',
            'address' => 'required',
        ])) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $file = $this->request->getFile('photo');
        $fileName = $this->request->getPost('old_photo');

        if ($file && $file->isValid() && !$file->hasMoved()) {
            $fileName = $file->getRandomName();
            $file->move('uploads/biodata', $fileName);

            // Delete old photo
            $oldPhoto = $this->request->getPost('old_photo');
            if ($oldPhoto && file_exists('uploads/biodata/' . $oldPhoto)) {
                unlink('uploads/biodata/' . $oldPhoto);
            }
        }

        $this->biodataModel->update($id, [
            'name'    => $this->request->getPost('name'),
            'email'   => $this->request->getPost('email'),
            'phone'   => $this->request->getPost('phone'),
            'address' => $this->request->getPost('address'),
            'summary' => $this->request->getPost('summary'),
            'photo'   => $fileName,
        ]);

        return redirect()->to('admin/biodata')->with('success', 'Biodata updated successfully.');
    }

    public function delete($id)
    {
        $this->biodataModel->delete($id);
        return redirect()->to('admin/biodata')->with('success', 'Biodata deleted successfully.');
    }
}
