<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Data Pegawai</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">

<style>
    body { background: #eef3fa; font-family: 'Segoe UI', sans-serif; }

    .card-header {
        background: #0d47a1;
        color: white;
        font-weight: 700;
        font-size: 1.5rem;
        border-radius: 12px 12px 0 0;
        padding: 1rem 1.5rem;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .card { border-radius: 15px; box-shadow: 0 5px 20px rgba(0,0,0,0.08); }

    .foto-thumb {
        width: 60px;
        height: 60px;
        object-fit: cover;
        border-radius: 10px;
        border: 2px solid #eee;
    }

    .btn-blue {
        background: #0d47a1;
        color: white;
        font-weight: 600;
        border-radius: 10px;
        transition: 0.3s;
    }
    .btn-blue:hover { opacity: 0.85; }

    table thead th {
        text-transform: uppercase;
        font-size: 0.85rem;
        letter-spacing: 0.5px;
        color: #0d47a1;
    }

    .table-striped > tbody > tr:nth-of-type(odd) {
        background-color: #f2f6fc;
    }

    @media (max-width: 767px) {
        .table-responsive { overflow-x: auto; }
        table thead { display: none; }
        table tbody td { display: block; width: 100%; padding-left: 50%; position: relative; text-align: left; }
        table tbody td::before {
            content: attr(data-label);
            position: absolute;
            left: 15px;
            width: 45%;
            font-weight: 600;
            color: #0d47a1;
        }
    }
</style>
</head>
<body>

<div class="container py-4">

<!-- HEADER -->
<div class="card mb-4">
    <div class="card-header">
        <i class="bi bi-people-fill"></i>
        Daftar Pegawai
    </div>
    <div class="card-body">

        <!-- FILTER / SEARCH -->
        <div class="card p-3 shadow mb-4" style="border-radius: 15px;">
            <form method="get" class="row g-3 align-items-end">

                <div class="col-md-4">
                    <label class="form-label fw-semibold">Cari</label>
                    <input type="text" name="keyword" class="form-control"
                           placeholder="Nama, tanggal, gender" value="<?= esc($keyword ?? '') ?>"
                           style="border-radius:10px; border:1px solid #e2e8f0; color:#2d3748; font-size:0.95rem;">
                </div>

                <div class="col-md-3">
                    <label class="form-label fw-semibold">Gender</label>
                    <select name="gender" class="form-select"
                            style="border-radius:10px; border:1px solid #e2e8f0; color:#2d3748; font-size:0.95rem;">
                        <option value="">Semua Gender</option>
                        <option value="laki-laki" <?= ($gender ?? '')=='laki-laki'?'selected':'' ?>>Laki-laki</option>
                        <option value="perempuan" <?= ($gender ?? '')=='perempuan'?'selected':'' ?>>Perempuan</option>
                    </select>
                </div>

                <div class="col-md-2">
                    <button type="submit" class="btn btn-blue w-100" style="font-weight:600;">
                        <i class="bi bi-search me-1"></i> Cari
                    </button>
                </div>

                <div class="col-md-3">
                    <a href="<?= base_url('pegawai') ?>" class="btn btn-secondary w-100" style="font-weight:600;">
                        Reset
                    </a>
                </div>

            </form>
        </div>

        <!-- TABLE -->
        <div class="table-responsive">
            <table class="table table-striped align-middle">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Foto</th>
                        <th>Nama</th>
                        <th>Gender</th>
                        <th>Divisi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(!empty($pegawai)): ?>
                        <?php foreach($pegawai as $i => $row): ?>
                            <tr>
                                <td data-label="#"> <?= $i+1 ?> </td>
                                <td data-label="Foto">
                                    <?php if($row['foto_pegawai']): ?>
                                        <img src="<?= base_url('uploads/pegawai/'.$row['foto_pegawai']) ?>" class="foto-thumb">
                                    <?php else: ?>
                                        <span class="text-muted">Tidak ada foto</span>
                                    <?php endif; ?>
                                </td>
                                <td data-label="Nama"><?= esc($row['nama_pegawai']) ?></td>
                                <td data-label="Gender"><?= esc($row['jenis_kelamin']) ?></td>
                                <td data-label="Divisi"><?= esc($row['divisi']) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5" class="text-center text-muted p-4">Belum ada pegawai ditemukan.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

    </div>
</div>

</div>

</body>
</html>

