<?= $this->extend('layout/admin/admin_layout') ?>
<?= $this->section('content') ?>

<div class="container-fluid">

    <!-- HEADER -->
    <div class="card p-3 shadow mb-4" style="border-radius:15px; border:none;">
        <div class="d-flex align-items-center gap-3" style="
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 1rem;
            border-radius: 12px;
            color: white;
            font-weight: 700;
            font-size: 1.3rem;
        ">
            <i class="bi bi-person-badge-fill" style="font-size:1.7rem;"></i>
            <span>Detail Pegawai</span>
        </div>
        <p class="mt-2 text-white-50 fw-bold" style="font-size:0.95rem;">
            Preview informasi lengkap pegawai marketing
        </p>
    </div>

    <!-- INFO PEGAWAI -->
    <div class="card p-4 shadow mb-4" style="border-radius:15px;">
        <div class="row g-4 align-items-center">

            <!-- FOTO -->
            <div class="col-md-3 text-center">
                <?php if($pegawai['foto_pegawai']): ?>
                    <img src="<?= base_url('uploads/pegawai/'.$pegawai['foto_pegawai']) ?>" 
                         class="img-fluid rounded" 
                         style="max-height:200px; border:2px solid #eee;">
                <?php else: ?>
                    <i class="bi bi-person-circle" style="font-size:120px; color:#a0aec0;"></i>
                <?php endif ?>
            </div>

            <!-- INFO DETAIL -->
            <div class="col-md-9">
                <h3 class="fw-bold"><?= esc($pegawai['nama_pegawai']) ?></h3>
                <p class="text-muted mb-1"><strong>Gender:</strong> <?= esc($pegawai['jenis_kelamin']) ?></p>
                <p class="text-muted mb-1"><strong>Tanggal Lahir:</strong> <?= date('d M Y', strtotime($pegawai['tanggal_lahir'])) ?></p>
                
                <?php if(!empty($pegawai['email'])): ?>
                <p class="text-muted mb-1"><strong>Email:</strong> <?= esc($pegawai['email']) ?></p>
                <?php endif; ?>

                <?php if(!empty($pegawai['telepon'])): ?>
                <p class="text-muted mb-1"><strong>Telepon:</strong> <?= esc($pegawai['telepon']) ?></p>
                <?php endif; ?>
            </div>

        </div>

        <!-- TOMBOL KEMBALI -->
        <div class="mt-4 text-end">
            <a href="<?= base_url('admin/pegawai') ?>" 
               class="btn"
               style="background: linear-gradient(135deg,#667eea 0%,#764ba2 100%);
                      color:white; font-weight:600; border:none; border-radius:10px; transition:0.3s;"
               onmouseover="this.style.opacity='0.85'"
               onmouseout="this.style.opacity='1'">
                <i class="bi bi-arrow-left me-1"></i> Kembali
            </a>
        </div>
    </div>

</div>

<?= $this->endSection() ?>
