<?php

namespace App\Controllers;

class Page extends BaseController
{
	public function about()
	{
		echo view("about");
	}

	public function contact()
	{
		$data['name'] = "Universitas Yatsi Madani";
		
		// Handle form submission
		if ($this->request->getMethod() === 'post') {
			// Validation rules
			$rules = [
				'name' => [
					'label' => 'Nama',
					'rules' => 'required|min_length[3]|max_length[100]',
					'errors' => [
						'required' => 'Nama harus diisi',
						'min_length' => 'Nama minimal 3 karakter',
						'max_length' => 'Nama maksimal 100 karakter'
					]
				],
				'email' => [
					'label' => 'Email',
					'rules' => 'required|valid_email|max_length[100]',
					'errors' => [
						'required' => 'Email harus diisi',
						'valid_email' => 'Format email tidak valid',
						'max_length' => 'Email maksimal 100 karakter'
					]
				],
				'message' => [
					'label' => 'Pesan',
					'rules' => 'required|min_length[10]|max_length[1000]',
					'errors' => [
						'required' => 'Pesan harus diisi',
						'min_length' => 'Pesan minimal 10 karakter',
						'max_length' => 'Pesan maksimal 1000 karakter'
					]
				]
			];

			if (!$this->validate($rules)) {
				// Validation failed
				$data['validation'] = $this->validator;
				return view("contact", $data);
			} else {
				// Validation passed - process the form
				$name = $this->request->getPost('name');
				$email = $this->request->getPost('email');
				$message = $this->request->getPost('message');

				// Here you can:
				// 1. Save to database
				// 2. Send email
				// 3. Save to file
				// For now, we'll just show success message
				
				// Example: Save to log file (you can modify this)
				$logMessage = date('Y-m-d H:i:s') . " - Contact Form Submission\n";
				$logMessage .= "Name: " . $name . "\n";
				$logMessage .= "Email: " . $email . "\n";
				$logMessage .= "Message: " . $message . "\n";
				$logMessage .= "----------------------------------------\n";
				
				// Write to log file
				$logPath = WRITEPATH . 'logs/contact_' . date('Y-m-d') . '.log';
				file_put_contents($logPath, $logMessage, FILE_APPEND);

				// Set success message
				session()->setFlashdata('success', 'Terima kasih! Pesan Anda telah berhasil dikirim. Kami akan merespons secepatnya.');

				// Redirect to prevent form resubmission
				return redirect()->to('/contact');
			}
		}

		// Show contact form
		return view("contact", $data);
	}

	public function faqs()
	{
		// membuat data untuk dikirim ke view
		$data['data_faqs'] = [
			[
				'question' => 'Apa itu Codeigniter?',
				'answer' => 'Codeigniter adalah framework untuk membuat web'
			],
			[
				'question' => 'Siapa yang membuat Codeiginter?',
				'answer' => 'CI awalnya dibuat oleh Ellislab'
			],
			[
				'question' => 'Codeigniter versi berapakah yang digunakan pada tutoril ini?',
				'answer' => 'Codeigniter versi 4.0.4'
			]
		];

		// load view dengan data
		echo view("faqs", $data);
	}
}