<?php

namespace App\Controllers;

use App\Models\AdminModel;

class AdminLogin extends BaseController
{
    public function index()
    {
        // Tampilkan form login (tidak redirect jika sudah login, biarkan user tetap bisa login lagi jika perlu)
        return view('layout/admin/Login');
    }

    public function auth()
    {
        $session = session();
        $model = new AdminModel();

        $username = $this->request->getPost('username');
        $password = $this->request->getPost('password');

        $admin = $model->where('username', $username)->first();

        if ($admin) {
            if (password_verify($password, $admin['password'])) {

                $session->set([
                    'admin_id' => $admin['id'],
                    'admin_username' => $admin['username'],
                    'logged_in_admin' => true
                ]);

                return redirect()->to('/admin/news');
            } else {
                return redirect()->back()->with('error', 'Password salah');
            }
        } else {
            return redirect()->back()->with('error', 'Username tidak ditemukan');
        }
    }

    public function logout()
    {
        session()->destroy();
        return redirect()->to('/admin/login');
    }
}
