<?php

/**
 * Script untuk membuat/update user admin
 * Username: admin
 * Password: admin123
 */

// Database configuration
$host = 'localhost';
$dbname = 'db_activity_biodata';
$username = 'root';
$password = '';

try {
    // Connect to database
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "=== Admin User Setup ===\n\n";
    echo "Koneksi database berhasil!\n\n";
    
    // Hash password
    $adminPassword = 'admin123';
    $passwordHash = password_hash($adminPassword, PASSWORD_DEFAULT);
    
    // Check if users table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'users'");
    $tableExists = $stmt->rowCount() > 0;
    
    if (!$tableExists) {
        echo "Tabel 'users' tidak ditemukan. Membuat tabel...\n";
        
        $createTable = "CREATE TABLE `users` (
            `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
            `username` varchar(100) NOT NULL,
            `password_hash` varchar(255) NOT NULL,
            `created_at` datetime DEFAULT NULL,
            `updated_at` datetime DEFAULT NULL,
            PRIMARY KEY (`id`),
            UNIQUE KEY `username` (`username`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
        
        $pdo->exec($createTable);
        echo "Tabel 'users' berhasil dibuat!\n\n";
    }
    
    // Check if admin user exists
    $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ?");
    $stmt->execute(['admin']);
    $existingUser = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($existingUser) {
        echo "User 'admin' sudah ada. Mengupdate password...\n";
        
        $stmt = $pdo->prepare("UPDATE users SET password_hash = ?, updated_at = NOW() WHERE username = ?");
        $stmt->execute([$passwordHash, 'admin']);
        
        echo "Password untuk user 'admin' berhasil diupdate!\n";
    } else {
        echo "User 'admin' belum ada. Membuat user baru...\n";
        
        $stmt = $pdo->prepare("INSERT INTO users (username, password_hash, created_at, updated_at) VALUES (?, ?, NOW(), NOW())");
        $stmt->execute(['admin', $passwordHash]);
        
        echo "User 'admin' berhasil dibuat!\n";
    }
    
    echo "\n=== Setup Selesai ===\n";
    echo "Username: admin\n";
    echo "Password: admin123\n";
    echo "\nSilakan login di: http://localhost:8080/login\n";
    
    // Verify the user
    $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ?");
    $stmt->execute(['admin']);
    $verifyUser = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($verifyUser) {
        echo "\n=== Verifikasi ===\n";
        echo "User ID: " . $verifyUser['id'] . "\n";
        echo "Username: " . $verifyUser['username'] . "\n";
        echo "Password Hash: " . substr($verifyUser['password_hash'], 0, 50) . "...\n";
        
        // Test password verification
        if (password_verify('admin123', $verifyUser['password_hash'])) {
            echo "✓ Password verification: BERHASIL\n";
        } else {
            echo "✗ Password verification: GAGAL\n";
        }
    }
    
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
    exit(1);
}
