<?= $this->extend('layout/template'); ?>

<?= $this->section('content'); ?>

<!-- Hero Section -->
<div class="hero-section mb-5">
    <div class="text-center fade-in-up">
        <div class="icon-box-modern mx-auto mb-4" style="width: 80px; height: 80px; font-size: 2.5rem;">
            <i class="bi bi-mortarboard-fill"></i>
        </div>
        <h1 class="display-4 fw-bold text-gradient-pink mb-3">Riwayat Pendidikan</h1>
        <p class="lead text-muted mb-4">Perjalanan akademis dan pencapaian pendidikan formal</p>
        <div class="d-flex justify-content-center gap-3 flex-wrap">
            <span class="badge badge-pink fs-6 px-3 py-2">
                <i class="bi bi-book me-2"></i>Pendidikan Formal
            </span>
            <span class="badge bg-light text-dark fs-6 px-3 py-2">
                <i class="bi bi-calendar-range me-2"></i>Timeline Akademis
            </span>
        </div>
    </div>
</div>

<div class="row justify-content-center">
    <div class="col-lg-10">

        <!-- Filter Card -->
        <div class="card card-pink-glow rounded-4 mb-5 border-0 fade-in-up delay-100">
            <div class="card-header bg-gradient-pink-soft border-0 py-3">
                <h5 class="mb-0 text-primary">
                    <i class="bi bi-funnel me-2"></i>Filter & Pencarian
                </h5>
            </div>
            <div class="card-body p-4">
                <form action="<?= base_url('/pendidikan'); ?>" method="get">
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label class="form-label small text-muted fw-bold">CARI SEKOLAH</label>
                            <div class="input-group">
                                <span class="input-group-text bg-white border-end-0">
                                    <i class="bi bi-search text-primary"></i>
                                </span>
                                <input type="text" class="form-control form-control-pink border-start-0 ps-0" 
                                       name="keyword" placeholder="Nama sekolah..." value="<?= esc($keyword); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label small text-muted fw-bold">JENJANG</label>
                            <select class="form-select form-control-pink" name="jenjang">
                                <option value="">Semua Jenjang</option>
                                <option value="SD" <?= $jenjang == 'SD' ? 'selected' : ''; ?>>Sekolah Dasar</option>
                                <option value="SMP" <?= $jenjang == 'SMP' ? 'selected' : ''; ?>>SMP</option>
                                <option value="SMA" <?= $jenjang == 'SMA' ? 'selected' : ''; ?>>SMA</option>
                                <option value="Kuliah" <?= $jenjang == 'Kuliah' ? 'selected' : ''; ?>>Perguruan Tinggi</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label small text-muted fw-bold">URUTAN</label>
                            <select class="form-select form-control-pink" name="order">
                                <option value="DESC" <?= $order == 'DESC' ? 'selected' : ''; ?>>Terbaru Dulu</option>
                                <option value="ASC" <?= $order == 'ASC' ? 'selected' : ''; ?>>Terlama Dulu</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label small text-muted fw-bold">AKSI</label>
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-pink-gradient flex-grow-1">
                                    <i class="bi bi-search"></i>
                                </button>
                                <a href="<?= base_url('/pendidikan'); ?>" class="btn btn-pink-outline" title="Reset Filter">
                                    <i class="bi bi-arrow-counterclockwise"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Timeline -->
        <?php if(empty($pendidikan)): ?>
            <div class="text-center py-5 fade-in-up">
                <div class="stat-card-pink mx-auto mb-4" style="width: 200px; padding: 2rem;">
                    <i class="bi bi-mortarboard fs-1 mb-3"></i>
                    <h5 class="fw-bold">Tidak Ada Data</h5>
                </div>
                <h4 class="text-gradient-pink fw-bold mb-3">Data Pendidikan Tidak Ditemukan</h4>
                <p class="text-muted mb-4">Belum ada riwayat pendidikan yang tercatat atau sesuai dengan filter yang dipilih.</p>
                <a href="<?= base_url('/pendidikan'); ?>" class="btn btn-pink-outline">
                    <i class="bi bi-arrow-counterclockwise me-2"></i>Reset Filter
                </a>
            </div>
        <?php else: ?>
            <!-- Stats Summary -->
            <div class="row g-4 mb-5 fade-in-up delay-200">
                <div class="col-md-3">
                    <div class="card card-pink-glow text-center p-3">
                        <div class="icon-box-modern mx-auto mb-2" style="width: 50px; height: 50px;">
                            <i class="bi bi-mortarboard-fill"></i>
                        </div>
                        <h5 class="text-primary fw-bold mb-0"><?= count($pendidikan); ?></h5>
                        <small class="text-muted">Total Jenjang</small>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card card-pink-glow text-center p-3">
                        <div class="icon-box-modern mx-auto mb-2" style="width: 50px; height: 50px;">
                            <i class="bi bi-calendar-range"></i>
                        </div>
                        <h5 class="text-primary fw-bold mb-0">
                            <?php 
                            $years = array_map(function($edu) {
                                return intval($edu['tahun_lulus']) - intval($edu['tahun_masuk']);
                            }, $pendidikan);
                            echo array_sum($years);
                            ?>
                        </h5>
                        <small class="text-muted">Total Tahun</small>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card card-pink-glow text-center p-3">
                        <div class="icon-box-modern mx-auto mb-2" style="width: 50px; height: 50px;">
                            <i class="bi bi-award"></i>
                        </div>
                        <h5 class="text-primary fw-bold mb-0">
                            <?= !empty($pendidikan) ? min(array_column($pendidikan, 'tahun_masuk')) : '-'; ?>
                        </h5>
                        <small class="text-muted">Tahun Mulai</small>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card card-pink-glow text-center p-3">
                        <div class="icon-box-modern mx-auto mb-2" style="width: 50px; height: 50px;">
                            <i class="bi bi-trophy"></i>
                        </div>
                        <h5 class="text-primary fw-bold mb-0">
                            <?= !empty($pendidikan) ? max(array_column($pendidikan, 'tahun_lulus')) : '-'; ?>
                        </h5>
                        <small class="text-muted">Tahun Selesai</small>
                    </div>
                </div>
            </div>

            <div class="timeline timeline-pink mt-5">
                <?php foreach ($pendidikan as $key => $edu): ?>
                    <div class="timeline-item reveal" style="animation-delay: <?= ($key * 0.1) ?>s;">
                        <div class="timeline-dot">
                            <i class="bi bi-mortarboard-fill"></i>
                        </div>
                        <div class="card card-pink-glow h-100 hover-card">
                            <div class="card-body p-4">
                                <div class="d-flex justify-content-between align-items-start mb-3">
                                    <span class="badge badge-pink rounded-pill fw-bold">
                                        <i class="bi bi-calendar-range me-1"></i>
                                        <?= esc($edu['tahun_masuk']); ?> - <?= esc($edu['tahun_lulus']); ?>
                                    </span>
                                    <span class="badge bg-light text-dark">
                                        <?= (intval($edu['tahun_lulus']) - intval($edu['tahun_masuk'])); ?> tahun
                                    </span>
                                </div>
                                
                                <h4 class="card-title text-gradient-pink fw-bold mb-2">
                                    <?= esc($edu['nama_sekolah']); ?>
                                </h4>
                                
                                <div class="d-flex align-items-center mb-3">
                                    <div class="icon-box-modern me-3" style="width: 40px; height: 40px; font-size: 1rem;">
                                        <i class="bi bi-bookmark-fill"></i>
                                    </div>
                                    <div>
                                        <h6 class="text-primary mb-0 fw-semibold"><?= esc($edu['jenjang']); ?></h6>
                                        <small class="text-muted">Jenjang Pendidikan</small>
                                    </div>
                                </div>
                                
                                <div class="bg-gradient-pink-soft rounded-3 p-3">
                                    <p class="card-text text-secondary mb-0 small">
                                        <i class="bi bi-info-circle-fill text-primary me-2"></i>
                                        Menempuh pendidikan <?= strtolower($edu['jenjang']); ?> dengan fokus pada pengembangan akademik dan karakter selama <?= (intval($edu['tahun_lulus']) - intval($edu['tahun_masuk'])); ?> tahun.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            
            <!-- Pagination -->
            <?php if(isset($pager)): ?>
                <div class="d-flex justify-content-center mt-5 fade-in-up">
                    <div class="pagination-pink">
                        <?= $pager->links('pendidikan', 'default_full'); ?>
                    </div>
                </div>
            <?php endif; ?>

        <?php endif; ?>

    </div>
</div>

<?= $this->endSection(); ?>
