<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?= $title ?? 'Admin Panel'; ?></title>
    <link rel="icon" href="https://fav.farm/🛡️" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        :root {
            --sidebar-width: 260px;
            --sidebar-bg: #db2777;
            --sidebar-link-color: #fdf2f8;
            --sidebar-link-hover-bg: #ec4899;
            --sidebar-link-active-bg: rgba(255, 255, 255, 0.2);
            --content-bg: #fdf2f8;
        }
        body {
            background-color: var(--content-bg);
            font-family: 'Plus Jakarta Sans', sans-serif;
        }
        .wrapper {
            display: flex;
            width: 100%;
        }
        #sidebar {
            width: var(--sidebar-width);
            min-height: 100vh;
            background: var(--sidebar-bg);
            color: white;
            transition: all 0.3s;
            position: fixed;
            z-index: 1000;
            display: flex;
            flex-direction: column;
        }
        .sidebar-header {
            padding: 1.5rem 1.25rem;
            text-align: center;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }
        .admin-brand {
            font-size: 1.25rem;
            font-weight: 700;
            color: #fff;
            text-decoration: none;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.75rem;
        }
        .sidebar-nav {
            padding: 1rem 0;
            list-style: none;
            margin: 0;
            flex-grow: 1;
        }
        .sidebar-item {
            padding: 0 1rem;
        }
        .sidebar-link {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.85rem 1.25rem;
            color: var(--sidebar-link-color);
            text-decoration: none;
            border-radius: 0.5rem;
            font-weight: 500;
            transition: background-color 0.2s, color 0.2s;
        }
        .sidebar-link:hover {
            background-color: var(--sidebar-link-hover-bg);
            color: #fff;
        }
        .sidebar-link.active {
            background-color: var(--sidebar-link-active-bg);
            color: #fff;
            font-weight: 600;
        }
        .sidebar-link i {
            font-size: 1.2rem;
        }
        .sidebar-footer {
            padding: 1rem;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
        }
        #content {
            width: calc(100% - var(--sidebar-width));
            margin-left: var(--sidebar-width);
            padding: 2rem;
            transition: all 0.3s;
        }
        .mobile-header {
            display: none;
            padding: 0.5rem 1rem;
            background: #fff;
            border-bottom: 1px solid #eee;
        }
        
        @media (max-width: 768px) {
            #sidebar {
                margin-left: calc(-1 * var(--sidebar-width));
            }
            #sidebar.active {
                margin-left: 0;
            }
            #content {
                width: 100%;
                margin-left: 0;
            }
            .mobile-header {
                display: flex;
                justify-content: space-between;
                align-items: center;
            }
        }

        /* Pink Theme Overrides */
        .btn-primary {
            background-color: var(--sidebar-link-hover-bg) !important;
            border-color: var(--sidebar-link-hover-bg) !important;
        }
        .btn-primary:hover {
            background-color: var(--sidebar-bg) !important;
            border-color: var(--sidebar-bg) !important;
        }
        .text-primary {
            color: var(--sidebar-link-hover-bg) !important;
        }
        .bg-primary {
            background-color: var(--sidebar-link-hover-bg) !important;
        }
        
        /* Dashboard Components */
        .icon-box-modern {
            width: 60px;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, var(--content-bg) 0%, #fce7f3 100%);
            border-radius: 16px;
            color: var(--sidebar-link-hover-bg);
            box-shadow: inset 0 2px 4px rgba(255, 255, 255, 0.8), 0 4px 6px rgba(0, 0, 0, 0.05);
            font-size: 1.5rem;
            transition: all 0.3s ease;
        }
        .card-feature {
            border-top: 4px solid var(--sidebar-link-hover-bg);
            background: white;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
        }
        .card-feature:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body>
    <div class="wrapper">
        <!-- Sidebar -->
        <nav id="sidebar">
            <?= $this->include('layout/sidebar'); ?>
        </nav>

        <!-- Page Content -->
        <div id="content">
            <header class="mobile-header">
                <a class="admin-brand text-dark" href="#">
                  <i class="bi bi-shield-shaded"></i>
                  <span>Admin Panel</span>
                </a>
                <button type="button" id="sidebarCollapse" class="btn btn-light border">
                    <i class="bi bi-list"></i>
                </button>
            </header>

            <main class="container-fluid">
                <?php if(session()->getFlashdata('message')) : ?>
                    <div class="alert alert-success border-0 shadow-sm rounded-4 mb-4 d-flex align-items-center" role="alert">
                        <i class="bi bi-check-circle-fill me-2 fs-4"></i>
                        <div><?= session()->getFlashdata('message'); ?></div>
                    </div>
                <?php endif; ?>

                <?php if(session()->getFlashdata('error')) : ?>
                    <div class="alert alert-danger border-0 shadow-sm rounded-4 mb-4 d-flex align-items-center" role="alert">
                        <i class="bi bi-exclamation-triangle-fill me-2 fs-4"></i>
                        <div><?= session()->getFlashdata('error'); ?></div>
                    </div>
                <?php endif; ?>

                <?php if(session()->getFlashdata('errors')) : ?>
                    <div class="alert alert-danger border-0 shadow-sm rounded-4 mb-4" role="alert">
                        <div class="d-flex align-items-center mb-2">
                            <i class="bi bi-exclamation-triangle-fill me-2 fs-4"></i>
                            <div class="fw-bold">Validation Errors</div>
                        </div>
                        <ul class="mb-0 ps-3">
                            <?php foreach(session()->getFlashdata('errors') as $error) : ?>
                                <li><?= esc($error); ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <?= $this->renderSection('content'); ?>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const sidebarCollapse = document.getElementById('sidebarCollapse');
            const sidebar = document.getElementById('sidebar');

            if (sidebarCollapse) {
                sidebarCollapse.addEventListener('click', function () {
                    sidebar.classList.toggle('active');
                });
            }
        });
    </script>
</body>
</html>
