// Skrip kontrol halaman login admin
document.addEventListener('DOMContentLoaded', () => {
    const bgVideo = document.querySelector('.bg-video');
    if (bgVideo) {
        bgVideo.muted = true;
        bgVideo.autoplay = true;
        bgVideo.preload = 'auto';
        bgVideo.setAttribute('playsinline', 'true');
        const hdSrc = bgVideo.dataset.hqSrc;
        if (hdSrc) {
            const hdSource = document.createElement('source');
            hdSource.src = hdSrc;
            hdSource.type = 'video/mp4';
            hdSource.addEventListener('error', () => {
                hdSource.remove();
                bgVideo.load();
            });
            const firstChild = bgVideo.firstChild;
            if (firstChild) {
                bgVideo.insertBefore(hdSource, firstChild);
            } else {
                bgVideo.appendChild(hdSource);
            }
        }
        bgVideo.load();
        bgVideo.play().catch(() => {});
    }

    const form = document.querySelector('.auth-form');
    if (!form) {
        return;
    }

    const submitBtn = form.querySelector('.btn-submit');

    // Saat submit valid, tampilkan spinner dan disable tombol
    form.addEventListener('submit', () => {
        if (!form.checkValidity() || !submitBtn) {
            return;
        }

        submitBtn.classList.add('loading');
        submitBtn.disabled = true;
        const loadingLabel = submitBtn.dataset.loadingLabel || 'Memproses...';
        submitBtn.innerHTML = `<span class="spinner" aria-hidden="true"></span><span>${loadingLabel}</span>`;
    });

    // Reset tombol ketika halaman dimuat ulang dari cache (misal back button)
    window.addEventListener('pageshow', () => {
        if (!submitBtn) {
            return;
        }

        submitBtn.classList.remove('loading');
        submitBtn.disabled = false;
        submitBtn.innerHTML = submitBtn.dataset.defaultText || 'Masuk';
    });

    // Toggle visibilitas password
    document.querySelectorAll('[data-toggle-password]').forEach((btn) => {
        const targetSelector = btn.getAttribute('data-target');
        btn.addEventListener('click', () => {
            const target = document.querySelector(targetSelector);
            if (!target) {
                return;
            }

            const isHidden = target.getAttribute('type') === 'password';
            target.setAttribute('type', isHidden ? 'text' : 'password');
            btn.classList.toggle('is-visible', isHidden);
            btn.setAttribute('aria-label', `${isHidden ? 'Sembunyikan' : 'Tampilkan'} kata sandi`);
        });
    });
});
