<?= $this->extend('layout/page_layout') ?>

<?= $this->section('content') ?>
<?php
    $companyHighlights = [
        [
            'icon'  => '🚀',
            'title' => 'Luncurkan platform loyalty untuk klien retail nasional',
            'desc'  => 'Produk baru selesai dalam 12 minggu sprint terukur sehingga go-live tepat sebelum musim liburan.',
        ],
        [
            'icon'  => '🤝',
            'title' => 'Kemitraan strategis dengan tim CX untuk riset lintas kota',
            'desc'  => 'Kolaborasi dengan 6 stakeholder memperkaya temuan insight pelanggan dan peluang inovasi layanan.',
        ],
        [
            'icon'  => '📊',
            'title' => 'Metrik eksperimen kuat: conversion naik 37%',
            'desc'  => 'Optimasi funnel onboarding berhasil dengan pendekatan A/B test berkelanjutan dan observasi real-time.',
        ],
    ];

    $featuredStories = [
        [
            'title' => 'Perjalanan tim dalam membangun pengalaman omni-channel bagi komunitas pengguna setia',
            'tag'   => 'Cakrawala Produk',
            'image' => 'https://images.unsplash.com/photo-1521737604893-d14cc237f11d?auto=format&fit=crop&w=900&q=80',
            'excerpt' => 'Menggabungkan event offline, automation email, dan aplikasi mobile agar pengguna merasa dekat dengan brand.',
        ],
        [
            'title' => 'Mendorong budaya design ops yang gesit di seluruh divisi kreatif',
            'tag'   => 'Inside Studio',
            'image' => 'https://images.unsplash.com/photo-1553877522-43269d4ea984?auto=format&fit=crop&w=900&q=80',
            'excerpt' => 'Ritme baru membuat proses handoff lebih mulus dan menjaga kualitas eksekusi di setiap produk.',
        ],
        [
            'title' => 'Bagaimana tim data memetakan kebutuhan pelanggan dalam 30 hari pertama onboard',
            'tag'   => 'Data Insight',
            'image' => 'https://images.unsplash.com/photo-1520607162513-77705c0f0d4a?auto=format&fit=crop&w=900&q=80',
            'excerpt' => 'Dashboard segmentasi real-time memudahkan tim marketing merancang campaign personal yang relevan.',
        ],
    ];

    $initiatives = [
        [
            'title' => 'Roadmap Produk Q1 2026',
            'desc'  => 'Fokus pada peningkatan retensi pengguna, memperkuat modul analitik, dan menguji fitur AI co-pilot untuk marketer.',
        ],
        [
            'title' => 'Program inkubasi talent internal',
            'desc'  => 'Membuka jalur karier baru bagi anggota tim untuk berkolaborasi lintas divisi selama 6 minggu.',
        ],
        [
            'title' => 'Seri webinar “Build With Empathy”',
            'desc'  => 'Membahas praktik terbaik riset pengguna, inclusive design, dan eksperimen produk berkelanjutan.',
        ],
    ];
?>

<div class="container app-container py-5">
    <section class="home-section">
        <div class="home-section__header">
            <div>
                <h2 class="home-section__title">Sorotan Utama Minggu Ini</h2>
                <p class="home-section__subtitle">Kilas balik singkat tentang capaian terbaru yang menandai kecepatan inovasi tim.</p>
            </div>
            <a class="btn btn-outline-primary btn-filter" href="<?= base_url('news') ?>">Lihat semua berita</a>
        </div>
        <div class="home-featured-grid">
            <?php foreach ($companyHighlights as $highlight): ?>
                <article class="home-featured-card">
                    <div class="home-featured-card__icon"><?= esc($highlight['icon']) ?></div>
                    <h3><?= esc($highlight['title']) ?></h3>
                    <p><?= esc($highlight['desc']) ?></p>
                </article>
            <?php endforeach; ?>
        </div>
    </section>

    <section class="home-section">
        <div class="home-section__header">
            <div>
                <h2 class="home-section__title">Cerita Pilihan Redaksi</h2>
                <p class="home-section__subtitle">Artikel mendalam seputar transformasi digital dan budaya kolaborasi di MADANI YATSI CREATIVE.</p>
            </div>
        </div>
        <div class="home-latest-grid">
            <?php foreach ($featuredStories as $story): ?>
                <article class="home-latest-card">
                    <div class="home-latest-card__media">
                        <img src="<?= esc($story['image']) ?>" alt="<?= esc($story['title']) ?>" loading="lazy">
                    </div>
                    <div class="home-latest-card__body">
                        <span class="home-meta"><?= esc($story['tag']) ?></span>
                        <h3 class="h4 m-0"><?= esc($story['title']) ?></h3>
                        <p class="text-muted mb-0"><?= esc($story['excerpt']) ?></p>
                        <a class="btn btn-link px-0 fw-semibold" href="<?= base_url('news') ?>">Baca cerita lengkap →</a>
                    </div>
                </article>
            <?php endforeach; ?>
        </div>
    </section>

    <section class="home-section">
        <div class="home-section__header">
            <div>
                <h2 class="home-section__title">Agenda & Inisiatif Selanjutnya</h2>
                <p class="home-section__subtitle">Rencana yang sedang berjalan agar kamu bisa ikut terlibat dari awal.</p>
            </div>
        </div>
        <div class="row g-3 g-md-4">
            <?php foreach ($initiatives as $item): ?>
                <div class="col-12 col-md-4">
                    <article class="card-surface h-100">
                        <h5 class="mb-2"><?= esc($item['title']) ?></h5>
                        <p class="mb-0"><?= esc($item['desc']) ?></p>
                    </article>
                </div>
            <?php endforeach; ?>
        </div>
    </section>
</div>

<?= $this->endSection() ?>