<?= $this->extend('layout/page_layout') ?>

<?= $this->section('content') ?>
<?php
    $dataPegawai    = $pegawai ?? [];
    $isAdminPreview = $isAdminPreview ?? false;

    $makeInitials = static function (string $text): string {
        $text = trim($text);
        if ($text === '') {
            return 'PG';
        }

        $parts   = preg_split('/\s+/', $text);
        $letters = '';

        foreach ($parts as $part) {
            $letters .= function_exists('mb_substr') ? mb_substr($part, 0, 1, 'UTF-8') : substr($part, 0, 1);
            if (strlen($letters) >= 2) {
                break;
            }
        }

        $letters = strtoupper(substr($letters, 0, 2));

        return $letters !== '' ? $letters : 'PG';
    };

    $resolvePhoto = static function (?string $path): array {
        if (empty($path)) {
            return ['exists' => false, 'url' => ''];
        }

        $relative = ltrim($path, '/');
        $fullPath = FCPATH . $relative;

        if (! is_file($fullPath)) {
            $altPath = FCPATH . 'uploads/' . basename($relative);
            if (is_file($altPath)) {
                $relative = 'uploads/' . basename($relative);
                $fullPath = $altPath;
            }
        }

        if (! is_file($fullPath)) {
            return ['exists' => false, 'url' => ''];
        }

        $version = filemtime($fullPath);

        return [
            'exists' => true,
            'url'    => base_url($relative) . '?v=' . $version,
        ];
    };

    $divisiMap = [
        'Direktur Utama' => 'Direktur Utama',
        'IT'             => 'IT (Information Technology)',
        'Produksi'       => 'Produksi',
        'Marketing'      => 'Marketing',
        'HR'             => 'HR (Human Resource)',
    ];

    $genderMap = [
        'laki-laki' => 'Laki-laki',
        'perempuan' => 'Perempuan',
    ];

    $divisiLabel = $divisiLabel ?? ($divisiMap[$dataPegawai['divisi'] ?? ''] ?? ($dataPegawai['divisi'] ?? '-'));
    $genderLabel = $genderLabel ?? ($genderMap[strtolower($dataPegawai['jenis_kelamin'] ?? '')] ?? 'Belum diisi');

    $birth      = $dataPegawai['tanggal_lahir'] ?? '';
    $birthLabel = $birth !== '' ? date('d M Y', strtotime($birth)) : 'Belum diisi';

    $createdAt      = $dataPegawai['created_at'] ?? '';
    $createdLabel   = $createdAt !== '' ? date('d M Y', strtotime($createdAt)) : 'Tidak diketahui';
    $backUrl        = $isAdminPreview ? base_url('admin/perusahaan') : base_url('about#struktur');
    $photo          = $resolvePhoto($dataPegawai['foto_pegawai'] ?? '');
    $pageDescriptor = $isAdminPreview ? 'Pratinjau Admin' : 'Profil Pegawai';
?>
<style>
.employee-detail {
    background: var(--surface-foreground, #ffffff);
    border-radius: 24px;
    border: 1px solid rgba(148, 163, 184, 0.25);
    box-shadow: 0 24px 48px rgba(15, 23, 42, 0.12);
}
.employee-detail__photo {
    position: relative;
    border-radius: 18px;
    overflow: hidden;
    background: linear-gradient(135deg, rgba(59, 130, 246, 0.08), rgba(14, 165, 233, 0.1));
}
.employee-detail__photo img {
    width: 100%;
    height: 100%;
    max-height: 420px;
    object-fit: cover;
    display: block;
    border-radius: 18px;
    transition: transform 0.35s ease, box-shadow 0.35s ease;
}
.employee-detail__photo a:hover img {
    transform: scale(1.02);
    box-shadow: 0 20px 44px rgba(15, 23, 42, 0.15);
}
.employee-detail__placeholder {
    display: grid;
    place-items: center;
    min-height: 320px;
    color: var(--brand-primary, #2563eb);
    font-weight: 700;
    font-size: 42px;
    letter-spacing: 0.12em;
    background: linear-gradient(160deg, rgba(59, 130, 246, 0.14), rgba(99, 102, 241, 0.18));
}
.employee-detail__header {
    display: flex;
    flex-direction: column;
    gap: 6px;
}
.employee-detail__header .badge {
    padding: 10px 14px;
    border-radius: 999px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.02em;
}
.employee-detail__meta {
    display: grid;
    gap: 12px;
}
.employee-detail__meta-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 12px 14px;
    border-radius: 12px;
    background: rgba(248, 250, 252, 0.8);
    border: 1px solid rgba(226, 232, 240, 0.8);
}
.employee-detail__meta-label {
    color: var(--text-muted, #64748b);
    font-weight: 600;
    font-size: 0.95rem;
}
.employee-detail__meta-value {
    color: var(--brand-dark, #0f172a);
    font-weight: 700;
    font-size: 1rem;
}
.employee-detail__cta {
    display: flex;
    gap: 10px;
    flex-wrap: wrap;
}
@media (max-width: 991.98px) {
    .employee-detail__photo img {
        max-height: none;
    }
}
</style>

<div class="container py-4 py-md-5">
    <div class="d-flex align-items-start justify-content-between gap-3 flex-wrap mb-3">
        <div class="employee-detail__header">
            <span class="text-muted small"><?= esc($pageDescriptor) ?></span>
            <h1 class="h3 mb-0"><?= esc($dataPegawai['nama_pegawai'] ?? 'Detail Pegawai') ?></h1>
        </div>
        <div class="employee-detail__cta">
            <a class="btn btn-outline-secondary" href="<?= esc($backUrl) ?>">Kembali</a>
            <?php if ($isAdminPreview && ! empty($dataPegawai['id_pegawai'])): ?>
                <a class="btn btn-primary" href="<?= base_url('admin/perusahaan/'.$dataPegawai['id_pegawai'].'/edit') ?>">Edit Data</a>
            <?php endif; ?>
        </div>
    </div>

    <article class="employee-detail card border-0">
        <div class="card-body p-3 p-md-4">
            <div class="row g-4 align-items-center">
                <div class="col-12 col-lg-5">
                    <div class="employee-detail__photo">
                        <?php if ($photo['exists']): ?>
                            <a href="<?= esc($photo['url']) ?>" target="_blank" rel="noopener">
                                <img src="<?= esc($photo['url']) ?>" alt="Foto <?= esc($dataPegawai['nama_pegawai'] ?? 'Pegawai') ?>">
                            </a>
                        <?php else: ?>
                            <div class="employee-detail__placeholder"><?= esc($makeInitials($dataPegawai['nama_pegawai'] ?? '')) ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="text-muted small mt-2">Klik foto untuk melihat ukuran penuh.</div>
                </div>
                <div class="col-12 col-lg-7">
                    <div class="d-flex flex-wrap gap-2 mb-3">
                        <span class="badge bg-primary-subtle text-primary"><?= esc($divisiLabel) ?></span>
                        <span class="badge bg-secondary-subtle text-secondary"><?= esc($genderLabel) ?></span>
                    </div>
                    <p class="text-muted mb-4">
                        Bagian dari divisi <?= esc($divisiLabel) ?> dengan fokus kolaborasi lintas tim. Profil ini memudahkan Anda meninjau data pegawai sebelum dibagikan ke halaman publik.
                    </p>
                    <div class="employee-detail__meta">
                        <div class="employee-detail__meta-item">
                            <span class="employee-detail__meta-label">Nama</span>
                            <span class="employee-detail__meta-value"><?= esc($dataPegawai['nama_pegawai'] ?? '-') ?></span>
                        </div>
                        <div class="employee-detail__meta-item">
                            <span class="employee-detail__meta-label">Jenis Kelamin</span>
                            <span class="employee-detail__meta-value"><?= esc($genderLabel) ?></span>
                        </div>
                        <div class="employee-detail__meta-item">
                            <span class="employee-detail__meta-label">Tanggal Lahir</span>
                            <span class="employee-detail__meta-value"><?= esc($birthLabel) ?></span>
                        </div>
                        <div class="employee-detail__meta-item">
                            <span class="employee-detail__meta-label">Divisi</span>
                            <span class="employee-detail__meta-value"><?= esc($divisiLabel) ?></span>
                        </div>
                        <div class="employee-detail__meta-item">
                            <span class="employee-detail__meta-label">Ditambahkan</span>
                            <span class="employee-detail__meta-value"><?= esc($createdLabel) ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </article>
</div>

<?= $this->endSection() ?>
