<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Login - Admin</title>
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet" />
    <?php
        // Cache-buster untuk asset statis
        $assetVersion = '20251124p';
        /**
         * Hitung base path public secara dinamis dari script name
         * supaya asset selalu same-origin (hindari beda port 8080 vs 80)
         * dan tetap cocok di subfolder (misal /CI4DIMAS/public).
         */
        $scriptDir     = trim(str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME'] ?? '/')), '/');
        $assetBasePath = ($scriptDir !== '') ? '/' . $scriptDir . '/' : '/';

        $bgVideoPath = $assetBasePath . 'media/animate-login.mp4';
        $bgVideoSrc  = $bgVideoPath . '?v=' . $assetVersion;
    ?>
    <link rel="stylesheet" href="<?= $assetBasePath ?>css/login.css?v=<?= $assetVersion ?>" />
</head>
<body>
    <video
        class="bg-video"
        src="<?= $bgVideoSrc ?>"
        autoplay
        muted
        loop
        playsinline
        crossorigin="anonymous"
        data-hq-src="<?= $bgVideoSrc ?>">
        <source src="<?= $bgVideoSrc ?>" type="video/mp4">
    </video>

    <div class="bg-overlay" aria-hidden="true">
        <div class="orb orb-1"></div>
        <div class="orb orb-2"></div>
        <div class="orb orb-3"></div>
        <?php foreach (range(1, 12) as $particle): ?>
            <span
                class="particle"
                style="--x:<?= rand(5, 95) ?>%; --y:<?= rand(5, 90) ?>%; --delay:<?= rand(0, 120) / 10 ?>s;"></span>
        <?php endforeach; ?>
    </div>

    <div class="content">
        <div class="auth-card">
            <div class="brand-pill">Login Admin</div>
            <h1>Masuk</h1>
            <?php
                $errors        = session()->getFlashdata('errors') ?? [];
                $message       = session()->getFlashdata('message');
                $emailError    = $errors['email'] ?? null;
                $passwordError = $errors['password'] ?? null;
                $loginError    = $errors['login'] ?? null;
                $isAssoc       = is_array($errors) && array_keys($errors) !== range(0, count($errors) - 1);

                if (! $isAssoc && ! empty($errors) && ! $loginError && ! $emailError && ! $passwordError) {
                    // Fallback bila error dikirim tanpa key (numeric array)
                    $loginError = reset($errors);
                }
            ?>
            <?php if ($message): ?>
                <div class="alert alert-success" role="status">
                    <div class="alert-icon" aria-hidden="true">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M20 6L9 17l-5-5"></path>
                        </svg>
                    </div>
                    <div class="alert-body">
                        <p class="alert-title">Berhasil</p>
                        <p class="alert-text"><?= esc($message) ?></p>
                    </div>
                </div>
            <?php endif; ?>

            <form class="auth-form" action="<?= $assetBasePath ?>login" method="post" novalidate>
                <?= csrf_field() ?>

                <div class="form-section">
                    <div class="floating-input">
                        <span class="input-icon" aria-hidden="true">
                            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                <rect x="3" y="5" width="18" height="14" rx="2" ry="2"></rect>
                                <polyline points="3,7 12,13 21,7"></polyline>
                            </svg>
                        </span>
                        <input type="email" id="email" name="email" placeholder=" " required value="<?= old('email') ?>" autocomplete="email" />
                        <label for="email">Email </label>
                        <?php if ($emailError): ?>
                            <div class="field-error" role="alert">
                                <span class="field-error__icon" aria-hidden="true">
                                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M12 9v4"></path>
                                        <path d="M12 16.5h0.01"></path>
                                        <path d="M10.29 3.86 2.82 17.2A1.5 1.5 0 0 0 4.12 19.5h15.76a1.5 1.5 0 0 0 1.3-2.3L13.71 3.86a1.5 1.5 0 0 0-2.42 0Z"></path>
                                    </svg>
                                </span>
                                <span class="field-error__text"><?= esc($emailError) ?></span>
                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="floating-input">
                        <span class="input-icon" aria-hidden="true">
                            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                <rect x="3" y="11" width="18" height="10" rx="2"></rect>
                                <path d="M7 11V7a5 5 0 1 1 10 0v4"></path>
                            </svg>
                        </span>
                        <input type="password" id="password" name="password" placeholder=" " required autocomplete="current-password" />
                        <label for="password">Kata sandi</label>
                        <button type="button" class="password-toggle" data-toggle-password data-target="#password" aria-label="Tampilkan kata sandi">
                            <span class="sr-only">Ubah visibilitas kata sandi</span>
                            <svg class="icon-eye" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M1 12s4-7 11-7 11 7 11 7-4 7-11 7S1 12 1 12z"></path>
                                <circle cx="12" cy="12" r="3"></circle>
                            </svg>
                            <svg class="icon-eye-off" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M17.94 17.94A10.94 10.94 0 0 1 12 19c-7 0-11-7-11-7a20.29 20.29 0 0 1 5.06-5.94M9.9 4.24A10.94 10.94 0 0 1 12 4c7 0 11 7 11 7a20.3 20.3 0 0 1-2.87 3.88"></path>
                                <line x1="1" y1="1" x2="23" y2="23"></line>
                            </svg>
                        </button>
                        <?php if ($passwordError): ?>
                            <div class="field-error" role="alert">
                                <span class="field-error__icon" aria-hidden="true">
                                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M12 9v4"></path>
                                        <path d="M12 16.5h0.01"></path>
                                        <path d="M10.29 3.86 2.82 17.2A1.5 1.5 0 0 0 4.12 19.5h15.76a1.5 1.5 0 0 0 1.3-2.3L13.71 3.86a1.5 1.5 0 0 0-2.42 0Z"></path>
                                    </svg>
                                </span>
                                <span class="field-error__text"><?= esc($passwordError) ?></span>
                            </div>
                        <?php endif; ?>

                        <?php if ($loginError && ! $passwordError): ?>
                            <div class="field-error" role="alert">
                                <span class="field-error__icon" aria-hidden="true">
                                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M12 9v4"></path>
                                        <path d="M12 16.5h0.01"></path>
                                        <path d="M10.29 3.86 2.82 17.2A1.5 1.5 0 0 0 4.12 19.5h15.76a1.5 1.5 0 0 0 1.3-2.3L13.71 3.86a1.5 1.5 0 0 0-2.42 0Z"></path>
                                    </svg>
                                </span>
                                <span class="field-error__text"><?= esc($loginError) ?></span>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="form-meta">
                    <label class="remember">
                        <input type="checkbox" name="remember">
                        Ingat saya
                    </label>
                </div>

                <button type="submit" class="btn-submit" data-loading-label="Masuk..." data-default-text="Masuk">
                    Masuk
                </button>

                <div class="security-note">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                        <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path>
                        <path d="M12 8v4"></path>
                        <circle cx="12" cy="16" r="1"></circle>
                    </svg>
                    Data Anda terenkripsi dan hanya dapat diakses oleh tim terotorisasi.
                </div>
            </form>

        </div>
    </div>

    <script src="<?= $assetBasePath ?>js/login.js?v=<?= $assetVersion ?>"></script>
</body>
</html>
