<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>
<div class="d-flex flex-wrap justify-content-between align-items-center mb-4 gap-3">
    <div>
        <h1 class="h4 mb-1">Manajemen Berita</h1>
        <p class="text-muted mb-0">Kelola berita yang telah diterbitkan maupun draft.</p>
    </div>
    <a class="btn btn-primary" href="<?= base_url('admin/news/new') ?>">+ Tambah Berita</a>
</div>

<?php if ($message = session()->getFlashdata('message')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?= esc($message) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Tutup"></button>
    </div>
<?php endif; ?>

<div class="card shadow-sm">
    <div class="table-responsive">
        <table class="table align-middle mb-0">
            <thead class="table-light">
                <tr>
                    <th scope="col">ID</th>
                    <th scope="col">Gambar</th>
                    <th scope="col">Judul</th>
                    <th scope="col">Status</th>
                    <th scope="col" class="text-end">Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($newses)): ?>
                    <tr>
                        <td colspan="4" class="text-center text-muted py-4">
                            Belum ada berita. Tambah berita pertama Anda.
                        </td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($newses as $news): ?>
                        <?php
                            $status = $news['status'] ?? 'draft';
                            $isPublished = $status === 'published';
                        ?>
                        <tr>
                            <td class="fw-semibold align-middle"><?= esc($news['id']) ?></td>
                            <td class="align-middle">
                                <?php if (! empty($news['image_path'])): ?>
                                    <img
                                        src="<?= base_url($news['image_path']) ?>"
                                        alt="Thumbnail <?= esc($news['title']) ?>"
                                        class="rounded border"
                                        style="width: 72px; height: 72px; object-fit: cover;">
                                <?php else: ?>
                                    <span class="text-muted small">Tidak ada gambar</span>
                                <?php endif; ?>
                            </td>
                            <td class="align-middle">
                                <div class="fw-semibold text-dark"><?= esc($news['title']) ?></div>
                                <div class="text-muted small">
                                    <?php
                                        $createdAt = $news['created_at'] ?? null;
                                        if ($createdAt) {
                                            echo esc(date('d M Y', strtotime($createdAt)));
                                        } else {
                                            echo '-';
                                        }
                                    ?>
                                </div>
                            </td>
                            <td>
                                <span class="badge <?= $isPublished ? 'bg-success' : 'bg-secondary' ?>">
                                    <?= $isPublished ? 'Published' : esc(ucfirst($status)) ?>
                                </span>
                            </td>
                            <td class="text-end">
                                <div class="btn-group btn-group-sm me-1" role="group" aria-label="Aksi cepat">
                                    <a href="<?= base_url('admin/news/'.$news['id'].'/preview') ?>" class="btn btn-outline-secondary" target="_blank">Preview</a>
                                    <a href="<?= base_url('admin/news/'.$news['id'].'/edit') ?>" class="btn btn-outline-primary">Edit</a>
                                </div>
                                <form action="<?= base_url('admin/news/'.$news['id'].'/delete') ?>" method="post" class="d-inline" onsubmit="return confirm('Hapus berita ini secara permanen?');">
                                    <?= csrf_field() ?>
                                    <button type="submit" class="btn btn-sm btn-outline-danger">Hapus</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?= $this->endSection() ?>
