<?php
$uri = service('uri');
$segment1 = $uri->getSegment(1) ?: 'home';
$isHome = ($segment1 === 'home' || $segment1 === '');

$pages = [
    'home' => [
        'eyebrow'  => 'PORTAL PENGEMBANGAN SISTEM',
        'title'    => 'Imanoel',
        'subtitle' => 'Arsitek Solusi Perangkat Lunak & Desain Antarmuka',
        'desc'     => 'Integrasi antara logika pemrograman tingkat tinggi dan estetika desain modern untuk menghasilkan solusi berbasis web yang skalabel dan efisien. Fokus pada performa, aksesibilitas, dan pengalaman pengguna.',
        'cta_main' => ['label' => 'Akses Repositori', 'href' => base_url('activities#main-content')],
        'cta_alt'  => ['label' => 'Profil Teknis',   'href' => base_url('biodata')],
        'cta_soft' => ['label' => 'Hubungi Dev',      'href' => base_url('contact')],
        'initials' => 'IM',
    ],
    'activities' => [
        'eyebrow'  => 'LOG AKTIVITAS SISTEM',
        'title'    => 'Dokumentasi & Progres Teknis',
        'subtitle' => 'Catatan Reccurent Pengembangan & Pemeliharaan',
        'desc'     => 'Periodisasi kegiatan pengembangan yang mencakup implementasi fitur, optimasi kode, dan manajemen basis data dalam siklus hidup perangkat lulnak.',
        'cta_main' => ['label' => 'Lihat Log',        'href' => base_url('activities#main-content')],
        'cta_alt'  => ['label' => 'Data Entitas',     'href' => base_url('biodata')],
        'cta_soft' => ['label' => 'Riwayat Edukasi',  'href' => base_url('education')],
        'initials' => 'LOG',
    ],
    'biodata' => [
        'eyebrow'  => 'ENTITAS DATA PENGGUNA',
        'title'    => 'Informasi Profil Personel',
        'subtitle' => 'Struktur Data & Latar Belakang Profesional',
        'desc'     => 'Representasi data atributif mengenai identitas, kompetensi teknis, serta pengalaman manajerial yang mendukung integritas profesionalisme sistem.',
        'cta_main' => ['label' => 'Query Data',       'href' => base_url('biodata#main-content')],
        'cta_alt'  => ['label' => 'Analisis Aktivitas','href' => base_url('activities')],
        'cta_soft' => ['label' => 'Log Pendidikan',   'href' => base_url('education')],
        'initials' => 'BIO',
    ],
    'education' => [
        'eyebrow'  => 'REKAM AKADEMIS FORMAL',
        'title'    => 'Struktur Fondasi Keilmuan',
        'subtitle' => 'Linimasa Perolehan Kompetensi Akademik',
        'desc'     => 'Riwayat pendidikan terverifikasi yang menjadi parameter kapabilitas intelektual dalam mendukung implementasi teknologi informasi.',
        'cta_main' => ['label' => 'Lihat Linimasa',   'href' => base_url('education#main-content')],
        'cta_alt'  => ['label' => 'Data Aktivitas',   'href' => base_url('activities')],
        'cta_soft' => ['label' => 'Entitas Profil',   'href' => base_url('biodata')],
        'initials' => 'EDU',
    ],
    'about' => [
        'eyebrow'  => 'DOKUMENTASI SISTEM',
        'title'    => 'Mengenai Arsitektur Ini',
        'subtitle' => 'Framework & Teknologi yang Digunakan',
        'desc'     => 'Spesifikasi teknis mengenai pembuatan infrastruktur web ini menggunakan CodeIgniter 4 dan integrasi antarmuka modern.',
        'cta_main' => ['label' => 'Detail Teknis',    'href' => base_url('#main-content')],
        'cta_alt'  => ['label' => 'Aktivitas',        'href' => base_url('activities')],
        'cta_soft' => ['label' => 'Biodata',          'href' => base_url('biodata')],
        'initials' => 'SYS',
    ],
    'contact' => [
        'eyebrow'  => 'API KOMUNIKASI',
        'title'    => 'Inisiasi Koneksi Kolaborasi',
        'subtitle' => 'Gateway Interaksi Profesional',
        'desc'     => 'Kirimkan permintaan kolaborasi atau diskusi teknis melalui protokol komunikasi yang telah disediakan di bawah ini.',
        'cta_main' => ['label' => 'Kirim Request',    'href' => base_url('#main-content')],
        'cta_alt'  => ['label' => 'Log Aktivitas',    'href' => base_url('activities')],
        'cta_soft' => ['label' => 'Riwayat Akademis', 'href' => base_url('education')],
        'initials' => 'API',
    ],
    'faqs' => [
        'eyebrow'  => 'BASIS PENGETAHUAN',
        'title'    => 'Pertanyaan yang Sering Diajukan',
        'subtitle' => 'Knowledge Base (KB)',
        'desc'     => 'Kumpulan dokumentasi singkat untuk menjawab anomali atau pertanyaan umum seputar operasional sistem.',
        'cta_main' => ['label' => 'Akses KB',         'href' => base_url('#main-content')],
        'cta_alt'  => ['label' => 'Log Aktivitas',    'href' => base_url('activities')],
        'cta_soft' => ['label' => 'Data Profil',      'href' => base_url('biodata')],
        'initials' => 'KB',
    ],
];

$page = $pages[$segment1] ?? $pages['activities'];
?>
<div class="hero-wrap">
    <div class="container hero-grid-split">
        <div class="hero-copy-left">
            <div class="hero-eyebrow"><?= esc($page['eyebrow']) ?></div>
            <h1 class="hero-title"><?= esc($page['title']) ?></h1>
            <?php if (!empty($page['subtitle'])): ?>
                <p class="hero-subtitle"><?= esc($page['subtitle']) ?></p>
            <?php endif; ?>
            <p class="hero-desc"><?= esc($page['desc']) ?></p>
            
            <?php if(isset($page['cta_main'])): ?>
            <div class="hero-actions" style="margin-top: 2rem;">
                <a href="<?= $page['cta_main']['href'] ?>" class="btn-solid" style="border-radius: 50px; padding: 1rem 2rem; font-weight: 600;">Eksekusi Antarmuka</a>
            </div>
            <?php endif; ?>
        </div>
        
        <div class="hero-visual-right">
            <div class="hero-image-frame">
        <div class="hero-visual-right">
            <div class="hero-image-frame">
                <img src="<?= base_url('profile_image.php') ?>" alt="Profile Imanoel" class="hero-profile-img">
                <div class="image-glow"></div>
            </div>
        </div>

                <div class="image-glow"></div>
            </div>
        </div>
    </div>
</div>
