<?= $this->extend('layout/post_layout') ?>

<?= $this->section('content') ?>

<h2 class="section-heading" style="text-align: center; margin-bottom: 3rem;">Manajemen Data Entitas & Identitas</h2>

<div class="search-filter-section" style="background: rgba(255, 255, 255, 0.4); backdrop-filter: blur(10px); border-radius: 30px; padding: 2rem;">
    <form method="get" action="<?= base_url('biodata') ?>" class="w-100">
        <div class="row align-items-center">
            <div class="col-md-5 mb-2">
                <input type="text" name="search" class="form-control" placeholder="Inisiasi pencarian melalui atribut nama atau email..." value="<?= esc($search) ?>" style="border-radius: 20px; border: 1px solid var(--sky-blue);">
            </div>
            <div class="col-md-3 mb-2">
                <select name="filter_jenis_kelamin" class="form-control" style="border-radius: 20px;">
                    <option value="">Semua Gender</option>
                    <option value="Laki-laki" <?= $filter_jenis_kelamin == 'Laki-laki' ? 'selected' : '' ?>>Maskulin (Laki-laki)</option>
                    <option value="Perempuan" <?= $filter_jenis_kelamin == 'Perempuan' ? 'selected' : '' ?>>Feminin (Perempuan)</option>
                </select>
            </div>
            <div class="col-md-2 mb-2">
                <button type="submit" class="btn btn-primary w-100" style="border-radius: 20px; background: var(--primary);">Eksekusi Query</button>
            </div>
            <div class="col-md-2 mb-2">
                <a href="<?= base_url('biodata') ?>" class="btn btn-secondary w-100" style="border-radius: 20px;">Reset</a>
            </div>
        </div>
    </form>
</div>

<div class="sorting-links" style="justify-content: center; margin: 2rem 0;">
    <span style="color: var(--muted); margin-right: 1rem;">Parameter Pengurutan:</span>
    <a href="<?= base_url('biodata?sort_by=nama&sort_order=' . ($sort_by == 'nama' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenis_kelamin=' . urlencode($filter_jenis_kelamin)) ?>">
        Atribut Nama Persona <?= $sort_by == 'nama' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
    </a>
    <a href="<?= base_url('biodata?sort_by=email&sort_order=' . ($sort_by == 'email' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenis_kelamin=' . urlencode($filter_jenis_kelamin)) ?>">
        Atribut Kontak Digital <?= $sort_by == 'email' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
    </a>
</div>

<?php if (empty($biodata)): ?>
    <div class="alert alert-info" style="border-radius: 20px; text-align: center; background: var(--primary-fade); color: var(--primary-strong); border: none;">
        Data tidak ditemukan dalam index basis data kami.
    </div>
<?php else: ?>
    <div class="row">
    <?php foreach ($biodata as $bio): ?>
        <div class="col-lg-6 mb-4">
            <article class="cv-card" style="height: 100%; border: none; background: rgba(255,255,255,0.6); backdrop-filter: blur(15px); border-radius: 30px; transition: transform 0.3s ease;">
                <div style="display: flex; flex-direction: column; align-items: center; text-align: center; gap: 1.5rem; width: 100%;">
                    <?php if (stripos($bio['nama'], 'Imanoel') !== false): ?>
                        <div class="cv-photo" style="width: 150px; height: 150px; border-radius: 50%; box-shadow: 0 10px 30px rgba(0,0,0,0.1); border: 4px solid #fff; overflow: hidden;">
                            <img src="<?= base_url('profile_image.php') ?>" alt="Imanoel" style="width: 100%; height: 100%; object-fit: cover;">
                        </div>
                    <?php elseif (!empty($bio['foto_profil'])): ?>
                        <div class="cv-photo" style="width: 150px; height: 150px; border-radius: 50%; box-shadow: 0 10px 30px rgba(0,0,0,0.1); border: 4px solid #fff; overflow: hidden;">
                            <img src="<?= base_url($bio['foto_profil']) ?>" alt="Profil" style="width: 100%; height: 100%; object-fit: cover;">
                        </div>
                    <?php else: ?>
                        <div class="cv-photo" style="width: 150px; height: 150px; border-radius: 50%; background: var(--sky-blue); display: flex; align-items: center; justify-content: center; color: #fff; font-size: 2rem; font-weight: bold;">
                            <?= strtoupper(substr($bio['nama'], 0, 1)) ?>
                        </div>
                    <?php endif; ?>
                    
                    <div class="cv-info" style="width: 100%;">
                        <h3 style="color: var(--primary); font-weight: 700; margin-bottom: 0.5rem;"><?= esc($bio['nama']) ?></h3>
                        <p style="color: var(--muted); font-size: 0.9rem; margin-bottom: 1.5rem;"><?= esc($bio['email']) ?></p>
                        
                        <div style="text-align: left; padding: 0 1rem;">
                            <div class="biodata-item" style="margin-bottom: 1rem;">
                                <label style="display: block; font-size: 0.75rem; color: var(--muted); text-transform: uppercase; letter-spacing: 1px;">Domisili Alamat</label>
                                <span style="font-weight: 600; color: var(--text);"><?= esc($bio['alamat']) ?></span>
                            </div>
                            <div class="biodata-item" style="margin-bottom: 1rem;">
                                <label style="display: block; font-size: 0.75rem; color: var(--muted); text-transform: uppercase; letter-spacing: 1px;">Data Kelahiran</label>
                                <span style="font-weight: 600; color: var(--text);"><?= esc($bio['tempat_lahir']) ?>, <?= $bio['tanggal_lahir'] ? date('d F Y', strtotime($bio['tanggal_lahir'])) : '-' ?></span>
                            </div>
                            <div class="biodata-item" style="margin-bottom: 1rem;">
                                <label style="display: block; font-size: 0.75rem; color: var(--muted); text-transform: uppercase; letter-spacing: 1px;">Protokol Komunikasi</label>
                                <span style="font-weight: 600; color: var(--text);"><?= esc($bio['no_hp']) ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </article>
        </div>
    <?php endforeach; ?>
    </div>

    <div class="mt-4 d-flex justify-content-center">
        <?= $pager->links() ?>
    </div>
<?php endif; ?>

<?= $this->endSection() ?>



