<?= $this->extend('layout/main') ?>

<?= $this->section('content') ?>
<section class="py-12">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="text-center mb-12" data-aos="fade-up">
            <span class="inline-block px-4 py-2 bg-green-100 text-green-600 rounded-full text-sm font-medium mb-4">
                🎓 Riwayat Pendidikan
            </span>
            <h1 class="text-3xl md:text-4xl font-bold text-slate-800 mb-4">Pendidikan</h1>
            <p class="text-slate-500 max-w-2xl mx-auto">Perjalanan pendidikan formal yang telah saya tempuh.</p>
        </div>

        <!-- Search & Filter -->
        <div class="bg-white rounded-2xl shadow-lg shadow-slate-200/50 p-4 mb-8" data-aos="fade-up" data-aos-delay="100">
            <form action="" method="GET" class="flex flex-col md:flex-row gap-4">
                <div class="flex-1">
                    <div class="relative">
                        <i class="ph ph-magnifying-glass absolute left-4 top-1/2 -translate-y-1/2 text-slate-400"></i>
                        <input type="text" 
                               name="search" 
                               value="<?= $search ?>"
                               placeholder="Cari sekolah atau jurusan..." 
                               class="w-full pl-12 pr-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-primary-500 focus:ring-2 focus:ring-primary-500/20 transition-all">
                    </div>
                </div>
                <div class="flex gap-3">
                    <select name="jenjang" class="px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-primary-500 transition-all min-w-[140px]">
                        <option value="">Semua Jenjang</option>
                        <?php foreach ($jenjangList as $j): ?>
                        <option value="<?= $j ?>" <?= $jenjang === $j ? 'selected' : '' ?>><?= $j ?></option>
                        <?php endforeach; ?>
                    </select>
                    <select name="order" class="px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-primary-500 transition-all">
                        <option value="DESC" <?= $order === 'DESC' ? 'selected' : '' ?>>Terbaru</option>
                        <option value="ASC" <?= $order === 'ASC' ? 'selected' : '' ?>>Terlama</option>
                    </select>
                    <button type="submit" class="px-6 py-3 bg-primary-500 text-white rounded-xl hover:bg-primary-600 transition-colors">
                        <i class="ph ph-funnel"></i>
                    </button>
                </div>
            </form>
        </div>

        <?php if (!empty($pendidikan)): ?>
        <!-- Timeline -->
        <div class="relative">
            <div class="absolute left-8 md:left-1/2 md:-translate-x-1/2 top-0 bottom-0 w-0.5 bg-gradient-to-b from-primary-500 to-green-500"></div>

            <div class="space-y-8">
                <?php foreach ($pendidikan as $index => $item): ?>
                <div class="relative" data-aos="fade-up" data-aos-delay="<?= $index * 50 ?>">
                    <!-- Dot -->
                    <div class="absolute left-8 md:left-1/2 -translate-x-1/2 w-4 h-4 bg-primary-500 rounded-full border-4 border-white shadow z-10"></div>
                    
                    <!-- Card -->
                    <div class="ml-16 md:ml-0 md:w-1/2 <?= $index % 2 === 0 ? 'md:pr-12' : 'md:pl-12 md:ml-auto' ?>">
                        <div class="card-lift bg-white rounded-2xl p-6 shadow-lg shadow-slate-200/50">
                            <div class="flex items-start justify-between mb-4">
                                <span class="px-3 py-1 bg-<?= $item['jenjang'] === 'Kuliah' ? 'primary' : ($item['jenjang'] === 'SMA' ? 'green' : ($item['jenjang'] === 'SMP' ? 'yellow' : 'blue')) ?>-100 text-<?= $item['jenjang'] === 'Kuliah' ? 'primary' : ($item['jenjang'] === 'SMA' ? 'green' : ($item['jenjang'] === 'SMP' ? 'yellow' : 'blue')) ?>-600 rounded-full text-xs font-medium">
                                    <?= $item['jenjang'] ?>
                                </span>
                                <span class="text-sm text-slate-500">
                                    <?= $item['tahun_masuk'] ?> - <?= $item['tahun_lulus'] ?? 'Sekarang' ?>
                                </span>
                            </div>
                            <h3 class="text-lg font-semibold text-slate-800 mb-2"><?= $item['nama_sekolah'] ?></h3>
                            <?php if ($item['jurusan']): ?>
                            <p class="text-slate-500 text-sm flex items-center">
                                <i class="ph ph-book-open mr-2"></i>
                                <?= $item['jurusan'] ?>
                            </p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- Pagination -->
        <?php if ($pager && $pager->getPageCount() > 1): ?>
        <div class="mt-12 flex justify-center" data-aos="fade-up">
            <?= $pager->links('default', 'default_full') ?>
        </div>
        <?php endif; ?>

        <?php else: ?>
        <!-- Empty State -->
        <div class="bg-white rounded-3xl shadow-xl shadow-slate-200/50 p-12 text-center" data-aos="fade-up">
            <div class="w-24 h-24 bg-slate-100 rounded-full flex items-center justify-center mx-auto mb-6">
                <i class="ph ph-graduation-cap text-5xl text-slate-400"></i>
            </div>
            <h3 class="text-xl font-semibold text-slate-800 mb-2">Belum Ada Data Pendidikan</h3>
            <p class="text-slate-500">Data pendidikan belum tersedia saat ini.</p>
        </div>
        <?php endif; ?>
    </div>
</section>
<?= $this->endSection() ?>
