<!DOCTYPE html>
<html lang="id" x-data="{ sidebarOpen: window.innerWidth >= 1024 }">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'Dashboard' ?> - Admin Panel</title>
    
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#eef2ff',
                            100: '#e0e7ff',
                            200: '#c7d2fe',
                            300: '#a5b4fc',
                            400: '#818cf8',
                            500: '#6366f1',
                            600: '#4f46e5',
                            700: '#4338ca',
                            800: '#3730a3',
                            900: '#312e81',
                        }
                    }
                }
            }
        }
    </script>
    
    <!-- Alpine.js CDN -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <!-- Phosphor Icons -->
    <script src="https://unpkg.com/@phosphor-icons/web"></script>
    
    <style>
        /* Custom Scrollbar */
        ::-webkit-scrollbar {
            width: 6px;
        }
        ::-webkit-scrollbar-track {
            background: #f1f5f9;
        }
        ::-webkit-scrollbar-thumb {
            background: #cbd5e1;
            border-radius: 3px;
        }
        ::-webkit-scrollbar-thumb:hover {
            background: #94a3b8;
        }

        /* Sidebar Transition */
        .sidebar-transition {
            transition: transform 0.3s ease-in-out, opacity 0.3s ease-in-out;
        }

        /* Table Row Hover */
        .table-row-hover {
            transition: background-color 0.15s ease;
        }
        .table-row-hover:hover {
            background-color: #f8fafc;
        }

        /* Input Focus */
        .input-focus:focus {
            outline: none;
            border-color: #6366f1;
            box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
        }

        /* Button Ripple */
        .btn-ripple {
            position: relative;
            overflow: hidden;
        }
        .btn-ripple::after {
            content: '';
            position: absolute;
            width: 100%;
            height: 100%;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) scale(0);
            background: radial-gradient(circle, rgba(255,255,255,0.3) 0%, transparent 70%);
            border-radius: 50%;
            opacity: 0;
            transition: transform 0.4s, opacity 0.4s;
        }
        .btn-ripple:active::after {
            transform: translate(-50%, -50%) scale(4);
            opacity: 1;
            transition: transform 0s, opacity 0s;
        }

        /* Mobile Responsive Table */
        @media (max-width: 768px) {
            .responsive-table thead {
                display: none;
            }
            .responsive-table tbody tr {
                display: block;
                margin-bottom: 1rem;
                padding: 1rem;
                background: white;
                border-radius: 1rem;
                box-shadow: 0 1px 3px rgba(0,0,0,0.08);
            }
            .responsive-table tbody td {
                display: flex;
                justify-content: space-between;
                align-items: center;
                padding: 0.5rem 0;
                border: none;
                text-align: right;
            }
            .responsive-table tbody td::before {
                content: attr(data-label);
                font-weight: 600;
                color: #64748b;
                text-align: left;
                font-size: 0.75rem;
                text-transform: uppercase;
            }
            .responsive-table tbody td:last-child {
                justify-content: flex-end;
                padding-top: 0.75rem;
                border-top: 1px solid #e2e8f0;
                margin-top: 0.5rem;
            }
        }

        /* Mobile card adjustments */
        @media (max-width: 640px) {
            .mobile-stack {
                flex-direction: column;
                align-items: stretch !important;
            }
            .mobile-stack > * {
                width: 100% !important;
            }
            .mobile-full {
                width: 100%;
            }
        }

        [x-cloak] { display: none !important; }
    </style>
</head>
<body class="bg-slate-100 text-slate-800">
    <div class="min-h-screen flex">
        <!-- Sidebar Overlay (Mobile) -->
        <div x-show="sidebarOpen" 
             @click="sidebarOpen = false"
             class="fixed inset-0 bg-black/50 z-40 lg:hidden"
             x-transition:enter="transition ease-out duration-300"
             x-transition:enter-start="opacity-0"
             x-transition:enter-end="opacity-100"
             x-transition:leave="transition ease-in duration-200"
             x-transition:leave-start="opacity-100"
             x-transition:leave-end="opacity-0"
             x-cloak>
        </div>

        <!-- Sidebar -->
        <aside :class="sidebarOpen ? 'translate-x-0' : '-translate-x-full lg:translate-x-0'"
               class="fixed lg:static inset-y-0 left-0 w-64 bg-white border-r border-slate-200 z-50 sidebar-transition">
            <div class="h-full flex flex-col">
                <!-- Logo -->
                <div class="h-16 flex items-center justify-between px-4 border-b border-slate-200">
                    <a href="<?= base_url('admin') ?>" class="flex items-center space-x-2">
                        <div class="w-10 h-10 bg-gradient-to-br from-primary-500 to-primary-700 rounded-xl flex items-center justify-center text-white font-bold text-lg">
                            I
                        </div>
                        <span class="font-bold text-lg text-slate-800">Admin Panel</span>
                    </a>
                    <button @click="sidebarOpen = false" class="lg:hidden p-2 rounded-lg hover:bg-slate-100 transition-colors">
                        <i class="ph ph-x text-xl text-slate-500"></i>
                    </button>
                </div>

                <!-- Navigation -->
                <nav class="flex-1 overflow-y-auto p-4">
                    <div class="space-y-1">
                        <a href="<?= base_url('admin') ?>" 
                           class="flex items-center space-x-3 px-4 py-3 rounded-xl transition-all duration-200 <?= uri_string() === 'admin' ? 'bg-primary-50 text-primary-600' : 'text-slate-600 hover:bg-slate-50' ?>">
                            <i class="ph ph-squares-four text-xl"></i>
                            <span class="font-medium">Dashboard</span>
                        </a>
                        <a href="<?= base_url('admin/biodata') ?>" 
                           class="flex items-center space-x-3 px-4 py-3 rounded-xl transition-all duration-200 <?= str_contains(uri_string(), 'admin/biodata') || str_contains(uri_string(), 'admin/bahasa') || str_contains(uri_string(), 'admin/sertifikat') ? 'bg-primary-50 text-primary-600' : 'text-slate-600 hover:bg-slate-50' ?>">
                            <i class="ph ph-user text-xl"></i>
                            <span class="font-medium">Biodata</span>
                        </a>
                        <a href="<?= base_url('admin/pendidikan') ?>" 
                           class="flex items-center space-x-3 px-4 py-3 rounded-xl transition-all duration-200 <?= str_contains(uri_string(), 'admin/pendidikan') ? 'bg-primary-50 text-primary-600' : 'text-slate-600 hover:bg-slate-50' ?>">
                            <i class="ph ph-graduation-cap text-xl"></i>
                            <span class="font-medium">Pendidikan</span>
                        </a>
                        <a href="<?= base_url('admin/aktivitas') ?>" 
                           class="flex items-center space-x-3 px-4 py-3 rounded-xl transition-all duration-200 <?= str_contains(uri_string(), 'admin/aktivitas') ? 'bg-primary-50 text-primary-600' : 'text-slate-600 hover:bg-slate-50' ?>">
                            <i class="ph ph-calendar text-xl"></i>
                            <span class="font-medium">Aktivitas</span>
                        </a>
                    </div>

                    <div class="mt-8">
                        <p class="px-4 text-xs font-semibold text-slate-400 uppercase tracking-wider mb-2">Lainnya</p>
                        <div class="space-y-1">
                            <a href="<?= base_url() ?>" target="_blank" 
                               class="flex items-center space-x-3 px-4 py-3 rounded-xl text-slate-600 hover:bg-slate-50 transition-all duration-200">
                                <i class="ph ph-eye text-xl"></i>
                                <span class="font-medium">Lihat Website</span>
                                <i class="ph ph-arrow-square-out text-sm ml-auto"></i>
                            </a>
                        </div>
                    </div>
                </nav>

                <!-- User Section -->
                <div class="p-4 border-t border-slate-200">
                    <div x-data="{ dropdownOpen: false }" class="relative">
                        <button @click="dropdownOpen = !dropdownOpen" 
                                class="w-full flex items-center space-x-3 px-4 py-3 rounded-xl hover:bg-slate-50 transition-colors">
                            <div class="w-10 h-10 bg-gradient-to-br from-primary-400 to-primary-600 rounded-xl flex items-center justify-center text-white font-bold">
                                <?= strtoupper(substr(session()->get('username') ?? 'A', 0, 1)) ?>
                            </div>
                            <div class="flex-1 text-left">
                                <p class="font-medium text-slate-800 text-sm"><?= session()->get('nama_lengkap') ?? session()->get('username') ?? 'Admin' ?></p>
                                <p class="text-xs text-slate-500">Administrator</p>
                            </div>
                            <i class="ph ph-caret-down text-slate-400" :class="{ 'rotate-180': dropdownOpen }"></i>
                        </button>
                        
                        <!-- Dropdown -->
                        <div x-show="dropdownOpen" 
                             @click.away="dropdownOpen = false"
                             x-transition
                             class="absolute bottom-full left-0 w-full mb-2 bg-white rounded-xl shadow-lg border border-slate-200 overflow-hidden"
                             x-cloak>
                            <a href="<?= base_url('auth/logout') ?>" 
                               class="flex items-center space-x-3 px-4 py-3 text-red-600 hover:bg-red-50 transition-colors">
                                <i class="ph ph-sign-out text-xl"></i>
                                <span class="font-medium">Logout</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </aside>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col min-h-screen">
            <!-- Top Bar -->
            <header class="h-16 bg-white border-b border-slate-200 flex items-center justify-between px-4 lg:px-6">
                <div class="flex items-center space-x-4">
                    <button @click="sidebarOpen = !sidebarOpen" class="lg:hidden p-2 rounded-lg hover:bg-slate-100 transition-colors">
                        <i class="ph ph-list text-xl text-slate-600"></i>
                    </button>
                    <h1 class="text-lg font-semibold text-slate-800"><?= $title ?? 'Dashboard' ?></h1>
                </div>
                
                <div class="flex items-center space-x-4">
                    <!-- Realtime Clock -->
                    <div x-data="realtimeClock()" x-init="init()" class="hidden md:flex items-center space-x-3 bg-slate-50 px-4 py-2 rounded-xl">
                        <div class="flex items-center space-x-2 text-primary-600">
                            <i class="ph ph-clock text-lg"></i>
                            <span x-text="time" class="font-mono font-semibold text-lg"></span>
                        </div>
                        <div class="w-px h-6 bg-slate-300"></div>
                        <div class="flex items-center space-x-2 text-slate-600">
                            <i class="ph ph-calendar text-lg"></i>
                            <span x-text="date" class="text-sm font-medium"></span>
                        </div>
                    </div>
                    <!-- Mobile Clock -->
                    <div x-data="realtimeClock()" x-init="init()" class="md:hidden flex items-center text-primary-600">
                        <span x-text="time" class="font-mono font-semibold"></span>
                    </div>
                </div>
            </header>

            <!-- Realtime Clock Script -->
            <script>
                function realtimeClock() {
                    return {
                        time: '',
                        date: '',
                        init() {
                            this.updateClock();
                            setInterval(() => this.updateClock(), 1000);
                        },
                        updateClock() {
                            const now = new Date();
                            const hours = String(now.getHours()).padStart(2, '0');
                            const minutes = String(now.getMinutes()).padStart(2, '0');
                            const seconds = String(now.getSeconds()).padStart(2, '0');
                            this.time = `${hours}:${minutes}:${seconds}`;
                            
                            const days = ['Minggu', 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu'];
                            const months = ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Agu', 'Sep', 'Okt', 'Nov', 'Des'];
                            const day = days[now.getDay()];
                            const dateNum = now.getDate();
                            const month = months[now.getMonth()];
                            const year = now.getFullYear();
                            this.date = `${day}, ${dateNum} ${month} ${year}`;
                        }
                    }
                }
            </script>

            <!-- Page Content -->
            <main class="flex-1 p-4 lg:p-6">
                <?= $this->renderSection('content') ?>
            </main>
        </div>
    </div>

    <!-- Flash Messages -->
    <?php if (session()->getFlashdata('success')): ?>
    <div x-data="{ show: true }" 
         x-show="show" 
         x-transition
         x-init="setTimeout(() => show = false, 5000)"
         class="fixed bottom-6 right-6 z-50 bg-green-500 text-white px-6 py-4 rounded-2xl shadow-lg flex items-center space-x-3">
        <i class="ph ph-check-circle text-2xl"></i>
        <span><?= session()->getFlashdata('success') ?></span>
        <button @click="show = false" class="ml-2 hover:bg-green-600 rounded-full p-1 transition-colors">
            <i class="ph ph-x"></i>
        </button>
    </div>
    <?php endif; ?>

    <?php if (session()->getFlashdata('error')): ?>
    <div x-data="{ show: true }" 
         x-show="show" 
         x-transition
         x-init="setTimeout(() => show = false, 5000)"
         class="fixed bottom-6 right-6 z-50 bg-red-500 text-white px-6 py-4 rounded-2xl shadow-lg flex items-center space-x-3">
        <i class="ph ph-x-circle text-2xl"></i>
        <span><?= session()->getFlashdata('error') ?></span>
        <button @click="show = false" class="ml-2 hover:bg-red-600 rounded-full p-1 transition-colors">
            <i class="ph ph-x"></i>
        </button>
    </div>
    <?php endif; ?>

    <?= $this->renderSection('scripts') ?>
</body>
</html>
