<?= $this->extend('layout/main') ?>

<?= $this->section('content') ?>
<!-- Hero Section -->
<section class="relative min-h-[85vh] flex items-center justify-center overflow-hidden">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Left Content -->
            <div data-aos="fade-right">
                <span class="inline-block px-4 py-2 bg-primary-100 text-primary-600 rounded-full text-sm font-medium mb-6">
                    👋 Selamat Datang
                </span>
                <h1 class="text-4xl md:text-5xl lg:text-6xl font-bold text-slate-800 leading-tight mb-6">
                    Halo, Saya
                    <span class="text-transparent bg-clip-text bg-gradient-to-r from-primary-500 to-primary-700">
                        <?= $biodata['nama_lengkap'] ?? 'Muhammad Ilham' ?>
                    </span>
                </h1>
                <p class="text-lg text-slate-600 leading-relaxed mb-8 max-w-xl">
                    <?= $biodata['deskripsi_diri'] ?? 'Selamat datang di portfolio digital saya. Di sini Anda dapat melihat perjalanan pendidikan dan aktivitas saya.' ?>
                </p>
                
                <div class="flex flex-wrap gap-4">
                    <a href="<?= base_url('biodata') ?>" class="inline-flex items-center px-6 py-3 bg-gradient-to-r from-primary-500 to-primary-600 text-white rounded-xl font-medium hover:from-primary-600 hover:to-primary-700 transition-all duration-300 shadow-lg shadow-primary-500/25">
                        <i class="ph ph-user mr-2"></i>
                        Lihat Profil Lengkap
                    </a>
                    <a href="<?= base_url('aktivitas') ?>" class="inline-flex items-center px-6 py-3 bg-white text-slate-700 rounded-xl font-medium hover:bg-slate-50 transition-all duration-300 border border-slate-200 shadow-sm">
                        <i class="ph ph-images mr-2"></i>
                        Lihat Galeri
                    </a>
                </div>
            </div>

            <!-- Right Content - Enhanced Profile Avatar -->
            <div data-aos="fade-left" class="flex justify-center lg:justify-end">
                <div class="relative group">
                    <!-- Animated Background Rings -->
                    <div class="absolute inset-0 w-72 h-72 md:w-96 md:h-96 -translate-x-4 -translate-y-4">
                        <div class="absolute inset-0 rounded-full bg-gradient-to-br from-primary-400/30 to-purple-400/30 animate-pulse"></div>
                        <div class="absolute inset-4 rounded-full bg-gradient-to-br from-primary-300/20 to-purple-300/20" style="animation: spin 20s linear infinite;"></div>
                        <div class="absolute inset-8 rounded-full border-2 border-dashed border-primary-300/40" style="animation: spin 15s linear infinite reverse;"></div>
                    </div>
                    
                    <!-- Main Profile Container -->
                    <div class="relative w-64 h-64 md:w-80 md:h-80 rounded-full overflow-hidden shadow-2xl shadow-primary-500/30 group-hover:shadow-primary-500/50 transition-all duration-500 group-hover:scale-105">
                        <div class="absolute inset-0 bg-gradient-to-br from-primary-500 via-purple-500 to-pink-500 p-1.5 rounded-full">
                            <div class="w-full h-full bg-white rounded-full overflow-hidden">
                                <?php if ($biodata && $biodata['foto_profil']): ?>
                                    <img src="<?= base_url('uploads/biodata/' . $biodata['foto_profil']) ?>" 
                                         alt="<?= $biodata['nama_lengkap'] ?>" 
                                         class="w-full h-full object-cover transition-transform duration-700 group-hover:scale-110">
                                <?php else: ?>
                                    <div class="w-full h-full bg-gradient-to-br from-primary-100 to-primary-200 flex items-center justify-center">
                                        <i class="ph ph-user text-8xl text-primary-400"></i>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Floating Badges -->
                    <div class="absolute -top-2 -right-2 md:-top-4 md:-right-4">
                        <div class="w-14 h-14 md:w-16 md:h-16 bg-gradient-to-br from-yellow-400 to-orange-500 rounded-2xl flex items-center justify-center shadow-xl shadow-yellow-500/30 animate-bounce">
                            <i class="ph ph-star-fill text-2xl md:text-3xl text-white"></i>
                        </div>
                    </div>
                    <div class="absolute -bottom-2 -left-2 md:-bottom-4 md:-left-4">
                        <div class="w-12 h-12 md:w-14 md:h-14 bg-gradient-to-br from-green-400 to-emerald-500 rounded-2xl flex items-center justify-center shadow-xl shadow-green-500/30" style="animation: float 3s ease-in-out infinite;">
                            <i class="ph ph-code text-xl md:text-2xl text-white"></i>
                        </div>
                    </div>
                    
                    <!-- Status Badge -->
                    <div class="absolute -bottom-6 left-1/2 transform -translate-x-1/2">
                        <div class="px-4 py-2 bg-white rounded-full shadow-xl flex items-center space-x-2 border border-slate-100">
                            <span class="w-3 h-3 bg-green-500 rounded-full animate-pulse"></span>
                            <span class="text-sm font-medium text-slate-700">Available for Work</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
@keyframes spin { from { transform: rotate(0deg); } to { transform: rotate(360deg); } }
</style>

<!-- Quick Stats Section -->
<section class="py-12 bg-white/50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-10" data-aos="fade-up">
            <h2 class="text-2xl md:text-3xl font-bold text-slate-800 mb-2">Ringkasan Portfolio</h2>
            <p class="text-slate-500">Eksplorasi lebih lanjut untuk melihat detail lengkap</p>
        </div>

        <div class="grid grid-cols-2 lg:grid-cols-4 gap-4 md:gap-6">
            <!-- Pendidikan Card -->
            <a href="<?= base_url('pendidikan') ?>" class="group" data-aos="zoom-in" data-aos-delay="0">
                <div class="bg-white p-6 rounded-2xl shadow-lg shadow-slate-200/50 hover:shadow-xl hover:-translate-y-2 transition-all duration-300 border border-slate-100 h-full">
                    <div class="w-14 h-14 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center mb-4 group-hover:scale-110 transition-transform">
                        <i class="ph ph-graduation-cap text-2xl text-white"></i>
                    </div>
                    <p class="text-3xl font-bold text-slate-800 mb-1"><?= count($pendidikan ?? []) ?></p>
                    <p class="text-slate-500 text-sm mb-3">Riwayat Pendidikan</p>
                    <span class="inline-flex items-center text-xs text-blue-600 font-medium group-hover:underline">
                        Lihat Detail <i class="ph ph-arrow-right ml-1"></i>
                    </span>
                </div>
            </a>

            <!-- Aktivitas Card -->
            <a href="<?= base_url('aktivitas') ?>" class="group" data-aos="zoom-in" data-aos-delay="100">
                <div class="bg-white p-6 rounded-2xl shadow-lg shadow-slate-200/50 hover:shadow-xl hover:-translate-y-2 transition-all duration-300 border border-slate-100 h-full">
                    <div class="w-14 h-14 bg-gradient-to-br from-green-500 to-emerald-600 rounded-xl flex items-center justify-center mb-4 group-hover:scale-110 transition-transform">
                        <i class="ph ph-images text-2xl text-white"></i>
                    </div>
                    <p class="text-3xl font-bold text-slate-800 mb-1"><?= count($aktivitas ?? []) ?>+</p>
                    <p class="text-slate-500 text-sm mb-3">Foto & Video</p>
                    <span class="inline-flex items-center text-xs text-green-600 font-medium group-hover:underline">
                        Lihat Galeri <i class="ph ph-arrow-right ml-1"></i>
                    </span>
                </div>
            </a>

            <!-- Skills Card -->
            <a href="<?= base_url('biodata') ?>" class="group" data-aos="zoom-in" data-aos-delay="200">
                <div class="bg-white p-6 rounded-2xl shadow-lg shadow-slate-200/50 hover:shadow-xl hover:-translate-y-2 transition-all duration-300 border border-slate-100 h-full">
                    <div class="w-14 h-14 bg-gradient-to-br from-purple-500 to-violet-600 rounded-xl flex items-center justify-center mb-4 group-hover:scale-110 transition-transform">
                        <i class="ph ph-code text-2xl text-white"></i>
                    </div>
                    <p class="text-3xl font-bold text-slate-800 mb-1"><?= count($bahasa ?? []) ?></p>
                    <p class="text-slate-500 text-sm mb-3">Bahasa Pemrograman</p>
                    <span class="inline-flex items-center text-xs text-purple-600 font-medium group-hover:underline">
                        Lihat Skills <i class="ph ph-arrow-right ml-1"></i>
                    </span>
                </div>
            </a>

            <!-- Sertifikat Card -->
            <a href="<?= base_url('biodata') ?>" class="group" data-aos="zoom-in" data-aos-delay="300">
                <div class="bg-white p-6 rounded-2xl shadow-lg shadow-slate-200/50 hover:shadow-xl hover:-translate-y-2 transition-all duration-300 border border-slate-100 h-full">
                    <div class="w-14 h-14 bg-gradient-to-br from-amber-500 to-orange-600 rounded-xl flex items-center justify-center mb-4 group-hover:scale-110 transition-transform">
                        <i class="ph ph-certificate text-2xl text-white"></i>
                    </div>
                    <p class="text-3xl font-bold text-slate-800 mb-1"><?= count($sertifikat ?? []) ?></p>
                    <p class="text-slate-500 text-sm mb-3">Sertifikat</p>
                    <span class="inline-flex items-center text-xs text-amber-600 font-medium group-hover:underline">
                        Lihat Semua <i class="ph ph-arrow-right ml-1"></i>
                    </span>
                </div>
            </a>
        </div>
    </div>
</section>

<!-- Explore Section -->
<section class="py-16">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <!-- Biodata Card -->
            <div class="bg-gradient-to-br from-primary-500 to-primary-700 rounded-3xl p-8 text-white shadow-2xl shadow-primary-500/30" data-aos="fade-up">
                <div class="w-16 h-16 bg-white/20 backdrop-blur rounded-2xl flex items-center justify-center mb-6">
                    <i class="ph ph-user-circle text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-3">Profil & Biodata</h3>
                <p class="text-primary-100 text-sm mb-6 leading-relaxed">
                    Informasi lengkap tentang saya, kontak, skill pemrograman, dan sertifikat yang dimiliki.
                </p>
                <a href="<?= base_url('biodata') ?>" class="inline-flex items-center px-5 py-2.5 bg-white text-primary-600 rounded-xl font-medium text-sm hover:bg-primary-50 transition-colors">
                    Lihat Profil
                    <i class="ph ph-arrow-right ml-2"></i>
                </a>
            </div>

            <!-- Pendidikan Card -->
            <div class="bg-gradient-to-br from-blue-500 to-cyan-600 rounded-3xl p-8 text-white shadow-2xl shadow-blue-500/30" data-aos="fade-up" data-aos-delay="100">
                <div class="w-16 h-16 bg-white/20 backdrop-blur rounded-2xl flex items-center justify-center mb-6">
                    <i class="ph ph-graduation-cap text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-3">Riwayat Pendidikan</h3>
                <p class="text-blue-100 text-sm mb-6 leading-relaxed">
                    Timeline perjalanan pendidikan dari SD hingga perguruan tinggi dengan detail lengkap.
                </p>
                <a href="<?= base_url('pendidikan') ?>" class="inline-flex items-center px-5 py-2.5 bg-white text-blue-600 rounded-xl font-medium text-sm hover:bg-blue-50 transition-colors">
                    Lihat Pendidikan
                    <i class="ph ph-arrow-right ml-2"></i>
                </a>
            </div>

            <!-- Aktivitas Card -->
            <div class="bg-gradient-to-br from-green-500 to-emerald-600 rounded-3xl p-8 text-white shadow-2xl shadow-green-500/30" data-aos="fade-up" data-aos-delay="200">
                <div class="w-16 h-16 bg-white/20 backdrop-blur rounded-2xl flex items-center justify-center mb-6">
                    <i class="ph ph-images text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-3">Galeri Aktivitas</h3>
                <p class="text-green-100 text-sm mb-6 leading-relaxed">
                    Dokumentasi foto dan video dari berbagai kegiatan, project, dan momen penting.
                </p>
                <a href="<?= base_url('aktivitas') ?>" class="inline-flex items-center px-5 py-2.5 bg-white text-green-600 rounded-xl font-medium text-sm hover:bg-green-50 transition-colors">
                    Jelajahi Galeri
                    <i class="ph ph-arrow-right ml-2"></i>
                </a>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-12">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="bg-gradient-to-r from-slate-800 to-slate-900 rounded-3xl p-8 md:p-12 text-center shadow-2xl" data-aos="zoom-in">
            <div class="w-20 h-20 bg-primary-500/20 rounded-full flex items-center justify-center mx-auto mb-6">
                <i class="ph ph-envelope-simple text-4xl text-primary-400"></i>
            </div>
            <h2 class="text-2xl md:text-3xl font-bold text-white mb-4">
                Tertarik Berkolaborasi?
            </h2>
            <p class="text-slate-400 mb-8 max-w-lg mx-auto">
                Jangan ragu untuk menghubungi saya. Saya terbuka untuk kesempatan baru dan kolaborasi menarik.
            </p>
            <?php if ($biodata && $biodata['email']): ?>
            <a href="mailto:<?= $biodata['email'] ?>" class="inline-flex items-center px-8 py-4 bg-gradient-to-r from-primary-500 to-primary-600 text-white rounded-xl font-medium hover:from-primary-600 hover:to-primary-700 transition-all shadow-lg shadow-primary-500/30">
                <i class="ph ph-envelope-simple mr-2"></i>
                Hubungi Saya
            </a>
            <?php endif; ?>
        </div>
    </div>
</section>
<?= $this->endSection() ?>
