<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Admin Panel</title>
    
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#eef2ff',
                            100: '#e0e7ff',
                            200: '#c7d2fe',
                            300: '#a5b4fc',
                            400: '#818cf8',
                            500: '#6366f1',
                            600: '#4f46e5',
                            700: '#4338ca',
                            800: '#3730a3',
                            900: '#312e81',
                        }
                    }
                }
            }
        }
    </script>
    
    <!-- Alpine.js CDN -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <!-- Phosphor Icons -->
    <script src="https://unpkg.com/@phosphor-icons/web"></script>
    
    <style>
        @keyframes float {
            0%, 100% { transform: translateY(0) rotate(0deg); }
            50% { transform: translateY(-15px) rotate(2deg); }
        }
        @keyframes float-slow {
            0%, 100% { transform: translateY(0) scale(1); }
            50% { transform: translateY(-20px) scale(1.05); }
        }
        @keyframes pulse-ring {
            0% { transform: scale(0.95); opacity: 0.7; }
            50% { transform: scale(1.05); opacity: 0.5; }
            100% { transform: scale(0.95); opacity: 0.7; }
        }
        @keyframes gradient-bg {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }
        @keyframes shimmer {
            0% { transform: translateX(-100%); }
            100% { transform: translateX(100%); }
        }
        .animate-float { animation: float 6s ease-in-out infinite; }
        .animate-float-slow { animation: float-slow 8s ease-in-out infinite; }
        .animate-pulse-ring { animation: pulse-ring 3s ease-in-out infinite; }
        .gradient-bg {
            background: linear-gradient(-45deg, #4f46e5, #7c3aed, #6366f1, #8b5cf6, #4338ca);
            background-size: 400% 400%;
            animation: gradient-bg 15s ease infinite;
        }
        .glass-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
        }
        .input-focus:focus {
            outline: none;
            border-color: #6366f1;
            box-shadow: 0 0 0 4px rgba(99, 102, 241, 0.15);
        }
        .btn-shimmer {
            position: relative;
            overflow: hidden;
        }
        .btn-shimmer::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            animation: shimmer 3s infinite;
        }
        [x-cloak] { display: none !important; }
    </style>
</head>
<body class="min-h-screen gradient-bg flex items-center justify-center p-4 relative overflow-hidden" x-data="{ showPassword: false, loading: false }">
    
    <!-- Decorative Background Elements -->
    <div class="absolute inset-0 overflow-hidden pointer-events-none">
        <!-- Large Floating Circles -->
        <div class="absolute -top-20 -left-20 w-80 h-80 bg-white/5 rounded-full animate-float-slow"></div>
        <div class="absolute top-1/4 -right-16 w-64 h-64 bg-white/5 rounded-full animate-float" style="animation-delay: -2s;"></div>
        <div class="absolute -bottom-32 left-1/4 w-96 h-96 bg-white/5 rounded-full animate-float-slow" style="animation-delay: -4s;"></div>
        
        <!-- Smaller Floating Shapes -->
        <div class="absolute top-20 right-1/4 w-20 h-20 bg-white/10 rounded-2xl animate-float" style="animation-delay: -1s;"></div>
        <div class="absolute bottom-32 right-20 w-16 h-16 bg-white/10 rounded-xl animate-float" style="animation-delay: -3s;"></div>
        <div class="absolute top-1/3 left-20 w-12 h-12 bg-white/10 rounded-lg animate-float-slow" style="animation-delay: -2s;"></div>
        <div class="absolute bottom-1/4 left-1/3 w-14 h-14 bg-cyan-400/10 rounded-full animate-float" style="animation-delay: -5s;"></div>
        
        <!-- Grid Pattern Overlay -->
        <div class="absolute inset-0 opacity-5" style="background-image: url('data:image/svg+xml,%3Csvg width=\"60\" height=\"60\" viewBox=\"0 0 60 60\" xmlns=\"http://www.w3.org/2000/svg\"%3E%3Cg fill=\"none\" fill-rule=\"evenodd\"%3E%3Cg fill=\"%23ffffff\" fill-opacity=\"0.4\"%3E%3Cpath d=\"M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z\"/%3E%3C/g%3E%3C/g%3E%3C/svg%3E');"></div>
    </div>

    <!-- Login Card -->
    <div class="w-full max-w-md relative z-10">
        <!-- Decorative Ring Behind Card -->
        <div class="absolute inset-0 -m-4 bg-white/10 rounded-[2rem] animate-pulse-ring blur-sm"></div>
        
        <div class="glass-card rounded-3xl shadow-2xl shadow-black/20 p-8 relative border border-white/20">
            <!-- Top Decorative Line -->
            <div class="absolute top-0 left-1/2 -translate-x-1/2 w-24 h-1 bg-gradient-to-r from-transparent via-white/50 to-transparent rounded-full"></div>
            
            <!-- Logo & Header -->
            <div class="text-center mb-8">
                <div class="relative inline-block mb-6">
                    <!-- Outer Ring -->
                    <div class="absolute inset-0 -m-2 bg-gradient-to-br from-primary-400 to-purple-500 rounded-2xl opacity-30 blur-lg"></div>
                    <!-- Logo Box -->
                    <div class="relative w-20 h-20 bg-gradient-to-br from-primary-500 via-primary-600 to-indigo-700 rounded-2xl flex items-center justify-center shadow-xl shadow-primary-500/40">
                        <span class="text-4xl font-bold text-white">I</span>
                        <!-- Shine Effect -->
                        <div class="absolute top-2 left-2 w-6 h-6 bg-white/30 rounded-full blur-md"></div>
                    </div>
                </div>
                
                <h1 class="text-3xl font-bold text-slate-800 mb-2">Selamat Datang!</h1>
                <p class="text-slate-500">Masuk ke Admin Panel Portfolio</p>
            </div>

            <!-- Error Message -->
            <?php if (session()->getFlashdata('error')): ?>
            <div class="mb-6 p-4 bg-gradient-to-r from-red-50 to-red-100 border border-red-200 rounded-2xl flex items-center text-red-600">
                <div class="w-12 h-12 bg-red-100 rounded-xl flex items-center justify-center mr-4 flex-shrink-0">
                    <i class="ph ph-warning-circle text-2xl"></i>
                </div>
                <div>
                    <p class="font-semibold text-sm">Login Gagal</p>
                    <p class="text-xs opacity-80"><?= session()->getFlashdata('error') ?></p>
                </div>
            </div>
            <?php endif; ?>

            <!-- Success Message -->
            <?php if (session()->getFlashdata('success')): ?>
            <div class="mb-6 p-4 bg-gradient-to-r from-green-50 to-emerald-100 border border-green-200 rounded-2xl flex items-center text-green-600">
                <div class="w-12 h-12 bg-green-100 rounded-xl flex items-center justify-center mr-4 flex-shrink-0">
                    <i class="ph ph-check-circle text-2xl"></i>
                </div>
                <div>
                    <p class="font-semibold text-sm">Berhasil</p>
                    <p class="text-xs opacity-80"><?= session()->getFlashdata('success') ?></p>
                </div>
            </div>
            <?php endif; ?>

            <!-- Login Form -->
            <form action="<?= base_url('auth/login') ?>" method="POST" class="space-y-5" @submit="loading = true">
                <?= csrf_field() ?>
                
                <!-- Username Field -->
                <div>
                    <label for="username" class="block text-sm font-semibold text-slate-700 mb-2 flex items-center">
                        <i class="ph ph-user-circle text-primary-500 mr-2 text-lg"></i>
                        Username
                    </label>
                    <div class="relative group">
                        <div class="absolute left-0 top-0 bottom-0 w-12 bg-gradient-to-r from-primary-500 to-primary-600 rounded-l-xl flex items-center justify-center">
                            <i class="ph ph-user text-white text-xl"></i>
                        </div>
                        <input type="text" 
                               id="username" 
                               name="username" 
                               value="<?= old('username') ?>"
                               class="w-full pl-16 pr-4 py-4 bg-slate-50 border-2 border-slate-200 rounded-xl text-slate-800 placeholder-slate-400 transition-all duration-300 input-focus hover:border-primary-300"
                               placeholder="Masukkan username"
                               required>
                    </div>
                </div>

                <!-- Password Field -->
                <div>
                    <label for="password" class="block text-sm font-semibold text-slate-700 mb-2 flex items-center">
                        <i class="ph ph-key text-primary-500 mr-2 text-lg"></i>
                        Password
                    </label>
                    <div class="relative group">
                        <div class="absolute left-0 top-0 bottom-0 w-12 bg-gradient-to-r from-primary-500 to-primary-600 rounded-l-xl flex items-center justify-center">
                            <i class="ph ph-lock text-white text-xl"></i>
                        </div>
                        <input :type="showPassword ? 'text' : 'password'" 
                               id="password" 
                               name="password" 
                               class="w-full pl-16 pr-14 py-4 bg-slate-50 border-2 border-slate-200 rounded-xl text-slate-800 placeholder-slate-400 transition-all duration-300 input-focus hover:border-primary-300"
                               placeholder="Masukkan password"
                               required>
                        <button type="button" 
                                @click="showPassword = !showPassword"
                                class="absolute right-3 top-1/2 -translate-y-1/2 w-10 h-10 text-slate-400 hover:text-primary-600 hover:bg-primary-50 rounded-xl transition-all flex items-center justify-center">
                            <i class="ph text-xl" :class="showPassword ? 'ph-eye-slash' : 'ph-eye'"></i>
                        </button>
                    </div>
                </div>

                <!-- Submit Button -->
                <button type="submit" 
                        :disabled="loading"
                        class="w-full py-4 bg-gradient-to-r from-primary-500 via-primary-600 to-indigo-600 text-white rounded-xl font-bold text-lg hover:from-primary-600 hover:via-primary-700 hover:to-indigo-700 transition-all duration-300 shadow-xl shadow-primary-500/30 flex items-center justify-center space-x-3 disabled:opacity-70 disabled:cursor-not-allowed transform hover:scale-[1.02] active:scale-[0.98] btn-shimmer mt-6">
                    <template x-if="!loading">
                        <span class="flex items-center space-x-3">
                            <i class="ph ph-sign-in text-2xl"></i>
                            <span>Masuk ke Dashboard</span>
                        </span>
                    </template>
                    <template x-if="loading">
                        <span class="flex items-center space-x-3">
                            <svg class="animate-spin h-6 w-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                            </svg>
                            <span>Memproses...</span>
                        </span>
                    </template>
                </button>
            </form>

            <!-- Features -->
            <div class="mt-8 pt-6 border-t border-slate-200">
                <div class="grid grid-cols-3 gap-3 text-center">
                    <div class="p-3 rounded-xl bg-slate-50 hover:bg-primary-50 transition-colors group">
                        <i class="ph ph-shield-check text-2xl text-slate-400 group-hover:text-primary-500 transition-colors"></i>
                        <p class="text-xs text-slate-500 mt-1">Aman</p>
                    </div>
                    <div class="p-3 rounded-xl bg-slate-50 hover:bg-primary-50 transition-colors group">
                        <i class="ph ph-rocket-launch text-2xl text-slate-400 group-hover:text-primary-500 transition-colors"></i>
                        <p class="text-xs text-slate-500 mt-1">Cepat</p>
                    </div>
                    <div class="p-3 rounded-xl bg-slate-50 hover:bg-primary-50 transition-colors group">
                        <i class="ph ph-devices text-2xl text-slate-400 group-hover:text-primary-500 transition-colors"></i>
                        <p class="text-xs text-slate-500 mt-1">Responsif</p>
                    </div>
                </div>
            </div>

            <!-- Back Link -->
            <div class="mt-6">
                <a href="<?= base_url() ?>" class="w-full py-3 border-2 border-slate-200 text-slate-600 rounded-xl font-medium hover:bg-slate-50 hover:border-primary-300 hover:text-primary-600 transition-all duration-300 flex items-center justify-center space-x-2">
                    <i class="ph ph-arrow-left text-xl"></i>
                    <span>Kembali ke Beranda</span>
                </a>
            </div>
        </div>

        <!-- Footer -->
        <p class="text-center text-white/60 text-sm mt-8">
            &copy; <?= date('Y') ?> <span class="font-semibold text-white/80">Ilham</span>. All rights reserved.
        </p>
    </div>
</body>
</html>
