<?= $this->extend('layout/main') ?>

<?= $this->section('content') ?>
<section class="py-12">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="text-center mb-12" data-aos="fade-up">
            <span class="inline-block px-4 py-2 bg-primary-100 text-primary-600 rounded-full text-sm font-medium mb-4">
                📅 Daftar Aktivitas
            </span>
            <h1 class="text-3xl md:text-4xl font-bold text-slate-800 mb-4">Aktivitas</h1>
            <p class="text-slate-500 max-w-2xl mx-auto">Kegiatan dan aktivitas yang saya lakukan dalam bentuk foto dan video.</p>
        </div>

        <!-- Search & Filter -->
        <div class="bg-white rounded-2xl shadow-lg shadow-slate-200/50 p-4 mb-8" data-aos="fade-up" data-aos-delay="100">
            <form action="" method="GET" class="flex flex-col md:flex-row gap-4">
                <div class="flex-1">
                    <div class="relative">
                        <i class="ph ph-magnifying-glass absolute left-4 top-1/2 -translate-y-1/2 text-slate-400"></i>
                        <input type="text" 
                               name="search" 
                               value="<?= $search ?>"
                               placeholder="Cari aktivitas..." 
                               class="w-full pl-12 pr-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-primary-500 focus:ring-2 focus:ring-primary-500/20 transition-all">
                    </div>
                </div>
                <div class="flex gap-3">
                    <select name="year" class="px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-primary-500 transition-all min-w-[140px]">
                        <option value="">Semua Tahun</option>
                        <?php foreach ($availableYears as $y): ?>
                        <option value="<?= $y['year'] ?>" <?= $year == $y['year'] ? 'selected' : '' ?>><?= $y['year'] ?></option>
                        <?php endforeach; ?>
                    </select>
                    <select name="order" class="px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-primary-500 transition-all">
                        <option value="DESC" <?= $order === 'DESC' ? 'selected' : '' ?>>Terbaru</option>
                        <option value="ASC" <?= $order === 'ASC' ? 'selected' : '' ?>>Terlama</option>
                    </select>
                    <button type="submit" class="px-6 py-3 bg-primary-500 text-white rounded-xl hover:bg-primary-600 transition-colors">
                        <i class="ph ph-funnel"></i>
                    </button>
                </div>
            </form>
        </div>

        <?php if (!empty($aktivitas)): ?>
        <!-- Card Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <?php foreach ($aktivitas as $index => $item): ?>
            <div class="card-lift bg-white rounded-2xl overflow-hidden shadow-lg shadow-slate-200/50 group" 
                 data-aos="fade-up" 
                 data-aos-delay="<?= ($index % 6) * 50 ?>">
                
                <!-- Media Container -->
                <div class="relative h-48 overflow-hidden">
                    <?php if (($item['tipe'] ?? 'foto') === 'video' && $item['video']): ?>
                        <!-- Video with autoplay on hover -->
                        <div class="video-container w-full h-full">
                            <?php if ($item['foto']): ?>
                            <img src="<?= base_url('uploads/aktivitas/' . $item['foto']) ?>" 
                                 alt="<?= $item['nama_aktivitas'] ?>" 
                                 class="video-thumbnail absolute inset-0 w-full h-full object-cover transition-opacity duration-300">
                            <?php endif; ?>
                            <video src="<?= base_url('uploads/aktivitas/' . $item['video']) ?>" 
                                   class="video-player w-full h-full object-cover <?= $item['foto'] ? 'opacity-0' : '' ?> transition-opacity duration-300"
                                   muted loop playsinline></video>
                            <div class="play-icon absolute inset-0 flex items-center justify-center pointer-events-none transition-opacity duration-300">
                                <div class="w-12 h-12 bg-white/90 backdrop-blur rounded-full flex items-center justify-center shadow-lg group-hover:scale-110 transition-transform">
                                    <i class="ph ph-play-fill text-xl text-slate-800 ml-0.5"></i>
                                </div>
                            </div>
                        </div>
                        <!-- Video badge -->
                        <div class="absolute top-3 left-3 z-10">
                            <span class="px-2 py-1 text-xs font-medium rounded-lg bg-red-500 text-white">
                                <i class="ph ph-video mr-1"></i>Video
                            </span>
                        </div>
                    <?php elseif ($item['foto']): ?>
                        <!-- Photo -->
                        <img src="<?= base_url('uploads/aktivitas/' . $item['foto']) ?>" 
                             alt="<?= $item['nama_aktivitas'] ?>" 
                             class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
                        <!-- Photo badge -->
                        <div class="absolute top-3 left-3 z-10">
                            <span class="px-2 py-1 text-xs font-medium rounded-lg bg-blue-500 text-white">
                                <i class="ph ph-image mr-1"></i>Foto
                            </span>
                        </div>
                    <?php else: ?>
                        <div class="h-full bg-gradient-to-br from-primary-100 to-primary-200 flex items-center justify-center">
                            <i class="ph ph-calendar-blank text-6xl text-primary-400"></i>
                        </div>
                    <?php endif; ?>
                </div>
                
                <div class="p-6">
                    <div class="flex items-center text-sm text-slate-500 mb-3">
                        <i class="ph ph-calendar mr-2"></i>
                        <?= date('d M Y', strtotime($item['tanggal'])) ?>
                        <span class="mx-2">•</span>
                        <i class="ph ph-clock mr-1"></i>
                        <?= date('H:i', strtotime($item['jam'])) ?>
                    </div>
                    <h3 class="text-lg font-semibold text-slate-800 mb-2 line-clamp-2">
                        <?= $item['nama_aktivitas'] ?>
                    </h3>
                    <p class="text-slate-500 text-sm line-clamp-2 mb-4">
                        <?= $item['deskripsi'] ?? 'Tidak ada deskripsi' ?>
                    </p>
                    <a href="<?= base_url('aktivitas/' . $item['id']) ?>" 
                       class="inline-flex items-center text-primary-600 font-medium text-sm hover:text-primary-700 transition-colors">
                        Selengkapnya
                        <i class="ph ph-arrow-right ml-1"></i>
                    </a>
                </div>
            </div>
            <?php endforeach; ?>
        </div>

        <!-- Pagination -->
        <?php if ($pager && $pager->getPageCount() > 1): ?>
        <div class="mt-12 flex justify-center" data-aos="fade-up">
            <?= $pager->links('default', 'default_full') ?>
        </div>
        <?php endif; ?>

        <?php else: ?>
        <!-- Empty State -->
        <div class="bg-white rounded-3xl shadow-xl shadow-slate-200/50 p-12 text-center" data-aos="fade-up">
            <div class="w-24 h-24 bg-slate-100 rounded-full flex items-center justify-center mx-auto mb-6">
                <i class="ph ph-calendar-x text-5xl text-slate-400"></i>
            </div>
            <h3 class="text-xl font-semibold text-slate-800 mb-2">Belum Ada Data Aktivitas</h3>
            <p class="text-slate-500">Data aktivitas belum tersedia saat ini.</p>
        </div>
        <?php endif; ?>
    </div>
</section>

<style>
    .video-container:hover .video-thumbnail {
        opacity: 0 !important;
    }
    .video-container:hover .video-player {
        opacity: 1 !important;
    }
    .video-container:hover .play-icon {
        opacity: 0;
    }
</style>

<script>
// Video autoplay on hover
document.querySelectorAll('.video-container').forEach(container => {
    const video = container.querySelector('.video-player');
    const thumbnail = container.querySelector('.video-thumbnail');
    const playIcon = container.querySelector('.play-icon');
    
    container.addEventListener('mouseenter', () => {
        if (video) {
            video.play().catch(() => {});
            if (thumbnail) thumbnail.style.opacity = '0';
            if (playIcon) playIcon.style.opacity = '0';
        }
    });
    
    container.addEventListener('mouseleave', () => {
        if (video) {
            video.pause();
            video.currentTime = 0;
            if (thumbnail) thumbnail.style.opacity = '1';
            if (playIcon) playIcon.style.opacity = '1';
        }
    });
});
</script>
<?= $this->endSection() ?>

