<?= $this->extend('layout/main') ?>

<?= $this->section('content') ?>
<section class="py-12">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Back Button -->
        <a href="<?= base_url('aktivitas') ?>" class="inline-flex items-center text-slate-600 hover:text-primary-600 transition-colors mb-8" data-aos="fade-right">
            <i class="ph ph-arrow-left mr-2"></i>
            Kembali ke Daftar Aktivitas
        </a>

        <!-- Article Card -->
        <article class="bg-white rounded-3xl shadow-xl shadow-slate-200/50 overflow-hidden" data-aos="fade-up">
            <?php if ($aktivitas['foto']): ?>
            <div class="h-64 md:h-80 overflow-hidden">
                <img src="<?= base_url('uploads/aktivitas/' . $aktivitas['foto']) ?>" 
                     alt="<?= $aktivitas['nama_aktivitas'] ?>" 
                     class="w-full h-full object-cover">
            </div>
            <?php else: ?>
            <div class="h-64 md:h-80 bg-gradient-to-br from-primary-100 to-primary-200 flex items-center justify-center">
                <i class="ph ph-calendar-blank text-8xl text-primary-400"></i>
            </div>
            <?php endif; ?>

            <div class="p-8 md:p-12">
                <!-- Meta -->
                <div class="flex flex-wrap items-center gap-4 text-sm text-slate-500 mb-6">
                    <span class="inline-flex items-center px-4 py-2 bg-primary-100 text-primary-600 rounded-full font-medium">
                        <i class="ph ph-calendar mr-2"></i>
                        <?= date('d F Y', strtotime($aktivitas['tanggal'])) ?>
                    </span>
                    <span class="inline-flex items-center px-4 py-2 bg-slate-100 text-slate-600 rounded-full">
                        <i class="ph ph-clock mr-2"></i>
                        <?= date('H:i', strtotime($aktivitas['jam'])) ?> WIB
                    </span>
                </div>

                <!-- Title -->
                <h1 class="text-2xl md:text-3xl font-bold text-slate-800 mb-6">
                    <?= $aktivitas['nama_aktivitas'] ?>
                </h1>

                <!-- Content -->
                <div class="prose prose-slate max-w-none">
                    <p class="text-slate-600 leading-relaxed">
                        <?= nl2br($aktivitas['deskripsi'] ?? 'Tidak ada deskripsi untuk aktivitas ini.') ?>
                    </p>
                </div>

                <!-- Share -->
                <div class="mt-8 pt-8 border-t border-slate-200">
                    <p class="text-sm text-slate-500 mb-3">Bagikan:</p>
                    <div class="flex space-x-3">
                        <a href="https://www.facebook.com/sharer/sharer.php?u=<?= current_url() ?>" 
                           target="_blank"
                           class="w-10 h-10 bg-blue-600 text-white rounded-xl flex items-center justify-center hover:bg-blue-700 transition-colors">
                            <i class="ph ph-facebook-logo"></i>
                        </a>
                        <a href="https://twitter.com/intent/tweet?url=<?= current_url() ?>&text=<?= urlencode($aktivitas['nama_aktivitas']) ?>" 
                           target="_blank"
                           class="w-10 h-10 bg-sky-500 text-white rounded-xl flex items-center justify-center hover:bg-sky-600 transition-colors">
                            <i class="ph ph-twitter-logo"></i>
                        </a>
                        <a href="https://wa.me/?text=<?= urlencode($aktivitas['nama_aktivitas'] . ' - ' . current_url()) ?>" 
                           target="_blank"
                           class="w-10 h-10 bg-green-500 text-white rounded-xl flex items-center justify-center hover:bg-green-600 transition-colors">
                            <i class="ph ph-whatsapp-logo"></i>
                        </a>
                    </div>
                </div>
            </div>
        </article>
    </div>
</section>
<?= $this->endSection() ?>
