<?= $this->extend('layout/admin') ?>

<?= $this->section('content') ?>
<div class="space-y-6">
    <!-- Header with Tabs -->
    <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
        <div class="p-6 border-b border-slate-200">
            <h2 class="text-lg font-semibold text-slate-800">Kelola Biodata</h2>
            <p class="text-sm text-slate-500">Kelola profil, bahasa pemrograman, dan sertifikat</p>
        </div>
        
        <!-- Navigation Tabs -->
        <div class="flex border-b border-slate-200 bg-slate-50">
            <a href="<?= base_url('admin/biodata') ?>" 
               class="px-6 py-4 font-medium text-sm border-b-2 transition-colors border-transparent text-slate-500 hover:text-slate-700">
                <i class="ph ph-user mr-2"></i>Profil
            </a>
            <a href="<?= base_url('admin/bahasa') ?>" 
               class="px-6 py-4 font-medium text-sm border-b-2 transition-colors border-transparent text-slate-500 hover:text-slate-700">
                <i class="ph ph-code mr-2"></i>Bahasa Pemrograman
            </a>
            <a href="<?= base_url('admin/sertifikat') ?>" 
               class="px-6 py-4 font-medium text-sm border-b-2 transition-colors border-primary-500 text-primary-600 bg-white">
                <i class="ph ph-certificate mr-2"></i>Sertifikat
            </a>
        </div>
    </div>

    <!-- Content -->
    <div class="flex items-center justify-between">
        <div>
            <h3 class="font-semibold text-slate-800">Daftar Sertifikat</h3>
            <p class="text-sm text-slate-500">Sertifikat dan pencapaian</p>
        </div>
        <a href="<?= base_url('admin/sertifikat/create') ?>" class="inline-flex items-center px-4 py-2 bg-primary-500 text-white rounded-xl hover:bg-primary-600 transition-colors">
            <i class="ph ph-plus mr-2"></i>
            Tambah Sertifikat
        </a>
    </div>

    <!-- Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <?php if (!empty($sertifikat)): ?>
        <?php foreach ($sertifikat as $item): ?>
        <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden hover:shadow-md transition-shadow">
            <?php if ($item['file_sertifikat']): ?>
            <div class="h-40 overflow-hidden">
                <img src="<?= base_url('uploads/sertifikat/' . $item['file_sertifikat']) ?>" alt="<?= $item['nama_sertifikat'] ?>" class="w-full h-full object-cover">
            </div>
            <?php else: ?>
            <div class="h-40 bg-gradient-to-br from-primary-100 to-primary-200 flex items-center justify-center">
                <i class="ph ph-certificate text-6xl text-primary-400"></i>
            </div>
            <?php endif; ?>
            <div class="p-5">
                <h3 class="font-semibold text-slate-800 mb-1 line-clamp-1"><?= $item['nama_sertifikat'] ?></h3>
                <p class="text-sm text-slate-500 mb-2"><?= $item['penerbit'] ?></p>
                <?php if ($item['tanggal']): ?>
                <p class="text-xs text-slate-400"><?= date('d M Y', strtotime($item['tanggal'])) ?></p>
                <?php endif; ?>
                <div class="flex items-center gap-2 mt-4 pt-4 border-t border-slate-100">
                    <?php if ($item['credential_url']): ?>
                    <a href="<?= $item['credential_url'] ?>" target="_blank" class="flex-1 text-center px-3 py-2 bg-slate-50 text-slate-600 rounded-lg text-sm hover:bg-slate-100 transition-colors">
                        <i class="ph ph-link mr-1"></i> Lihat
                    </a>
                    <?php endif; ?>
                    <a href="<?= base_url('admin/sertifikat/edit/' . $item['id']) ?>" class="p-2 text-slate-500 hover:text-primary-600 hover:bg-primary-50 rounded-lg transition-colors">
                        <i class="ph ph-pencil-simple"></i>
                    </a>
                    <button onclick="confirmDelete(<?= $item['id'] ?>, '<?= addslashes($item['nama_sertifikat']) ?>')" class="p-2 text-slate-500 hover:text-red-600 hover:bg-red-50 rounded-lg transition-colors">
                        <i class="ph ph-trash"></i>
                    </button>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
        <?php else: ?>
        <div class="col-span-full bg-white rounded-2xl shadow-sm border border-slate-200 p-12 text-center">
            <div class="w-16 h-16 bg-slate-100 rounded-full flex items-center justify-center mx-auto mb-4">
                <i class="ph ph-certificate text-3xl text-slate-400"></i>
            </div>
            <h3 class="text-lg font-semibold text-slate-800 mb-2">Belum Ada Data</h3>
            <p class="text-slate-500 mb-4">Data sertifikat belum tersedia.</p>
            <a href="<?= base_url('admin/sertifikat/create') ?>" class="inline-flex items-center px-4 py-2 bg-primary-500 text-white rounded-xl hover:bg-primary-600 transition-colors">
                <i class="ph ph-plus mr-2"></i>
                Tambah Sertifikat
            </a>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Delete Modal -->
<div id="deleteModal" class="fixed inset-0 z-50 hidden">
    <div class="absolute inset-0 bg-black/50"></div>
    <div class="absolute inset-0 flex items-center justify-center p-4">
        <div class="bg-white rounded-2xl shadow-xl max-w-md w-full p-6">
            <div class="text-center">
                <div class="w-16 h-16 bg-red-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="ph ph-warning text-3xl text-red-600"></i>
                </div>
                <h3 class="text-lg font-semibold text-slate-800 mb-2">Hapus Data?</h3>
                <p class="text-slate-500 mb-6">Apakah Anda yakin ingin menghapus <strong id="deleteName"></strong>?</p>
                <form id="deleteForm" method="POST" class="flex gap-3 justify-center">
                    <button type="button" onclick="closeDeleteModal()" class="px-6 py-2.5 bg-slate-100 text-slate-600 rounded-xl hover:bg-slate-200 transition-colors">Batal</button>
                    <button type="submit" class="px-6 py-2.5 bg-red-500 text-white rounded-xl hover:bg-red-600 transition-colors">Hapus</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function confirmDelete(id, name) {
    document.getElementById('deleteName').textContent = name;
    document.getElementById('deleteForm').action = '<?= base_url('admin/sertifikat/delete/') ?>' + id;
    document.getElementById('deleteModal').classList.remove('hidden');
}
function closeDeleteModal() {
    document.getElementById('deleteModal').classList.add('hidden');
}
</script>
<?= $this->endSection() ?>
