<?= $this->extend('layout/admin') ?>

<?= $this->section('content') ?>
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Form Section -->
    <div class="lg:col-span-2">
        <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
            <div class="p-6 border-b border-slate-200 bg-gradient-to-r from-amber-500 to-orange-500">
                <h2 class="font-semibold text-white flex items-center">
                    <i class="ph ph-pencil-simple text-xl mr-2"></i>
                    Edit Sertifikat
                </h2>
                <p class="text-amber-100 text-sm mt-1">Perbarui informasi sertifikat</p>
            </div>
            
            <form action="<?= base_url('admin/sertifikat/update/' . $sertifikat['id']) ?>" method="POST" enctype="multipart/form-data" class="p-6">
                <?= csrf_field() ?>
                
                <?php if (session()->getFlashdata('errors')): ?>
                <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-xl">
                    <ul class="list-disc list-inside text-sm text-red-600">
                        <?php foreach (session()->getFlashdata('errors') as $error): ?>
                        <li><?= $error ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>

                <div class="space-y-5">
                    <div>
                        <label for="nama_sertifikat" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-certificate text-amber-500 mr-1"></i>
                            Nama Sertifikat <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="nama_sertifikat" id="nama_sertifikat" value="<?= old('nama_sertifikat', $sertifikat['nama_sertifikat']) ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-amber-500 focus:ring-2 focus:ring-amber-500/20 transition-all" required>
                    </div>

                    <div>
                        <label for="penerbit" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-buildings text-amber-500 mr-1"></i>
                            Penerbit <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="penerbit" id="penerbit" value="<?= old('penerbit', $sertifikat['penerbit']) ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-amber-500 focus:ring-2 focus:ring-amber-500/20 transition-all" required>
                    </div>

                    <div>
                        <label for="tanggal" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-calendar text-amber-500 mr-1"></i>
                            Tanggal Terbit
                        </label>
                        <input type="date" name="tanggal" id="tanggal" value="<?= old('tanggal', $sertifikat['tanggal']) ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-amber-500 focus:ring-2 focus:ring-amber-500/20 transition-all">
                    </div>

                    <div>
                        <label for="credential_url" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-link text-amber-500 mr-1"></i>
                            Credential URL
                        </label>
                        <input type="url" name="credential_url" id="credential_url" value="<?= old('credential_url', $sertifikat['credential_url']) ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-amber-500 focus:ring-2 focus:ring-amber-500/20 transition-all">
                    </div>

                    <div>
                        <label for="deskripsi" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-article text-amber-500 mr-1"></i>
                            Deskripsi
                        </label>
                        <textarea name="deskripsi" id="deskripsi" rows="3" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-amber-500 focus:ring-2 focus:ring-amber-500/20 transition-all resize-none"><?= old('deskripsi', $sertifikat['deskripsi']) ?></textarea>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-image text-amber-500 mr-1"></i>
                            Gambar Sertifikat
                        </label>
                        <div class="flex items-center gap-4">
                            <div class="w-24 h-24 rounded-xl overflow-hidden bg-slate-100 border-2 border-dashed border-slate-200" id="preview-container">
                                <?php if ($sertifikat['file_sertifikat']): ?>
                                <img src="<?= base_url('uploads/sertifikat/' . $sertifikat['file_sertifikat']) ?>" class="w-full h-full object-cover">
                                <?php else: ?>
                                <div class="w-full h-full flex items-center justify-center">
                                    <i class="ph ph-image text-3xl text-slate-400"></i>
                                </div>
                                <?php endif; ?>
                            </div>
                            <div class="flex-1">
                                <input type="file" name="file_sertifikat" id="file_sertifikat" accept="image/*" class="hidden" onchange="previewFile(this)">
                                <label for="file_sertifikat" class="inline-flex items-center px-4 py-2.5 bg-amber-50 text-amber-700 rounded-xl hover:bg-amber-100 transition-colors cursor-pointer border border-amber-200">
                                    <i class="ph ph-upload-simple mr-2"></i>
                                    Ganti Gambar
                                </label>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="flex items-center justify-end gap-3 mt-8 pt-6 border-t border-slate-200">
                    <a href="<?= base_url('admin/sertifikat') ?>" class="px-6 py-3 text-slate-600 hover:bg-slate-100 rounded-xl transition-colors flex items-center">
                        <i class="ph ph-x mr-2"></i>
                        Batal
                    </a>
                    <button type="submit" class="px-6 py-3 bg-gradient-to-r from-amber-500 to-orange-500 text-white rounded-xl hover:from-amber-600 hover:to-orange-600 transition-all shadow-lg shadow-amber-500/25 flex items-center">
                        <i class="ph ph-floppy-disk mr-2"></i>
                        Simpan Perubahan
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Decorative Right Panel -->
    <div class="hidden lg:block">
        <div class="sticky top-24 space-y-6">
            <!-- Current Data Card -->
            <div class="bg-gradient-to-br from-amber-500 to-orange-600 rounded-2xl p-6 text-white shadow-xl shadow-amber-500/20">
                <div class="w-16 h-16 bg-white/20 rounded-2xl flex items-center justify-center mb-4 overflow-hidden">
                    <?php if ($sertifikat['file_sertifikat']): ?>
                    <img src="<?= base_url('uploads/sertifikat/' . $sertifikat['file_sertifikat']) ?>" class="w-full h-full object-cover">
                    <?php else: ?>
                    <i class="ph ph-certificate text-4xl"></i>
                    <?php endif; ?>
                </div>
                <h3 class="text-lg font-bold mb-1 truncate"><?= $sertifikat['nama_sertifikat'] ?></h3>
                <p class="text-amber-100 text-sm"><?= $sertifikat['penerbit'] ?></p>
            </div>

            <!-- Info Card -->
            <div class="bg-white rounded-2xl p-6 border border-slate-200 shadow-sm">
                <h4 class="font-semibold text-slate-800 mb-4 flex items-center">
                    <i class="ph ph-info text-blue-500 text-xl mr-2"></i>
                    Informasi Data
                </h4>
                <div class="space-y-3 text-sm">
                    <div class="flex items-center justify-between p-3 bg-slate-50 rounded-lg">
                        <span class="text-slate-500">ID</span>
                        <span class="font-medium text-slate-800">#<?= $sertifikat['id'] ?></span>
                    </div>
                    <div class="flex items-center justify-between p-3 bg-slate-50 rounded-lg">
                        <span class="text-slate-500">Tanggal</span>
                        <span class="font-medium text-slate-800"><?= $sertifikat['tanggal'] ? date('d M Y', strtotime($sertifikat['tanggal'])) : '-' ?></span>
                    </div>
                    <?php if ($sertifikat['credential_url']): ?>
                    <a href="<?= $sertifikat['credential_url'] ?>" target="_blank" class="flex items-center justify-between p-3 bg-blue-50 hover:bg-blue-100 rounded-lg transition-colors">
                        <span class="text-blue-600">Lihat Credential</span>
                        <i class="ph ph-arrow-square-out text-blue-500"></i>
                    </a>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="bg-white rounded-2xl p-6 border border-slate-200 shadow-sm">
                <h4 class="font-semibold text-slate-800 mb-4 flex items-center">
                    <i class="ph ph-lightning text-amber-500 text-xl mr-2"></i>
                    Aksi Cepat
                </h4>
                <div class="space-y-2">
                    <a href="<?= base_url('admin/sertifikat') ?>" class="flex items-center p-3 bg-slate-50 hover:bg-slate-100 rounded-lg transition-colors">
                        <i class="ph ph-list text-slate-500 mr-3"></i>
                        <span class="text-sm text-slate-700">Kembali ke Daftar</span>
                    </a>
                    <a href="<?= base_url('admin/sertifikat/create') ?>" class="flex items-center p-3 bg-rose-50 hover:bg-rose-100 rounded-lg transition-colors">
                        <i class="ph ph-plus-circle text-rose-500 mr-3"></i>
                        <span class="text-sm text-rose-700">Tambah Baru</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function previewFile(input) {
    const file = input.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            const container = document.getElementById('preview-container');
            container.innerHTML = `<img src="${e.target.result}" class="w-full h-full object-cover">`;
        }
        reader.readAsDataURL(file);
    }
}
</script>
<?= $this->endSection() ?>
