<?= $this->extend('layout/admin') ?>

<?= $this->section('content') ?>
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Form Section -->
    <div class="lg:col-span-2">
        <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
            <div class="p-6 border-b border-slate-200 bg-gradient-to-r from-rose-500 to-pink-600">
                <h2 class="font-semibold text-white flex items-center">
                    <i class="ph ph-certificate text-xl mr-2"></i>
                    Tambah Sertifikat
                </h2>
                <p class="text-rose-100 text-sm mt-1">Dokumentasikan sertifikasi dan prestasi Anda</p>
            </div>
            
            <form action="<?= base_url('admin/sertifikat/store') ?>" method="POST" enctype="multipart/form-data" class="p-6">
                <?= csrf_field() ?>
                
                <?php if (session()->getFlashdata('errors')): ?>
                <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-xl">
                    <ul class="list-disc list-inside text-sm text-red-600">
                        <?php foreach (session()->getFlashdata('errors') as $error): ?>
                        <li><?= $error ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>

                <div class="space-y-5">
                    <div>
                        <label for="nama_sertifikat" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-certificate text-rose-500 mr-1"></i>
                            Nama Sertifikat <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="nama_sertifikat" id="nama_sertifikat" value="<?= old('nama_sertifikat') ?>" placeholder="Contoh: Google Cloud Certified" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-rose-500 focus:ring-2 focus:ring-rose-500/20 transition-all" required>
                    </div>

                    <div>
                        <label for="penerbit" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-buildings text-rose-500 mr-1"></i>
                            Penerbit <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="penerbit" id="penerbit" value="<?= old('penerbit') ?>" placeholder="Contoh: Google, Coursera, Dicoding" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-rose-500 focus:ring-2 focus:ring-rose-500/20 transition-all" required>
                    </div>

                    <div>
                        <label for="tanggal" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-calendar text-rose-500 mr-1"></i>
                            Tanggal Terbit
                        </label>
                        <input type="date" name="tanggal" id="tanggal" value="<?= old('tanggal') ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-rose-500 focus:ring-2 focus:ring-rose-500/20 transition-all">
                    </div>

                    <div>
                        <label for="credential_url" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-link text-rose-500 mr-1"></i>
                            Credential URL
                        </label>
                        <input type="url" name="credential_url" id="credential_url" value="<?= old('credential_url') ?>" placeholder="https://..." class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-rose-500 focus:ring-2 focus:ring-rose-500/20 transition-all">
                    </div>

                    <div>
                        <label for="deskripsi" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-article text-rose-500 mr-1"></i>
                            Deskripsi
                        </label>
                        <textarea name="deskripsi" id="deskripsi" rows="3" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-rose-500 focus:ring-2 focus:ring-rose-500/20 transition-all resize-none" placeholder="Deskripsi singkat tentang sertifikat..."><?= old('deskripsi') ?></textarea>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-image text-rose-500 mr-1"></i>
                            Gambar Sertifikat
                        </label>
                        <div class="flex items-center gap-4">
                            <div class="w-24 h-24 rounded-xl overflow-hidden bg-slate-100 flex items-center justify-center border-2 border-dashed border-slate-200" id="preview-container">
                                <i class="ph ph-image text-3xl text-slate-400"></i>
                            </div>
                            <div class="flex-1">
                                <input type="file" name="file_sertifikat" id="file_sertifikat" accept="image/*" class="hidden" onchange="previewFile(this)">
                                <label for="file_sertifikat" class="inline-flex items-center px-4 py-2.5 bg-rose-50 text-rose-700 rounded-xl hover:bg-rose-100 transition-colors cursor-pointer border border-rose-200">
                                    <i class="ph ph-upload-simple mr-2"></i>
                                    Pilih Gambar
                                </label>
                                <p class="text-xs text-slate-500 mt-2">JPG, PNG. Maks 2MB.</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="flex items-center justify-end gap-3 mt-8 pt-6 border-t border-slate-200">
                    <a href="<?= base_url('admin/sertifikat') ?>" class="px-6 py-3 text-slate-600 hover:bg-slate-100 rounded-xl transition-colors flex items-center">
                        <i class="ph ph-x mr-2"></i>
                        Batal
                    </a>
                    <button type="submit" class="px-6 py-3 bg-gradient-to-r from-rose-500 to-pink-600 text-white rounded-xl hover:from-rose-600 hover:to-pink-700 transition-all shadow-lg shadow-rose-500/25 flex items-center">
                        <i class="ph ph-floppy-disk mr-2"></i>
                        Simpan
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Decorative Right Panel -->
    <div class="hidden lg:block">
        <div class="sticky top-24 space-y-6">
            <!-- Info Card -->
            <div class="bg-gradient-to-br from-rose-500 to-pink-600 rounded-2xl p-6 text-white shadow-xl shadow-rose-500/20">
                <div class="w-16 h-16 bg-white/20 rounded-2xl flex items-center justify-center mb-4">
                    <i class="ph ph-medal text-4xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-2">Sertifikat & Prestasi</h3>
                <p class="text-rose-100 text-sm leading-relaxed">
                    Tunjukkan kredensial dan pencapaian Anda untuk meningkatkan daya tarik portfolio.
                </p>
            </div>

            <!-- Tips Card -->
            <div class="bg-white rounded-2xl p-6 border border-slate-200 shadow-sm">
                <h4 class="font-semibold text-slate-800 mb-4 flex items-center">
                    <i class="ph ph-lightbulb text-amber-500 text-xl mr-2"></i>
                    Tips Sertifikat
                </h4>
                <ul class="space-y-3 text-sm text-slate-600">
                    <li class="flex items-start">
                        <i class="ph ph-check-circle text-green-500 mt-0.5 mr-2 flex-shrink-0"></i>
                        <span>Sertakan URL verifikasi jika ada</span>
                    </li>
                    <li class="flex items-start">
                        <i class="ph ph-check-circle text-green-500 mt-0.5 mr-2 flex-shrink-0"></i>
                        <span>Upload gambar sertifikat dengan jelas</span>
                    </li>
                    <li class="flex items-start">
                        <i class="ph ph-check-circle text-green-500 mt-0.5 mr-2 flex-shrink-0"></i>
                        <span>Tulis deskripsi tentang apa yang dipelajari</span>
                    </li>
                </ul>
            </div>

            <!-- Popular Issuers -->
            <div class="bg-white rounded-2xl p-6 border border-slate-200 shadow-sm">
                <h4 class="font-semibold text-slate-800 mb-4 flex items-center">
                    <i class="ph ph-star text-amber-500 text-xl mr-2"></i>
                    Penerbit Populer
                </h4>
                <div class="flex flex-wrap gap-2">
                    <span class="px-3 py-1.5 bg-blue-100 text-blue-700 rounded-full text-xs font-medium">Google</span>
                    <span class="px-3 py-1.5 bg-indigo-100 text-indigo-700 rounded-full text-xs font-medium">Coursera</span>
                    <span class="px-3 py-1.5 bg-green-100 text-green-700 rounded-full text-xs font-medium">Dicoding</span>
                    <span class="px-3 py-1.5 bg-orange-100 text-orange-700 rounded-full text-xs font-medium">AWS</span>
                    <span class="px-3 py-1.5 bg-cyan-100 text-cyan-700 rounded-full text-xs font-medium">Microsoft</span>
                    <span class="px-3 py-1.5 bg-purple-100 text-purple-700 rounded-full text-xs font-medium">Udemy</span>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function previewFile(input) {
    const file = input.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            const container = document.getElementById('preview-container');
            container.innerHTML = `<img src="${e.target.result}" class="w-full h-full object-cover">`;
        }
        reader.readAsDataURL(file);
    }
}
</script>
<?= $this->endSection() ?>
