<?= $this->extend('layout/admin') ?>

<?= $this->section('content') ?>
<div class="space-y-6">
    <!-- Header -->
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
        <div>
            <h2 class="text-lg font-semibold text-slate-800">Daftar Pendidikan</h2>
            <p class="text-sm text-slate-500">Kelola data riwayat pendidikan</p>
        </div>
        <a href="<?= base_url('admin/pendidikan/create') ?>" class="inline-flex items-center px-4 py-2 bg-primary-500 text-white rounded-xl hover:bg-primary-600 transition-colors">
            <i class="ph ph-plus mr-2"></i>
            Tambah Pendidikan
        </a>
    </div>

    <!-- Search & Filter -->
    <div class="bg-white rounded-2xl shadow-sm border border-slate-200 p-4">
        <form action="" method="GET" class="flex flex-col md:flex-row gap-4">
            <div class="flex-1">
                <div class="relative">
                    <i class="ph ph-magnifying-glass absolute left-4 top-1/2 -translate-y-1/2 text-slate-400"></i>
                    <input type="text" name="search" value="<?= $search ?>" placeholder="Cari..." class="w-full pl-12 pr-4 py-2.5 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-primary-500 transition-all">
                </div>
            </div>
            <div class="flex gap-3">
                <select name="jenjang" class="px-4 py-2.5 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-primary-500 transition-all">
                    <option value="">Semua Jenjang</option>
                    <?php foreach ($jenjangList as $j): ?>
                    <option value="<?= $j ?>" <?= $jenjang === $j ? 'selected' : '' ?>><?= $j ?></option>
                    <?php endforeach; ?>
                </select>
                <button type="submit" class="px-4 py-2.5 bg-primary-500 text-white rounded-xl hover:bg-primary-600 transition-colors">
                    <i class="ph ph-funnel"></i>
                </button>
                <?php if ($search || $jenjang): ?>
                <a href="<?= base_url('admin/pendidikan') ?>" class="px-4 py-2.5 bg-slate-100 text-slate-600 rounded-xl hover:bg-slate-200 transition-colors">
                    <i class="ph ph-x"></i>
                </a>
                <?php endif; ?>
            </div>
        </form>
    </div>

    <!-- Table -->
    <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
        <?php if (!empty($pendidikan)): ?>
        <div class="overflow-x-auto">
            <table class="w-full responsive-table">
                <thead class="bg-slate-50 border-b border-slate-200">
                    <tr>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Jenjang</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Nama Sekolah</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Jurusan</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Tahun</th>
                        <th class="px-6 py-4 text-right text-xs font-semibold text-slate-600 uppercase tracking-wider">Aksi</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-slate-200">
                    <?php foreach ($pendidikan as $item): ?>
                    <tr class="table-row-hover">
                        <td class="px-6 py-4" data-label="Jenjang">
                            <?php 
                            $jenjangValue = trim($item['jenjang'] ?? '');
                            $jenjangColors = [
                                'TK' => 'bg-pink-100 text-pink-600',
                                'SD' => 'bg-blue-100 text-blue-600',
                                'SMP' => 'bg-green-100 text-green-600',
                                'SMA' => 'bg-yellow-100 text-yellow-600',
                                'SMK' => 'bg-orange-100 text-orange-600',
                                'D1' => 'bg-cyan-100 text-cyan-600',
                                'D2' => 'bg-cyan-100 text-cyan-600',
                                'D3' => 'bg-teal-100 text-teal-600',
                                'D4' => 'bg-teal-100 text-teal-600',
                                'S1-Sarjana' => 'bg-purple-100 text-purple-600',
                                'S2-Magister' => 'bg-indigo-100 text-indigo-600',
                                'S3-Doktor' => 'bg-violet-100 text-violet-600',
                                'Profesi' => 'bg-rose-100 text-rose-600',
                                'Kursus' => 'bg-amber-100 text-amber-600',
                                'Kuliah' => 'bg-purple-100 text-purple-600',
                            ];
                            $badgeClass = $jenjangColors[$jenjangValue] ?? 'bg-slate-100 text-slate-600';
                            $displayValue = $jenjangValue !== '' ? $jenjangValue : '(Belum diisi)';
                            ?>
                            <span class="px-3 py-1.5 <?= $badgeClass ?> rounded-full text-xs font-semibold whitespace-nowrap">
                                <?= $displayValue ?>
                            </span>
                        </td>
                        <td class="px-6 py-4 font-medium text-slate-800" data-label="Sekolah"><?= $item['nama_sekolah'] ?></td>
                        <td class="px-6 py-4 text-slate-600" data-label="Jurusan"><?= $item['jurusan'] ?? '-' ?></td>
                        <td class="px-6 py-4 text-slate-600" data-label="Tahun"><?= $item['tahun_masuk'] ?> - <?= $item['tahun_lulus'] ?? 'Sekarang' ?></td>
                        <td class="px-6 py-4" data-label="Aksi">
                            <div class="flex items-center justify-end gap-2">
                                <a href="<?= base_url('admin/pendidikan/edit/' . $item['id']) ?>" class="p-2 text-slate-600 hover:text-primary-600 hover:bg-primary-50 rounded-lg transition-colors" title="Edit">
                                    <i class="ph ph-pencil-simple text-lg"></i>
                                </a>
                                <button onclick="confirmDelete(<?= $item['id'] ?>, '<?= addslashes($item['nama_sekolah']) ?>')" class="p-2 text-slate-600 hover:text-red-600 hover:bg-red-50 rounded-lg transition-colors" title="Hapus">
                                    <i class="ph ph-trash text-lg"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if ($pager && $pager->getPageCount() > 1): ?>
        <div class="px-6 py-4 border-t border-slate-200 flex items-center justify-between">
            <p class="text-sm text-slate-500">Menampilkan <?= count($pendidikan) ?> dari <?= $pager->getTotal() ?> data</p>
            <?= $pager->links('default', 'default_full') ?>
        </div>
        <?php endif; ?>

        <?php else: ?>
        <div class="p-12 text-center">
            <div class="w-16 h-16 bg-slate-100 rounded-full flex items-center justify-center mx-auto mb-4">
                <i class="ph ph-graduation-cap text-3xl text-slate-400"></i>
            </div>
            <h3 class="text-lg font-semibold text-slate-800 mb-2">Belum Ada Data</h3>
            <p class="text-slate-500 mb-4">Data pendidikan belum tersedia.</p>
            <a href="<?= base_url('admin/pendidikan/create') ?>" class="inline-flex items-center px-4 py-2 bg-primary-500 text-white rounded-xl hover:bg-primary-600 transition-colors">
                <i class="ph ph-plus mr-2"></i>
                Tambah Pendidikan
            </a>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Delete Modal -->
<div id="deleteModal" class="fixed inset-0 z-50 hidden" x-data="{ open: false }">
    <div class="absolute inset-0 bg-black/50"></div>
    <div class="absolute inset-0 flex items-center justify-center p-4">
        <div class="bg-white rounded-2xl shadow-xl max-w-md w-full p-6">
            <div class="text-center">
                <div class="w-16 h-16 bg-red-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="ph ph-warning text-3xl text-red-600"></i>
                </div>
                <h3 class="text-lg font-semibold text-slate-800 mb-2">Hapus Data?</h3>
                <p class="text-slate-500 mb-6">Apakah Anda yakin ingin menghapus <strong id="deleteName"></strong>? Tindakan ini tidak dapat dibatalkan.</p>
                <form id="deleteForm" method="POST" class="flex gap-3 justify-center">
                    <button type="button" onclick="closeDeleteModal()" class="px-6 py-2.5 bg-slate-100 text-slate-600 rounded-xl hover:bg-slate-200 transition-colors">Batal</button>
                    <button type="submit" class="px-6 py-2.5 bg-red-500 text-white rounded-xl hover:bg-red-600 transition-colors">Hapus</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function confirmDelete(id, name) {
    document.getElementById('deleteName').textContent = name;
    document.getElementById('deleteForm').action = '<?= base_url('admin/pendidikan/delete/') ?>' + id;
    document.getElementById('deleteModal').classList.remove('hidden');
}
function closeDeleteModal() {
    document.getElementById('deleteModal').classList.add('hidden');
}
</script>
<?= $this->endSection() ?>
