<?= $this->extend('layout/admin') ?>

<?= $this->section('content') ?>
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Form Section -->
    <div class="lg:col-span-2">
        <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
            <div class="p-6 border-b border-slate-200 bg-gradient-to-r from-amber-500 to-orange-500">
                <h2 class="font-semibold text-white flex items-center">
                    <i class="ph ph-pencil-simple text-xl mr-2"></i>
                    Edit Pendidikan
                </h2>
                <p class="text-amber-100 text-sm mt-1">Perbarui data riwayat pendidikan</p>
            </div>
            
            <form action="<?= base_url('admin/pendidikan/update/' . $pendidikan['id']) ?>" method="POST" class="p-6">
                <?= csrf_field() ?>
                
                <?php if (session()->getFlashdata('errors')): ?>
                <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-xl">
                    <ul class="list-disc list-inside text-sm text-red-600">
                        <?php foreach (session()->getFlashdata('errors') as $error): ?>
                        <li><?= $error ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>

                <div class="space-y-5">
                    <div>
                        <label for="jenjang" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-list-bullets text-amber-500 mr-1"></i>
                            Jenjang <span class="text-red-500">*</span>
                        </label>
                        <select name="jenjang" id="jenjang" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-amber-500 focus:ring-2 focus:ring-amber-500/20 transition-all" required>
                            <option value="">Pilih Jenjang</option>
                            <?php foreach ($jenjangList as $j): ?>
                            <option value="<?= $j ?>" <?= old('jenjang', $pendidikan['jenjang']) === $j ? 'selected' : '' ?>><?= $j ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div>
                        <label for="nama_sekolah" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-buildings text-amber-500 mr-1"></i>
                            Nama Sekolah/Universitas <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="nama_sekolah" id="nama_sekolah" value="<?= old('nama_sekolah', $pendidikan['nama_sekolah']) ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-amber-500 focus:ring-2 focus:ring-amber-500/20 transition-all" placeholder="Contoh: Universitas Indonesia" required>
                    </div>

                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                        <div>
                            <label for="tahun_masuk" class="block text-sm font-medium text-slate-700 mb-2">
                                <i class="ph ph-calendar text-amber-500 mr-1"></i>
                                Tahun Masuk <span class="text-red-500">*</span>
                            </label>
                            <input type="number" name="tahun_masuk" id="tahun_masuk" value="<?= old('tahun_masuk', $pendidikan['tahun_masuk']) ?>" min="1990" max="<?= date('Y') ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-amber-500 focus:ring-2 focus:ring-amber-500/20 transition-all" required>
                        </div>
                        <div>
                            <label for="tahun_lulus" class="block text-sm font-medium text-slate-700 mb-2">
                                <i class="ph ph-calendar-check text-amber-500 mr-1"></i>
                                Tahun Lulus
                            </label>
                            <input type="number" name="tahun_lulus" id="tahun_lulus" value="<?= old('tahun_lulus', $pendidikan['tahun_lulus']) ?>" min="1990" max="<?= date('Y') + 10 ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-amber-500 focus:ring-2 focus:ring-amber-500/20 transition-all" placeholder="Kosongkan jika belum">
                        </div>
                    </div>

                    <div>
                        <label for="jurusan" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-book-open text-amber-500 mr-1"></i>
                            Jurusan
                        </label>
                        <input type="text" name="jurusan" id="jurusan" value="<?= old('jurusan', $pendidikan['jurusan']) ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-amber-500 focus:ring-2 focus:ring-amber-500/20 transition-all" placeholder="Contoh: Teknik Informatika (opsional)">
                    </div>
                </div>

                <div class="flex items-center justify-end gap-3 mt-8 pt-6 border-t border-slate-200">
                    <a href="<?= base_url('admin/pendidikan') ?>" class="px-6 py-3 text-slate-600 hover:bg-slate-100 rounded-xl transition-colors flex items-center">
                        <i class="ph ph-x mr-2"></i>
                        Batal
                    </a>
                    <button type="submit" class="px-6 py-3 bg-gradient-to-r from-amber-500 to-orange-500 text-white rounded-xl hover:from-amber-600 hover:to-orange-600 transition-all shadow-lg shadow-amber-500/25 flex items-center">
                        <i class="ph ph-floppy-disk mr-2"></i>
                        Simpan Perubahan
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Decorative Right Panel -->
    <div class="hidden lg:block">
        <div class="sticky top-24 space-y-6">
            <!-- Current Data Card -->
            <div class="bg-gradient-to-br from-amber-500 to-orange-600 rounded-2xl p-6 text-white shadow-xl shadow-amber-500/20">
                <div class="w-16 h-16 bg-white/20 rounded-2xl flex items-center justify-center mb-4">
                    <i class="ph ph-pencil-simple text-4xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-2">Edit Data</h3>
                <p class="text-amber-100 text-sm leading-relaxed">
                    Anda sedang mengedit data pendidikan:
                </p>
                <div class="mt-4 p-3 bg-white/10 rounded-xl">
                    <p class="font-semibold text-white"><?= $pendidikan['nama_sekolah'] ?></p>
                    <p class="text-amber-100 text-sm"><?= $pendidikan['jenjang'] ?: 'Belum ada jenjang' ?></p>
                </div>
            </div>

            <!-- Info Card -->
            <div class="bg-white rounded-2xl p-6 border border-slate-200 shadow-sm">
                <h4 class="font-semibold text-slate-800 mb-4 flex items-center">
                    <i class="ph ph-info text-blue-500 text-xl mr-2"></i>
                    Informasi Data
                </h4>
                <div class="space-y-3 text-sm">
                    <div class="flex items-center justify-between p-3 bg-slate-50 rounded-lg">
                        <span class="text-slate-500">ID</span>
                        <span class="font-medium text-slate-800">#<?= $pendidikan['id'] ?></span>
                    </div>
                    <div class="flex items-center justify-between p-3 bg-slate-50 rounded-lg">
                        <span class="text-slate-500">Tahun</span>
                        <span class="font-medium text-slate-800"><?= $pendidikan['tahun_masuk'] ?> - <?= $pendidikan['tahun_lulus'] ?? 'Sekarang' ?></span>
                    </div>
                    <div class="flex items-center justify-between p-3 bg-slate-50 rounded-lg">
                        <span class="text-slate-500">Jurusan</span>
                        <span class="font-medium text-slate-800"><?= $pendidikan['jurusan'] ?: '-' ?></span>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="bg-white rounded-2xl p-6 border border-slate-200 shadow-sm">
                <h4 class="font-semibold text-slate-800 mb-4 flex items-center">
                    <i class="ph ph-lightning text-amber-500 text-xl mr-2"></i>
                    Aksi Cepat
                </h4>
                <div class="space-y-2">
                    <a href="<?= base_url('admin/pendidikan') ?>" class="flex items-center p-3 bg-slate-50 hover:bg-slate-100 rounded-lg transition-colors">
                        <i class="ph ph-list text-slate-500 mr-3"></i>
                        <span class="text-sm text-slate-700">Kembali ke Daftar</span>
                    </a>
                    <a href="<?= base_url('admin/pendidikan/create') ?>" class="flex items-center p-3 bg-primary-50 hover:bg-primary-100 rounded-lg transition-colors">
                        <i class="ph ph-plus-circle text-primary-500 mr-3"></i>
                        <span class="text-sm text-primary-700">Tambah Baru</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
