<?= $this->extend('layout/admin') ?>

<?= $this->section('content') ?>
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Form Section -->
    <div class="lg:col-span-2">
        <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
            <div class="p-6 border-b border-slate-200 bg-gradient-to-r from-primary-500 to-primary-600">
                <h2 class="font-semibold text-white flex items-center">
                    <i class="ph ph-graduation-cap text-xl mr-2"></i>
                    Tambah Pendidikan
                </h2>
                <p class="text-primary-100 text-sm mt-1">Isi data riwayat pendidikan Anda</p>
            </div>
            
            <form action="<?= base_url('admin/pendidikan/store') ?>" method="POST" class="p-6">
                <?= csrf_field() ?>
                
                <?php if (session()->getFlashdata('errors')): ?>
                <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-xl">
                    <ul class="list-disc list-inside text-sm text-red-600">
                        <?php foreach (session()->getFlashdata('errors') as $error): ?>
                        <li><?= $error ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>

                <div class="space-y-5">
                    <div>
                        <label for="jenjang" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-list-bullets text-primary-500 mr-1"></i>
                            Jenjang <span class="text-red-500">*</span>
                        </label>
                        <select name="jenjang" id="jenjang" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-primary-500 focus:ring-2 focus:ring-primary-500/20 transition-all" required>
                            <option value="">Pilih Jenjang</option>
                            <?php foreach ($jenjangList as $j): ?>
                            <option value="<?= $j ?>" <?= old('jenjang') === $j ? 'selected' : '' ?>><?= $j ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div>
                        <label for="nama_sekolah" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-buildings text-primary-500 mr-1"></i>
                            Nama Sekolah/Universitas <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="nama_sekolah" id="nama_sekolah" value="<?= old('nama_sekolah') ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-primary-500 focus:ring-2 focus:ring-primary-500/20 transition-all" placeholder="Contoh: Universitas Indonesia" required>
                    </div>

                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                        <div>
                            <label for="tahun_masuk" class="block text-sm font-medium text-slate-700 mb-2">
                                <i class="ph ph-calendar text-primary-500 mr-1"></i>
                                Tahun Masuk <span class="text-red-500">*</span>
                            </label>
                            <input type="number" name="tahun_masuk" id="tahun_masuk" value="<?= old('tahun_masuk') ?>" min="1990" max="<?= date('Y') ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-primary-500 focus:ring-2 focus:ring-primary-500/20 transition-all" placeholder="<?= date('Y') ?>" required>
                        </div>
                        <div>
                            <label for="tahun_lulus" class="block text-sm font-medium text-slate-700 mb-2">
                                <i class="ph ph-calendar-check text-primary-500 mr-1"></i>
                                Tahun Lulus
                            </label>
                            <input type="number" name="tahun_lulus" id="tahun_lulus" value="<?= old('tahun_lulus') ?>" min="1990" max="<?= date('Y') + 10 ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-primary-500 focus:ring-2 focus:ring-primary-500/20 transition-all" placeholder="Kosongkan jika belum">
                        </div>
                    </div>

                    <div>
                        <label for="jurusan" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-book-open text-primary-500 mr-1"></i>
                            Jurusan
                        </label>
                        <input type="text" name="jurusan" id="jurusan" value="<?= old('jurusan') ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-primary-500 focus:ring-2 focus:ring-primary-500/20 transition-all" placeholder="Contoh: Teknik Informatika (opsional)">
                    </div>
                </div>

                <div class="flex items-center justify-end gap-3 mt-8 pt-6 border-t border-slate-200">
                    <a href="<?= base_url('admin/pendidikan') ?>" class="px-6 py-3 text-slate-600 hover:bg-slate-100 rounded-xl transition-colors flex items-center">
                        <i class="ph ph-x mr-2"></i>
                        Batal
                    </a>
                    <button type="submit" class="px-6 py-3 bg-gradient-to-r from-primary-500 to-primary-600 text-white rounded-xl hover:from-primary-600 hover:to-primary-700 transition-all shadow-lg shadow-primary-500/25 flex items-center">
                        <i class="ph ph-floppy-disk mr-2"></i>
                        Simpan
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Decorative Right Panel -->
    <div class="hidden lg:block">
        <div class="sticky top-24 space-y-6">
            <!-- Info Card -->
            <div class="bg-gradient-to-br from-primary-500 to-primary-700 rounded-2xl p-6 text-white shadow-xl shadow-primary-500/20">
                <div class="w-16 h-16 bg-white/20 rounded-2xl flex items-center justify-center mb-4">
                    <i class="ph ph-graduation-cap text-4xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-2">Riwayat Pendidikan</h3>
                <p class="text-primary-100 text-sm leading-relaxed">
                    Tambahkan riwayat pendidikan Anda dari TK hingga Perguruan Tinggi untuk melengkapi profil portfolio.
                </p>
            </div>

            <!-- Tips Card -->
            <div class="bg-white rounded-2xl p-6 border border-slate-200 shadow-sm">
                <h4 class="font-semibold text-slate-800 mb-4 flex items-center">
                    <i class="ph ph-lightbulb text-amber-500 text-xl mr-2"></i>
                    Tips Pengisian
                </h4>
                <ul class="space-y-3 text-sm text-slate-600">
                    <li class="flex items-start">
                        <i class="ph ph-check-circle text-green-500 mt-0.5 mr-2 flex-shrink-0"></i>
                        <span>Pilih jenjang yang sesuai dengan institusi pendidikan</span>
                    </li>
                    <li class="flex items-start">
                        <i class="ph ph-check-circle text-green-500 mt-0.5 mr-2 flex-shrink-0"></i>
                        <span>Gunakan nama resmi sekolah/universitas</span>
                    </li>
                    <li class="flex items-start">
                        <i class="ph ph-check-circle text-green-500 mt-0.5 mr-2 flex-shrink-0"></i>
                        <span>Kosongkan tahun lulus jika masih aktif</span>
                    </li>
                    <li class="flex items-start">
                        <i class="ph ph-check-circle text-green-500 mt-0.5 mr-2 flex-shrink-0"></i>
                        <span>Isi jurusan untuk jenjang SMA ke atas</span>
                    </li>
                </ul>
            </div>

            <!-- Jenjang Preview -->
            <div class="bg-white rounded-2xl p-6 border border-slate-200 shadow-sm">
                <h4 class="font-semibold text-slate-800 mb-4 flex items-center">
                    <i class="ph ph-info text-blue-500 text-xl mr-2"></i>
                    Pilihan Jenjang
                </h4>
                <div class="flex flex-wrap gap-2">
                    <span class="px-2.5 py-1 bg-pink-100 text-pink-600 rounded-full text-xs font-medium">TK</span>
                    <span class="px-2.5 py-1 bg-blue-100 text-blue-600 rounded-full text-xs font-medium">SD</span>
                    <span class="px-2.5 py-1 bg-green-100 text-green-600 rounded-full text-xs font-medium">SMP</span>
                    <span class="px-2.5 py-1 bg-yellow-100 text-yellow-600 rounded-full text-xs font-medium">SMA</span>
                    <span class="px-2.5 py-1 bg-orange-100 text-orange-600 rounded-full text-xs font-medium">SMK</span>
                    <span class="px-2.5 py-1 bg-cyan-100 text-cyan-600 rounded-full text-xs font-medium">D1-D4</span>
                    <span class="px-2.5 py-1 bg-purple-100 text-purple-600 rounded-full text-xs font-medium">S1-Sarjana</span>
                    <span class="px-2.5 py-1 bg-indigo-100 text-indigo-600 rounded-full text-xs font-medium">S2-Magister</span>
                    <span class="px-2.5 py-1 bg-violet-100 text-violet-600 rounded-full text-xs font-medium">S3-Doktor</span>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
