<?= $this->extend('layout/admin') ?>

<?= $this->section('content') ?>
<div class="space-y-6">
    <!-- Header -->
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
        <div>
            <h2 class="text-lg font-semibold text-slate-800">Galeri Foto & Video</h2>
            <p class="text-sm text-slate-500">Kelola foto dan video dokumentasi</p>
        </div>
        <a href="<?= base_url('admin/galeri/create') ?>" class="inline-flex items-center px-4 py-2 bg-primary-500 text-white rounded-xl hover:bg-primary-600 transition-colors">
            <i class="ph ph-plus mr-2"></i>
            Tambah Media
        </a>
    </div>

    <!-- Filter -->
    <div class="bg-white rounded-2xl shadow-sm border border-slate-200 p-4">
        <form action="" method="GET" class="flex flex-col md:flex-row gap-4">
            <div class="flex-1">
                <div class="relative">
                    <i class="ph ph-magnifying-glass absolute left-4 top-1/2 -translate-y-1/2 text-slate-400"></i>
                    <input type="text" name="search" value="<?= $search ?>" placeholder="Cari..." class="w-full pl-12 pr-4 py-2.5 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-primary-500 transition-all">
                </div>
            </div>
            <div class="flex gap-3">
                <select name="tipe" class="px-4 py-2.5 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-primary-500 transition-all">
                    <option value="">Semua Tipe</option>
                    <option value="foto" <?= $tipe === 'foto' ? 'selected' : '' ?>>Foto</option>
                    <option value="video" <?= $tipe === 'video' ? 'selected' : '' ?>>Video</option>
                </select>
                <button type="submit" class="px-4 py-2.5 bg-primary-500 text-white rounded-xl hover:bg-primary-600 transition-colors">
                    <i class="ph ph-funnel"></i>
                </button>
                <?php if ($search || $tipe): ?>
                <a href="<?= base_url('admin/galeri') ?>" class="px-4 py-2.5 bg-slate-100 text-slate-600 rounded-xl hover:bg-slate-200 transition-colors">
                    <i class="ph ph-x"></i>
                </a>
                <?php endif; ?>
            </div>
        </form>
    </div>

    <!-- Grid -->
    <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4">
        <?php if (!empty($galeri)): ?>
        <?php foreach ($galeri as $item): ?>
        <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden group hover:shadow-md transition-shadow">
            <div class="relative aspect-square overflow-hidden bg-slate-100">
                <?php if ($item['tipe'] === 'video'): ?>
                    <?php if ($item['thumbnail']): ?>
                    <img src="<?= base_url('uploads/galeri/' . $item['thumbnail']) ?>" alt="<?= $item['judul'] ?>" class="w-full h-full object-cover">
                    <?php elseif ($item['file']): ?>
                    <video src="<?= base_url('uploads/galeri/' . $item['file']) ?>" class="w-full h-full object-cover" muted></video>
                    <?php else: ?>
                    <div class="w-full h-full flex items-center justify-center">
                        <i class="ph ph-video text-4xl text-slate-400"></i>
                    </div>
                    <?php endif; ?>
                    <div class="absolute inset-0 flex items-center justify-center bg-black/30">
                        <div class="w-12 h-12 bg-white/90 rounded-full flex items-center justify-center">
                            <i class="ph ph-play-fill text-2xl text-slate-800"></i>
                        </div>
                    </div>
                <?php else: ?>
                    <?php if ($item['file']): ?>
                    <img src="<?= base_url('uploads/galeri/' . $item['file']) ?>" alt="<?= $item['judul'] ?>" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-300">
                    <?php else: ?>
                    <div class="w-full h-full flex items-center justify-center">
                        <i class="ph ph-image text-4xl text-slate-400"></i>
                    </div>
                    <?php endif; ?>
                <?php endif; ?>
                
                <!-- Actions overlay -->
                <div class="absolute top-2 right-2 opacity-0 group-hover:opacity-100 transition-opacity flex gap-1">
                    <a href="<?= base_url('admin/galeri/edit/' . $item['id']) ?>" class="w-8 h-8 bg-white rounded-lg flex items-center justify-center text-slate-600 hover:text-primary-600 shadow-sm">
                        <i class="ph ph-pencil-simple"></i>
                    </a>
                    <button onclick="confirmDelete(<?= $item['id'] ?>, '<?= addslashes($item['judul']) ?>')" class="w-8 h-8 bg-white rounded-lg flex items-center justify-center text-slate-600 hover:text-red-600 shadow-sm">
                        <i class="ph ph-trash"></i>
                    </button>
                </div>
                
                <!-- Type badge -->
                <div class="absolute bottom-2 left-2">
                    <span class="px-2 py-1 text-xs font-medium rounded-lg <?= $item['tipe'] === 'video' ? 'bg-red-500 text-white' : 'bg-blue-500 text-white' ?>">
                        <?= ucfirst($item['tipe']) ?>
                    </span>
                </div>
            </div>
            <div class="p-3">
                <h3 class="font-medium text-slate-800 text-sm line-clamp-1"><?= $item['judul'] ?></h3>
                <p class="text-xs text-slate-500"><?= date('d M Y', strtotime($item['tanggal'] ?? $item['created_at'])) ?></p>
            </div>
        </div>
        <?php endforeach; ?>
        <?php else: ?>
        <div class="col-span-full bg-white rounded-2xl shadow-sm border border-slate-200 p-12 text-center">
            <div class="w-16 h-16 bg-slate-100 rounded-full flex items-center justify-center mx-auto mb-4">
                <i class="ph ph-images text-3xl text-slate-400"></i>
            </div>
            <h3 class="text-lg font-semibold text-slate-800 mb-2">Belum Ada Data</h3>
            <p class="text-slate-500 mb-4">Galeri foto dan video belum tersedia.</p>
            <a href="<?= base_url('admin/galeri/create') ?>" class="inline-flex items-center px-4 py-2 bg-primary-500 text-white rounded-xl hover:bg-primary-600 transition-colors">
                <i class="ph ph-plus mr-2"></i>
                Tambah Media
            </a>
        </div>
        <?php endif; ?>
    </div>

    <!-- Pagination -->
    <?php if ($pager && $pager->getPageCount() > 1): ?>
    <div class="flex justify-center">
        <?= $pager->links('default', 'default_full') ?>
    </div>
    <?php endif; ?>
</div>

<!-- Delete Modal -->
<div id="deleteModal" class="fixed inset-0 z-50 hidden">
    <div class="absolute inset-0 bg-black/50"></div>
    <div class="absolute inset-0 flex items-center justify-center p-4">
        <div class="bg-white rounded-2xl shadow-xl max-w-md w-full p-6">
            <div class="text-center">
                <div class="w-16 h-16 bg-red-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="ph ph-warning text-3xl text-red-600"></i>
                </div>
                <h3 class="text-lg font-semibold text-slate-800 mb-2">Hapus Data?</h3>
                <p class="text-slate-500 mb-6">Apakah Anda yakin ingin menghapus <strong id="deleteName"></strong>?</p>
                <form id="deleteForm" method="POST" class="flex gap-3 justify-center">
                    <button type="button" onclick="closeDeleteModal()" class="px-6 py-2.5 bg-slate-100 text-slate-600 rounded-xl hover:bg-slate-200 transition-colors">Batal</button>
                    <button type="submit" class="px-6 py-2.5 bg-red-500 text-white rounded-xl hover:bg-red-600 transition-colors">Hapus</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function confirmDelete(id, name) {
    document.getElementById('deleteName').textContent = name;
    document.getElementById('deleteForm').action = '<?= base_url('admin/galeri/delete/') ?>' + id;
    document.getElementById('deleteModal').classList.remove('hidden');
}
function closeDeleteModal() {
    document.getElementById('deleteModal').classList.add('hidden');
}
</script>
<?= $this->endSection() ?>
