<?= $this->extend('layout/admin') ?>

<?= $this->section('content') ?>
<!-- Stats Cards -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
    <div class="bg-white rounded-2xl p-6 shadow-sm border border-slate-200">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-slate-500 text-sm font-medium">Total Aktivitas</p>
                <p class="text-3xl font-bold text-slate-800 mt-1"><?= $totalAktivitas ?></p>
            </div>
            <div class="w-12 h-12 bg-primary-100 rounded-xl flex items-center justify-center">
                <i class="ph ph-calendar text-2xl text-primary-600"></i>
            </div>
        </div>
    </div>
    <div class="bg-white rounded-2xl p-6 shadow-sm border border-slate-200">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-slate-500 text-sm font-medium">Total Pendidikan</p>
                <p class="text-3xl font-bold text-slate-800 mt-1"><?= $totalPendidikan ?></p>
            </div>
            <div class="w-12 h-12 bg-green-100 rounded-xl flex items-center justify-center">
                <i class="ph ph-graduation-cap text-2xl text-green-600"></i>
            </div>
        </div>
    </div>
    <div class="bg-white rounded-2xl p-6 shadow-sm border border-slate-200">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-slate-500 text-sm font-medium">Status Biodata</p>
                <p class="text-lg font-bold text-<?= $biodata ? 'green' : 'yellow' ?>-600 mt-1">
                    <?= $biodata ? 'Lengkap' : 'Belum Lengkap' ?>
                </p>
            </div>
            <div class="w-12 h-12 bg-yellow-100 rounded-xl flex items-center justify-center">
                <i class="ph ph-user text-2xl text-yellow-600"></i>
            </div>
        </div>
    </div>
    <div class="bg-white rounded-2xl p-6 shadow-sm border border-slate-200">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-slate-500 text-sm font-medium">Hari Ini</p>
                <p class="text-lg font-bold text-slate-800 mt-1" id="dashboardDate"><?= date('d M Y') ?></p>
                <p class="text-xs text-slate-400 mt-0.5" id="dashboardDay"><?= ['Minggu', 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu'][date('w')] ?></p>
            </div>
            <div class="w-12 h-12 bg-purple-100 rounded-xl flex items-center justify-center">
                <i class="ph ph-calendar-blank text-2xl text-purple-600"></i>
            </div>
        </div>
    </div>
</div>

<script>
function updateDashboardDate() {
    const now = new Date();
    const days = ['Minggu', 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu'];
    const months = ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Agu', 'Sep', 'Okt', 'Nov', 'Des'];
    
    const dateStr = now.getDate().toString().padStart(2, '0') + ' ' + months[now.getMonth()] + ' ' + now.getFullYear();
    const dayStr = days[now.getDay()];
    
    const dateEl = document.getElementById('dashboardDate');
    const dayEl = document.getElementById('dashboardDay');
    if (dateEl) dateEl.textContent = dateStr;
    if (dayEl) dayEl.textContent = dayStr;
}
updateDashboardDate();
setInterval(updateDashboardDate, 60000); // Update every minute
</script>

<!-- Quick Actions -->
<div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
    <div class="bg-white rounded-2xl p-6 shadow-sm border border-slate-200">
        <h3 class="font-semibold text-slate-800 mb-4 flex items-center">
            <i class="ph ph-lightning text-xl text-primary-500 mr-2"></i>
            Aksi Cepat
        </h3>
        <div class="grid grid-cols-2 gap-3">
            <a href="<?= base_url('admin/aktivitas/create') ?>" class="flex items-center px-4 py-3 bg-primary-50 text-primary-600 rounded-xl hover:bg-primary-100 transition-colors">
                <i class="ph ph-plus-circle text-xl mr-2"></i>
                <span class="font-medium text-sm">Tambah Aktivitas</span>
            </a>
            <a href="<?= base_url('admin/pendidikan/create') ?>" class="flex items-center px-4 py-3 bg-green-50 text-green-600 rounded-xl hover:bg-green-100 transition-colors">
                <i class="ph ph-plus-circle text-xl mr-2"></i>
                <span class="font-medium text-sm">Tambah Pendidikan</span>
            </a>
            <a href="<?= base_url('admin/biodata/edit') ?>" class="flex items-center px-4 py-3 bg-yellow-50 text-yellow-600 rounded-xl hover:bg-yellow-100 transition-colors">
                <i class="ph ph-pencil-simple text-xl mr-2"></i>
                <span class="font-medium text-sm">Edit Biodata</span>
            </a>
            <a href="<?= base_url() ?>" target="_blank" class="flex items-center px-4 py-3 bg-slate-50 text-slate-600 rounded-xl hover:bg-slate-100 transition-colors">
                <i class="ph ph-eye text-xl mr-2"></i>
                <span class="font-medium text-sm">Lihat Website</span>
            </a>
        </div>
    </div>

    <!-- Recent Activities -->
    <div class="bg-white rounded-2xl p-6 shadow-sm border border-slate-200">
        <h3 class="font-semibold text-slate-800 mb-4 flex items-center">
            <i class="ph ph-clock-counter-clockwise text-xl text-primary-500 mr-2"></i>
            Aktivitas Terbaru
        </h3>
        <?php if (!empty($recentAktivitas)): ?>
        <div class="space-y-3">
            <?php foreach (array_slice($recentAktivitas, 0, 4) as $aktivitas): ?>
            <div class="flex items-center p-3 bg-slate-50 rounded-xl">
                <div class="w-10 h-10 bg-primary-100 rounded-lg flex items-center justify-center mr-3">
                    <i class="ph ph-calendar text-primary-600"></i>
                </div>
                <div class="flex-1 min-w-0">
                    <p class="font-medium text-slate-800 text-sm truncate"><?= $aktivitas['nama_aktivitas'] ?></p>
                    <p class="text-xs text-slate-500"><?= date('d M Y', strtotime($aktivitas['tanggal'])) ?></p>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        <?php else: ?>
        <p class="text-slate-500 text-sm text-center py-4">Belum ada aktivitas</p>
        <?php endif; ?>
    </div>
</div>

<!-- Welcome Card -->
<div class="bg-gradient-to-r from-primary-500 to-primary-600 rounded-2xl p-6 text-white">
    <div class="flex items-center justify-between">
        <div>
            <h2 class="text-xl font-bold mb-2">Selamat Datang, <?= session()->get('nama_lengkap') ?? session()->get('username') ?>!</h2>
            <p class="text-primary-100 text-sm">Kelola portfolio digital Anda dengan mudah melalui panel admin ini.</p>
        </div>
        <div class="hidden md:block">
            <i class="ph ph-hand-waving text-6xl text-primary-300"></i>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
