<?= $this->extend('layout/admin') ?>

<?= $this->section('content') ?>
<div class="space-y-6">
    <!-- Header with Tabs -->
    <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
        <div class="p-6 border-b border-slate-200">
            <h2 class="text-lg font-semibold text-slate-800">Kelola Biodata</h2>
            <p class="text-sm text-slate-500">Kelola profil, bahasa pemrograman, dan sertifikat</p>
        </div>
        
        <!-- Navigation Tabs -->
        <div class="flex border-b border-slate-200 bg-slate-50">
            <a href="<?= base_url('admin/biodata') ?>" 
               class="px-6 py-4 font-medium text-sm border-b-2 transition-colors <?= uri_string() === 'admin/biodata' ? 'border-primary-500 text-primary-600 bg-white' : 'border-transparent text-slate-500 hover:text-slate-700' ?>">
                <i class="ph ph-user mr-2"></i>Profil
            </a>
            <a href="<?= base_url('admin/bahasa') ?>" 
               class="px-6 py-4 font-medium text-sm border-b-2 transition-colors <?= str_contains(uri_string(), 'admin/bahasa') ? 'border-primary-500 text-primary-600 bg-white' : 'border-transparent text-slate-500 hover:text-slate-700' ?>">
                <i class="ph ph-code mr-2"></i>Bahasa Pemrograman
            </a>
            <a href="<?= base_url('admin/sertifikat') ?>" 
               class="px-6 py-4 font-medium text-sm border-b-2 transition-colors <?= str_contains(uri_string(), 'admin/sertifikat') ? 'border-primary-500 text-primary-600 bg-white' : 'border-transparent text-slate-500 hover:text-slate-700' ?>">
                <i class="ph ph-certificate mr-2"></i>Sertifikat
            </a>
        </div>
    </div>

    <?php if ($biodata): ?>
    <!-- Biodata Card -->
    <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
        <div class="p-6 border-b border-slate-200 flex items-center justify-between">
            <h3 class="font-semibold text-slate-800">Data Profil</h3>
            <a href="<?= base_url('admin/biodata/edit') ?>" class="inline-flex items-center px-4 py-2 bg-primary-500 text-white rounded-xl hover:bg-primary-600 transition-colors">
                <i class="ph ph-pencil-simple mr-2"></i>
                Edit Profil
            </a>
        </div>
        <div class="p-6">
            <div class="flex flex-col md:flex-row gap-8">
                <!-- Photo -->
                <div class="flex-shrink-0">
                    <div class="w-32 h-32 rounded-2xl overflow-hidden bg-slate-100">
                        <?php if ($biodata['foto_profil']): ?>
                        <img src="<?= base_url('uploads/biodata/' . $biodata['foto_profil']) ?>" alt="Foto Profil" class="w-full h-full object-cover">
                        <?php else: ?>
                        <div class="w-full h-full flex items-center justify-center">
                            <i class="ph ph-user text-4xl text-slate-400"></i>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Info -->
                <div class="flex-1 grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-xs text-slate-500 uppercase tracking-wider mb-1">Nama Lengkap</label>
                        <p class="text-slate-800 font-medium"><?= $biodata['nama_lengkap'] ?></p>
                    </div>
                    <div>
                        <label class="block text-xs text-slate-500 uppercase tracking-wider mb-1">Email</label>
                        <p class="text-slate-800"><?= $biodata['email'] ?></p>
                    </div>
                    <div>
                        <label class="block text-xs text-slate-500 uppercase tracking-wider mb-1">No. HP</label>
                        <p class="text-slate-800"><?= $biodata['no_hp'] ?? '-' ?></p>
                    </div>
                    <div>
                        <label class="block text-xs text-slate-500 uppercase tracking-wider mb-1">Alamat</label>
                        <p class="text-slate-800"><?= $biodata['alamat'] ?? '-' ?></p>
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-xs text-slate-500 uppercase tracking-wider mb-1">Deskripsi Diri</label>
                        <p class="text-slate-800"><?= $biodata['deskripsi_diri'] ?? '-' ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php else: ?>
    <!-- Empty State -->
    <div class="bg-white rounded-2xl shadow-sm border border-slate-200 p-12 text-center">
        <div class="w-16 h-16 bg-slate-100 rounded-full flex items-center justify-center mx-auto mb-4">
            <i class="ph ph-user-circle text-3xl text-slate-400"></i>
        </div>
        <h3 class="text-lg font-semibold text-slate-800 mb-2">Belum Ada Data Biodata</h3>
        <p class="text-slate-500 mb-6">Silakan tambahkan data biodata Anda.</p>
        <a href="<?= base_url('admin/biodata/edit') ?>" class="inline-flex items-center px-6 py-3 bg-primary-500 text-white rounded-xl hover:bg-primary-600 transition-colors">
            <i class="ph ph-plus mr-2"></i>
            Tambah Biodata
        </a>
    </div>
    <?php endif; ?>
</div>
<?= $this->endSection() ?>
