<?= $this->extend('layout/admin') ?>

<?= $this->section('content') ?>
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Form Section -->
    <div class="lg:col-span-2">
        <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
            <div class="p-6 border-b border-slate-200 bg-gradient-to-r from-teal-500 to-emerald-500">
                <h2 class="font-semibold text-white flex items-center">
                    <i class="ph ph-user-circle text-xl mr-2"></i>
                    Edit Biodata
                </h2>
                <p class="text-teal-100 text-sm mt-1">Perbarui informasi profil Anda</p>
            </div>
            
            <form action="<?= base_url('admin/biodata/update') ?>" method="POST" enctype="multipart/form-data" class="p-6">
                <?= csrf_field() ?>
                
                <?php if (session()->getFlashdata('errors')): ?>
                <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-xl">
                    <ul class="list-disc list-inside text-sm text-red-600">
                        <?php foreach (session()->getFlashdata('errors') as $error): ?>
                        <li><?= $error ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>

                <div class="space-y-5">
                    <!-- Photo -->
                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-camera text-teal-500 mr-1"></i>
                            Foto Profil
                        </label>
                        <div class="flex items-center gap-4">
                            <div class="w-24 h-24 rounded-xl overflow-hidden bg-slate-100 border-2 border-dashed border-slate-200">
                                <?php if ($biodata && $biodata['foto_profil']): ?>
                                <img src="<?= base_url('uploads/biodata/' . $biodata['foto_profil']) ?>" alt="Foto" class="w-full h-full object-cover" id="preview-image">
                                <?php else: ?>
                                <div class="w-full h-full flex items-center justify-center" id="placeholder">
                                    <i class="ph ph-user text-3xl text-slate-400"></i>
                                </div>
                                <img src="" alt="Preview" class="w-full h-full object-cover hidden" id="preview-image">
                                <?php endif; ?>
                            </div>
                            <div class="flex-1">
                                <input type="file" name="foto_profil" id="foto_profil" accept="image/*" class="hidden" onchange="previewFile(this)">
                                <label for="foto_profil" class="inline-flex items-center px-4 py-2.5 bg-teal-50 text-teal-700 rounded-xl hover:bg-teal-100 transition-colors cursor-pointer border border-teal-200">
                                    <i class="ph ph-upload-simple mr-2"></i>
                                    Pilih Foto
                                </label>
                                <p class="text-xs text-slate-500 mt-2">JPG, PNG, GIF. Maks 2MB.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Name -->
                    <div>
                        <label for="nama_lengkap" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-user text-teal-500 mr-1"></i>
                            Nama Lengkap <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="nama_lengkap" id="nama_lengkap" value="<?= old('nama_lengkap', $biodata['nama_lengkap'] ?? '') ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-teal-500 focus:ring-2 focus:ring-teal-500/20 transition-all" placeholder="Masukkan nama lengkap" required>
                    </div>

                    <!-- Email & Phone -->
                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                        <div>
                            <label for="email" class="block text-sm font-medium text-slate-700 mb-2">
                                <i class="ph ph-envelope text-teal-500 mr-1"></i>
                                Email <span class="text-red-500">*</span>
                            </label>
                            <input type="email" name="email" id="email" value="<?= old('email', $biodata['email'] ?? '') ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-teal-500 focus:ring-2 focus:ring-teal-500/20 transition-all" placeholder="email@example.com" required>
                        </div>
                        <div>
                            <label for="no_hp" class="block text-sm font-medium text-slate-700 mb-2">
                                <i class="ph ph-phone text-teal-500 mr-1"></i>
                                No. Handphone
                            </label>
                            <input type="text" name="no_hp" id="no_hp" value="<?= old('no_hp', $biodata['no_hp'] ?? '') ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-teal-500 focus:ring-2 focus:ring-teal-500/20 transition-all" placeholder="08xxxxxxxxxx">
                        </div>
                    </div>

                    <!-- Address -->
                    <div>
                        <label for="alamat" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-map-pin text-teal-500 mr-1"></i>
                            Alamat
                        </label>
                        <textarea name="alamat" id="alamat" rows="3" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-teal-500 focus:ring-2 focus:ring-teal-500/20 transition-all resize-none" placeholder="Alamat lengkap"><?= old('alamat', $biodata['alamat'] ?? '') ?></textarea>
                    </div>

                    <!-- Description -->
                    <div>
                        <label for="deskripsi_diri" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-article text-teal-500 mr-1"></i>
                            Deskripsi Diri
                        </label>
                        <textarea name="deskripsi_diri" id="deskripsi_diri" rows="4" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-teal-500 focus:ring-2 focus:ring-teal-500/20 transition-all resize-none" placeholder="Ceritakan tentang diri Anda..."><?= old('deskripsi_diri', $biodata['deskripsi_diri'] ?? '') ?></textarea>
                    </div>
                </div>

                <div class="flex items-center justify-end gap-3 mt-8 pt-6 border-t border-slate-200">
                    <a href="<?= base_url('admin/biodata') ?>" class="px-6 py-3 text-slate-600 hover:bg-slate-100 rounded-xl transition-colors flex items-center">
                        <i class="ph ph-x mr-2"></i>
                        Batal
                    </a>
                    <button type="submit" class="px-6 py-3 bg-gradient-to-r from-teal-500 to-emerald-500 text-white rounded-xl hover:from-teal-600 hover:to-emerald-600 transition-all shadow-lg shadow-teal-500/25 flex items-center">
                        <i class="ph ph-floppy-disk mr-2"></i>
                        Simpan Perubahan
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Decorative Right Panel -->
    <div class="hidden lg:block">
        <div class="sticky top-24 space-y-6">
            <!-- Profile Preview Card -->
            <div class="bg-gradient-to-br from-teal-500 to-emerald-600 rounded-2xl p-6 text-white shadow-xl shadow-teal-500/20">
                <div class="w-20 h-20 bg-white/20 rounded-full flex items-center justify-center mx-auto mb-4 overflow-hidden">
                    <?php if ($biodata && $biodata['foto_profil']): ?>
                    <img src="<?= base_url('uploads/biodata/' . $biodata['foto_profil']) ?>" alt="Foto" class="w-full h-full object-cover">
                    <?php else: ?>
                    <i class="ph ph-user text-4xl"></i>
                    <?php endif; ?>
                </div>
                <h3 class="text-xl font-bold text-center mb-1"><?= $biodata['nama_lengkap'] ?? 'Nama Anda' ?></h3>
                <p class="text-teal-100 text-sm text-center"><?= $biodata['email'] ?? 'email@example.com' ?></p>
            </div>

            <!-- Tips Card -->
            <div class="bg-white rounded-2xl p-6 border border-slate-200 shadow-sm">
                <h4 class="font-semibold text-slate-800 mb-4 flex items-center">
                    <i class="ph ph-lightbulb text-amber-500 text-xl mr-2"></i>
                    Tips Profil Menarik
                </h4>
                <ul class="space-y-3 text-sm text-slate-600">
                    <li class="flex items-start">
                        <i class="ph ph-check-circle text-green-500 mt-0.5 mr-2 flex-shrink-0"></i>
                        <span>Gunakan foto profil yang profesional</span>
                    </li>
                    <li class="flex items-start">
                        <i class="ph ph-check-circle text-green-500 mt-0.5 mr-2 flex-shrink-0"></i>
                        <span>Tulis deskripsi yang menarik dan singkat</span>
                    </li>
                    <li class="flex items-start">
                        <i class="ph ph-check-circle text-green-500 mt-0.5 mr-2 flex-shrink-0"></i>
                        <span>Pastikan email aktif untuk dihubungi</span>
                    </li>
                    <li class="flex items-start">
                        <i class="ph ph-check-circle text-green-500 mt-0.5 mr-2 flex-shrink-0"></i>
                        <span>Lengkapi semua informasi kontak</span>
                    </li>
                </ul>
            </div>

            <!-- Stats Card -->
            <div class="bg-white rounded-2xl p-6 border border-slate-200 shadow-sm">
                <h4 class="font-semibold text-slate-800 mb-4 flex items-center">
                    <i class="ph ph-chart-bar text-blue-500 text-xl mr-2"></i>
                    Kelengkapan Profil
                </h4>
                <?php 
                $filled = 0;
                $total = 5;
                if (!empty($biodata['nama_lengkap'])) $filled++;
                if (!empty($biodata['email'])) $filled++;
                if (!empty($biodata['no_hp'])) $filled++;
                if (!empty($biodata['alamat'])) $filled++;
                if (!empty($biodata['deskripsi_diri'])) $filled++;
                $percentage = ($filled / $total) * 100;
                ?>
                <div class="relative pt-1">
                    <div class="flex mb-2 items-center justify-between">
                        <div>
                            <span class="text-xs font-semibold inline-block text-teal-600"><?= $filled ?>/<?= $total ?> terisi</span>
                        </div>
                        <div class="text-right">
                            <span class="text-xs font-semibold inline-block text-teal-600"><?= $percentage ?>%</span>
                        </div>
                    </div>
                    <div class="overflow-hidden h-2 text-xs flex rounded-full bg-slate-100">
                        <div style="width:<?= $percentage ?>%" class="shadow-none flex flex-col text-center whitespace-nowrap text-white justify-center bg-gradient-to-r from-teal-500 to-emerald-500"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function previewFile(input) {
    const file = input.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            const preview = document.getElementById('preview-image');
            const placeholder = document.getElementById('placeholder');
            preview.src = e.target.result;
            preview.classList.remove('hidden');
            if (placeholder) placeholder.classList.add('hidden');
        }
        reader.readAsDataURL(file);
    }
}
</script>
<?= $this->endSection() ?>
