<?= $this->extend('layout/admin') ?>

<?= $this->section('content') ?>
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Form Section -->
    <div class="lg:col-span-2">
        <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
            <div class="p-6 border-b border-slate-200 bg-gradient-to-r from-green-500 to-emerald-600">
                <h2 class="font-semibold text-white flex items-center">
                    <i class="ph ph-images text-xl mr-2"></i>
                    Tambah Aktivitas
                </h2>
                <p class="text-green-100 text-sm mt-1">Dokumentasikan kegiatan dan momen penting</p>
            </div>
            
            <form action="<?= base_url('admin/aktivitas/store') ?>" method="POST" enctype="multipart/form-data" class="p-6">
                <?= csrf_field() ?>
                
                <?php if (session()->getFlashdata('errors')): ?>
                <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-xl">
                    <ul class="list-disc list-inside text-sm text-red-600">
                        <?php foreach (session()->getFlashdata('errors') as $error): ?>
                        <li><?= $error ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>

                <div class="space-y-5" x-data="{ tipe: '<?= old('tipe', 'foto') ?>' }">
                    <!-- Tipe Selection -->
                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-selection-all text-green-500 mr-1"></i>
                            Tipe Media <span class="text-red-500">*</span>
                        </label>
                        <div class="flex gap-4">
                            <label class="flex-1 cursor-pointer">
                                <input type="radio" name="tipe" value="foto" x-model="tipe" class="sr-only">
                                <div :class="tipe === 'foto' ? 'border-green-500 bg-green-50' : 'border-slate-200 bg-slate-50'" class="border-2 rounded-xl p-4 text-center transition-all">
                                    <i class="ph ph-image text-2xl mb-2" :class="tipe === 'foto' ? 'text-green-600' : 'text-slate-400'"></i>
                                    <p class="font-medium" :class="tipe === 'foto' ? 'text-green-600' : 'text-slate-600'">Foto</p>
                                </div>
                            </label>
                            <label class="flex-1 cursor-pointer">
                                <input type="radio" name="tipe" value="video" x-model="tipe" class="sr-only">
                                <div :class="tipe === 'video' ? 'border-green-500 bg-green-50' : 'border-slate-200 bg-slate-50'" class="border-2 rounded-xl p-4 text-center transition-all">
                                    <i class="ph ph-video text-2xl mb-2" :class="tipe === 'video' ? 'text-green-600' : 'text-slate-400'"></i>
                                    <p class="font-medium" :class="tipe === 'video' ? 'text-green-600' : 'text-slate-600'">Video</p>
                                </div>
                            </label>
                        </div>
                    </div>

                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label for="tanggal" class="block text-sm font-medium text-slate-700 mb-2">
                                <i class="ph ph-calendar text-green-500 mr-1"></i>
                                Tanggal <span class="text-red-500">*</span>
                            </label>
                            <input type="date" name="tanggal" id="tanggal" value="<?= old('tanggal', date('Y-m-d')) ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-green-500 focus:ring-2 focus:ring-green-500/20 transition-all" required>
                        </div>
                        <div>
                            <label for="jam" class="block text-sm font-medium text-slate-700 mb-2">
                                <i class="ph ph-clock text-green-500 mr-1"></i>
                                Jam <span class="text-red-500">*</span>
                            </label>
                            <input type="time" name="jam" id="jam" value="<?= old('jam', date('H:i')) ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-green-500 focus:ring-2 focus:ring-green-500/20 transition-all" required>
                        </div>
                    </div>

                    <div>
                        <label for="nama_aktivitas" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-text-t text-green-500 mr-1"></i>
                            Nama Aktivitas <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="nama_aktivitas" id="nama_aktivitas" value="<?= old('nama_aktivitas') ?>" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-green-500 focus:ring-2 focus:ring-green-500/20 transition-all" placeholder="Contoh: Liburan ke Bali" required>
                    </div>

                    <div>
                        <label for="deskripsi" class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-article text-green-500 mr-1"></i>
                            Deskripsi
                        </label>
                        <textarea name="deskripsi" id="deskripsi" rows="3" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:border-green-500 focus:ring-2 focus:ring-green-500/20 transition-all resize-none" placeholder="Ceritakan detail aktivitas..."><?= old('deskripsi') ?></textarea>
                    </div>

                    <!-- Foto Upload -->
                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-image text-green-500 mr-1"></i>
                            <span x-text="tipe === 'video' ? 'Thumbnail' : 'Foto'"></span>
                        </label>
                        <div class="flex items-center gap-4">
                            <div class="w-24 h-24 rounded-xl overflow-hidden bg-slate-100 flex items-center justify-center border-2 border-dashed border-slate-200" id="foto-preview">
                                <i class="ph ph-image text-3xl text-slate-400"></i>
                            </div>
                            <div class="flex-1">
                                <input type="file" name="foto" id="foto" accept="image/*" class="hidden" onchange="previewFoto(this)">
                                <label for="foto" class="inline-flex items-center px-4 py-2.5 bg-green-50 text-green-700 rounded-xl hover:bg-green-100 transition-colors cursor-pointer border border-green-200">
                                    <i class="ph ph-upload-simple mr-2"></i>
                                    Pilih Gambar
                                </label>
                                <p class="text-xs text-slate-500 mt-2">JPG, PNG. Maks 2MB.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Video Upload -->
                    <div x-show="tipe === 'video'" x-transition>
                        <label class="block text-sm font-medium text-slate-700 mb-2">
                            <i class="ph ph-video text-green-500 mr-1"></i>
                            File Video <span class="text-red-500">*</span>
                        </label>
                        <div class="border-2 border-dashed border-slate-200 rounded-xl p-6 text-center hover:border-green-400 transition-colors">
                            <input type="file" name="video" id="video" accept="video/*" class="hidden">
                            <label for="video" class="cursor-pointer">
                                <i class="ph ph-video text-4xl text-slate-400 mb-2"></i>
                                <p class="text-slate-600">Klik untuk upload video</p>
                                <p class="text-xs text-slate-400 mt-1">MP4, WEBM. Maks 50MB.</p>
                            </label>
                        </div>
                    </div>
                </div>

                <div class="flex items-center justify-end gap-3 mt-8 pt-6 border-t border-slate-200">
                    <a href="<?= base_url('admin/aktivitas') ?>" class="px-6 py-3 text-slate-600 hover:bg-slate-100 rounded-xl transition-colors flex items-center">
                        <i class="ph ph-x mr-2"></i>
                        Batal
                    </a>
                    <button type="submit" class="px-6 py-3 bg-gradient-to-r from-green-500 to-emerald-600 text-white rounded-xl hover:from-green-600 hover:to-emerald-700 transition-all shadow-lg shadow-green-500/25 flex items-center">
                        <i class="ph ph-floppy-disk mr-2"></i>
                        Simpan
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Decorative Right Panel -->
    <div class="hidden lg:block">
        <div class="sticky top-24 space-y-6">
            <!-- Info Card -->
            <div class="bg-gradient-to-br from-green-500 to-emerald-600 rounded-2xl p-6 text-white shadow-xl shadow-green-500/20">
                <div class="w-16 h-16 bg-white/20 rounded-2xl flex items-center justify-center mb-4">
                    <i class="ph ph-camera text-4xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-2">Dokumentasi Aktivitas</h3>
                <p class="text-green-100 text-sm leading-relaxed">
                    Abadikan momen berharga Anda melalui foto atau video untuk melengkapi portfolio.
                </p>
            </div>

            <!-- Tips Card -->
            <div class="bg-white rounded-2xl p-6 border border-slate-200 shadow-sm">
                <h4 class="font-semibold text-slate-800 mb-4 flex items-center">
                    <i class="ph ph-lightbulb text-amber-500 text-xl mr-2"></i>
                    Tips Upload
                </h4>
                <ul class="space-y-3 text-sm text-slate-600">
                    <li class="flex items-start">
                        <i class="ph ph-check-circle text-green-500 mt-0.5 mr-2 flex-shrink-0"></i>
                        <span>Gunakan foto dengan resolusi tinggi</span>
                    </li>
                    <li class="flex items-start">
                        <i class="ph ph-check-circle text-green-500 mt-0.5 mr-2 flex-shrink-0"></i>
                        <span>Pilih thumbnail yang menarik untuk video</span>
                    </li>
                    <li class="flex items-start">
                        <i class="ph ph-check-circle text-green-500 mt-0.5 mr-2 flex-shrink-0"></i>
                        <span>Tulis deskripsi yang informatif</span>
                    </li>
                    <li class="flex items-start">
                        <i class="ph ph-check-circle text-green-500 mt-0.5 mr-2 flex-shrink-0"></i>
                        <span>Pastikan tanggal dan waktu akurat</span>
                    </li>
                </ul>
            </div>

            <!-- Format Card -->
            <div class="bg-white rounded-2xl p-6 border border-slate-200 shadow-sm">
                <h4 class="font-semibold text-slate-800 mb-4 flex items-center">
                    <i class="ph ph-file-image text-blue-500 text-xl mr-2"></i>
                    Format Didukung
                </h4>
                <div class="space-y-3">
                    <div class="flex items-center justify-between p-3 bg-slate-50 rounded-lg">
                        <span class="text-slate-600 flex items-center">
                            <i class="ph ph-image text-green-500 mr-2"></i> Foto
                        </span>
                        <span class="text-xs font-medium text-slate-500">JPG, PNG</span>
                    </div>
                    <div class="flex items-center justify-between p-3 bg-slate-50 rounded-lg">
                        <span class="text-slate-600 flex items-center">
                            <i class="ph ph-video text-blue-500 mr-2"></i> Video
                        </span>
                        <span class="text-xs font-medium text-slate-500">MP4, WEBM</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function previewFoto(input) {
    const file = input.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            document.getElementById('foto-preview').innerHTML = `<img src="${e.target.result}" class="w-full h-full object-cover">`;
        }
        reader.readAsDataURL(file);
    }
}
</script>
<?= $this->endSection() ?>
