<?php

namespace App\Models;

use CodeIgniter\Model;

class BahasaModel extends Model
{
    protected $table            = 'tb_bahasa';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['nama_bahasa', 'tingkat', 'icon_class', 'warna', 'urutan'];

    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules = [
        'nama_bahasa' => 'required|min_length[1]|max_length[100]',
        'tingkat'     => 'required|in_list[Pemula,Menengah,Mahir,Expert]',
    ];

    protected $validationMessages = [
        'nama_bahasa' => [
            'required' => 'Nama bahasa wajib diisi',
        ],
        'tingkat' => [
            'required' => 'Tingkat keahlian wajib dipilih',
        ],
    ];

    public function getAllOrdered()
    {
        return $this->orderBy('urutan', 'ASC')->findAll();
    }

    public function getTingkatList()
    {
        return ['Pemula', 'Menengah', 'Mahir', 'Expert'];
    }

    // Programming language icons mapping
    public function getIconOptions()
    {
        return [
            'php' => ['name' => 'PHP', 'color' => '#777BB4'],
            'javascript' => ['name' => 'JavaScript', 'color' => '#F7DF1E'],
            'python' => ['name' => 'Python', 'color' => '#3776AB'],
            'java' => ['name' => 'Java', 'color' => '#007396'],
            'csharp' => ['name' => 'C#', 'color' => '#239120'],
            'cpp' => ['name' => 'C++', 'color' => '#00599C'],
            'html' => ['name' => 'HTML', 'color' => '#E34F26'],
            'css' => ['name' => 'CSS', 'color' => '#1572B6'],
            'typescript' => ['name' => 'TypeScript', 'color' => '#3178C6'],
            'react' => ['name' => 'React', 'color' => '#61DAFB'],
            'vue' => ['name' => 'Vue.js', 'color' => '#4FC08D'],
            'nodejs' => ['name' => 'Node.js', 'color' => '#339933'],
            'laravel' => ['name' => 'Laravel', 'color' => '#FF2D20'],
            'codeigniter' => ['name' => 'CodeIgniter', 'color' => '#EF4223'],
            'mysql' => ['name' => 'MySQL', 'color' => '#4479A1'],
            'mongodb' => ['name' => 'MongoDB', 'color' => '#47A248'],
            'git' => ['name' => 'Git', 'color' => '#F05032'],
            'flutter' => ['name' => 'Flutter', 'color' => '#02569B'],
            'dart' => ['name' => 'Dart', 'color' => '#0175C2'],
            'kotlin' => ['name' => 'Kotlin', 'color' => '#7F52FF'],
            'swift' => ['name' => 'Swift', 'color' => '#F05138'],
            'go' => ['name' => 'Go', 'color' => '#00ADD8'],
            'rust' => ['name' => 'Rust', 'color' => '#000000'],
            'ruby' => ['name' => 'Ruby', 'color' => '#CC342D'],
        ];
    }
}
