<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    public function run()
    {
        // Seed Admin User
        $this->db->table('users')->insert([
            'username'     => 'admin',
            'email'        => 'admin@ilham.com',
            'password'     => password_hash('admin123', PASSWORD_DEFAULT),
            'nama_lengkap' => 'Administrator',
            'created_at'   => date('Y-m-d H:i:s'),
            'updated_at'   => date('Y-m-d H:i:s'),
        ]);

        // Seed Biodata
        $this->db->table('tb_biodata')->insert([
            'nama_lengkap'   => 'Muhammad Ilham',
            'alamat'         => 'Jl. Contoh No. 123, Jakarta Selatan, Indonesia',
            'email'          => 'ilham@example.com',
            'no_hp'          => '081234567890',
            'deskripsi_diri' => 'Saya adalah seorang mahasiswa jurusan Teknik Informatika yang memiliki passion dalam pengembangan web dan mobile. Saya senang belajar teknologi baru dan memecahkan masalah kompleks dengan solusi kreatif.',
            'foto_profil'    => null,
            'created_at'     => date('Y-m-d H:i:s'),
            'updated_at'     => date('Y-m-d H:i:s'),
        ]);

        // Seed Pendidikan
        $pendidikan = [
            [
                'jenjang'      => 'SD',
                'nama_sekolah' => 'SD Negeri 01 Jakarta',
                'tahun_masuk'  => 2008,
                'tahun_lulus'  => 2014,
                'jurusan'      => null,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s'),
            ],
            [
                'jenjang'      => 'SMP',
                'nama_sekolah' => 'SMP Negeri 05 Jakarta',
                'tahun_masuk'  => 2014,
                'tahun_lulus'  => 2017,
                'jurusan'      => null,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s'),
            ],
            [
                'jenjang'      => 'SMA',
                'nama_sekolah' => 'SMA Negeri 03 Jakarta',
                'tahun_masuk'  => 2017,
                'tahun_lulus'  => 2020,
                'jurusan'      => 'IPA (Ilmu Pengetahuan Alam)',
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s'),
            ],
            [
                'jenjang'      => 'Kuliah',
                'nama_sekolah' => 'Universitas Indonesia',
                'tahun_masuk'  => 2020,
                'tahun_lulus'  => null,
                'jurusan'      => 'S1 Teknik Informatika',
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s'),
            ],
        ];
        $this->db->table('tb_pendidikan')->insertBatch($pendidikan);

        // Seed Aktivitas
        $aktivitas = [
            [
                'tanggal'        => '2024-12-15',
                'jam'            => '09:00:00',
                'nama_aktivitas' => 'Workshop Web Development',
                'foto'           => null,
                'deskripsi'      => 'Mengikuti workshop pengembangan web modern dengan React dan Node.js di kampus.',
                'created_at'     => date('Y-m-d H:i:s'),
                'updated_at'     => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal'        => '2024-12-10',
                'jam'            => '14:00:00',
                'nama_aktivitas' => 'Seminar AI & Machine Learning',
                'foto'           => null,
                'deskripsi'      => 'Menjadi peserta seminar tentang perkembangan terkini AI dan Machine Learning.',
                'created_at'     => date('Y-m-d H:i:s'),
                'updated_at'     => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal'        => '2024-11-25',
                'jam'            => '10:00:00',
                'nama_aktivitas' => 'Hackathon Nasional 2024',
                'foto'           => null,
                'deskripsi'      => 'Berpartisipasi dalam kompetisi hackathon nasional dan berhasil masuk 10 besar.',
                'created_at'     => date('Y-m-d H:i:s'),
                'updated_at'     => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal'        => '2024-11-15',
                'jam'            => '08:30:00',
                'nama_aktivitas' => 'Volunteering Mengajar Coding',
                'foto'           => null,
                'deskripsi'      => 'Mengajar dasar-dasar programming untuk anak-anak SMP di komunitas lokal.',
                'created_at'     => date('Y-m-d H:i:s'),
                'updated_at'     => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal'        => '2024-10-20',
                'jam'            => '13:00:00',
                'nama_aktivitas' => 'Project Collaboration Meeting',
                'foto'           => null,
                'deskripsi'      => 'Rapat kolaborasi proyek aplikasi mobile dengan tim developer dari berbagai universitas.',
                'created_at'     => date('Y-m-d H:i:s'),
                'updated_at'     => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal'        => '2024-10-05',
                'jam'            => '15:30:00',
                'nama_aktivitas' => 'Tech Talk: Cloud Computing',
                'foto'           => null,
                'deskripsi'      => 'Mempresentasikan materi tentang cloud computing dan deployment strategies.',
                'created_at'     => date('Y-m-d H:i:s'),
                'updated_at'     => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal'        => '2024-09-18',
                'jam'            => '09:30:00',
                'nama_aktivitas' => 'Internship di Tech Startup',
                'foto'           => null,
                'deskripsi'      => 'Memulai program magang sebagai backend developer di startup teknologi.',
                'created_at'     => date('Y-m-d H:i:s'),
                'updated_at'     => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal'        => '2024-08-25',
                'jam'            => '11:00:00',
                'nama_aktivitas' => 'Sertifikasi Google Cloud',
                'foto'           => null,
                'deskripsi'      => 'Lulus ujian sertifikasi Google Cloud Associate Cloud Engineer.',
                'created_at'     => date('Y-m-d H:i:s'),
                'updated_at'     => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal'        => '2024-07-10',
                'jam'            => '14:30:00',
                'nama_aktivitas' => 'Open Source Contribution',
                'foto'           => null,
                'deskripsi'      => 'Berkontribusi pada proyek open source populer di GitHub.',
                'created_at'     => date('Y-m-d H:i:s'),
                'updated_at'     => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal'        => '2024-06-15',
                'jam'            => '10:00:00',
                'nama_aktivitas' => 'Bootcamp Full Stack Developer',
                'foto'           => null,
                'deskripsi'      => 'Menyelesaikan bootcamp intensif full stack development selama 3 bulan.',
                'created_at'     => date('Y-m-d H:i:s'),
                'updated_at'     => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal'        => '2024-05-20',
                'jam'            => '16:00:00',
                'nama_aktivitas' => 'Campus Tech Festival',
                'foto'           => null,
                'deskripsi'      => 'Menjadi panitia dan pembicara di festival teknologi kampus.',
                'created_at'     => date('Y-m-d H:i:s'),
                'updated_at'     => date('Y-m-d H:i:s'),
            ],
            [
                'tanggal'        => '2024-04-12',
                'jam'            => '08:00:00',
                'nama_aktivitas' => 'Database Workshop',
                'foto'           => null,
                'deskripsi'      => 'Workshop intensif tentang optimasi database dan query performance.',
                'created_at'     => date('Y-m-d H:i:s'),
                'updated_at'     => date('Y-m-d H:i:s'),
            ],
        ];
        $this->db->table('tb_aktivitas')->insertBatch($aktivitas);

        // Seed Bahasa (Programming Languages)
        $bahasa = [
            [
                'nama_bahasa' => 'PHP',
                'tingkat'     => 'Mahir',
                'icon_class'  => 'php',
                'warna'       => '#777BB4',
                'urutan'      => 1,
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
            [
                'nama_bahasa' => 'JavaScript',
                'tingkat'     => 'Mahir',
                'icon_class'  => 'javascript',
                'warna'       => '#F7DF1E',
                'urutan'      => 2,
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
            [
                'nama_bahasa' => 'Python',
                'tingkat'     => 'Menengah',
                'icon_class'  => 'python',
                'warna'       => '#3776AB',
                'urutan'      => 3,
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
            [
                'nama_bahasa' => 'HTML',
                'tingkat'     => 'Expert',
                'icon_class'  => 'html',
                'warna'       => '#E34F26',
                'urutan'      => 4,
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
            [
                'nama_bahasa' => 'CSS',
                'tingkat'     => 'Mahir',
                'icon_class'  => 'css',
                'warna'       => '#1572B6',
                'urutan'      => 5,
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
            [
                'nama_bahasa' => 'MySQL',
                'tingkat'     => 'Mahir',
                'icon_class'  => 'mysql',
                'warna'       => '#4479A1',
                'urutan'      => 6,
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
            [
                'nama_bahasa' => 'CodeIgniter',
                'tingkat'     => 'Mahir',
                'icon_class'  => 'codeigniter',
                'warna'       => '#EF4223',
                'urutan'      => 7,
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
            [
                'nama_bahasa' => 'Git',
                'tingkat'     => 'Menengah',
                'icon_class'  => 'git',
                'warna'       => '#F05032',
                'urutan'      => 8,
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
        ];
        $this->db->table('tb_bahasa')->insertBatch($bahasa);

        // Seed Sertifikat
        $sertifikat = [
            [
                'nama_sertifikat' => 'Google Cloud Associate Cloud Engineer',
                'penerbit'        => 'Google',
                'tanggal'         => '2024-08-25',
                'file_sertifikat' => null,
                'credential_url'  => 'https://www.credential.net/example',
                'deskripsi'       => 'Sertifikasi resmi dari Google untuk cloud computing.',
                'created_at'      => date('Y-m-d H:i:s'),
                'updated_at'      => date('Y-m-d H:i:s'),
            ],
            [
                'nama_sertifikat' => 'Meta Front-End Developer',
                'penerbit'        => 'Meta (Coursera)',
                'tanggal'         => '2024-06-15',
                'file_sertifikat' => null,
                'credential_url'  => 'https://coursera.org/verify/example',
                'deskripsi'       => 'Professional Certificate untuk pengembangan front-end.',
                'created_at'      => date('Y-m-d H:i:s'),
                'updated_at'      => date('Y-m-d H:i:s'),
            ],
            [
                'nama_sertifikat' => 'AWS Certified Solutions Architect',
                'penerbit'        => 'Amazon Web Services',
                'tanggal'         => '2024-03-10',
                'file_sertifikat' => null,
                'credential_url'  => 'https://aws.amazon.com/verification',
                'deskripsi'       => 'Sertifikasi arsitektur solusi cloud AWS.',
                'created_at'      => date('Y-m-d H:i:s'),
                'updated_at'      => date('Y-m-d H:i:s'),
            ],
        ];
        $this->db->table('tb_sertifikat')->insertBatch($sertifikat);

        // Seed Galeri
        $galeri = [
            [
                'judul'     => 'Workshop Coding di Kampus',
                'deskripsi' => 'Dokumentasi kegiatan workshop coding bersama teman-teman kampus.',
                'tipe'      => 'foto',
                'file'      => null,
                'thumbnail' => null,
                'tanggal'   => '2024-12-15',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'judul'     => 'Hackathon Nasional 2024',
                'deskripsi' => 'Foto bersama tim saat mengikuti hackathon nasional.',
                'tipe'      => 'foto',
                'file'      => null,
                'thumbnail' => null,
                'tanggal'   => '2024-11-25',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'judul'     => 'Demo Project Aplikasi',
                'deskripsi' => 'Video demo aplikasi yang saya kembangkan.',
                'tipe'      => 'video',
                'file'      => null,
                'thumbnail' => null,
                'tanggal'   => '2024-10-20',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
        ];
        $this->db->table('tb_galeri')->insertBatch($galeri);

        echo "Database seeding completed successfully!\n";
    }
}
